/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.AWTError;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class TexturePaintContext
implements PaintContext {
    private BufferedImage image;
    private WritableRaster paintRaster;
    private AffineTransform transform;

    public TexturePaintContext(TexturePaint texturePaint, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform) {
        this.image = texturePaint.getImage();
        try {
            Rectangle2D rectangle2D2 = texturePaint.getAnchorRect();
            BufferedImage bufferedImage = texturePaint.getImage();
            double d = rectangle2D2.getWidth() / (double)bufferedImage.getWidth();
            double d2 = rectangle2D2.getHeight() / (double)bufferedImage.getHeight();
            this.transform = (AffineTransform)affineTransform.clone();
            this.transform.scale(d, d2);
            this.transform.translate(-rectangle2D2.getMinX(), -rectangle2D2.getMinY());
            this.transform = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            AWTError aWTError = new AWTError("Unexpected NoninvertibleTransformException");
            aWTError.initCause(noninvertibleTransformException);
            throw aWTError;
        }
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        this.ensureRasterSize(n3, n4);
        int n5 = n + n3;
        int n6 = n2 + n4;
        float[] fArray = new float[2];
        float[] fArray2 = new float[2];
        Raster raster = this.image.getData();
        int n7 = raster.getMinX();
        int n8 = raster.getWidth();
        int n9 = raster.getMinY();
        int n10 = raster.getHeight();
        Object object = null;
        for (int i = n2; i < n6; ++i) {
            for (int j = n; j < n5; ++j) {
                fArray[0] = j;
                fArray[1] = i;
                this.transform.transform(fArray, 0, fArray2, 0, 1);
                int n11 = (int)fArray2[0];
                int n12 = (int)fArray2[1];
                n11 = (n11 - n7) % n8 + n7;
                n12 = (n12 - n9) % n10 + n9;
                if (n11 < 0) {
                    n11 += n8;
                }
                if (n12 < 0) {
                    n12 += n10;
                }
                object = raster.getDataElements(n11, n12, object);
                this.paintRaster.setDataElements(j - n, i - n2, object);
            }
        }
        return this.paintRaster;
    }

    private void ensureRasterSize(int n, int n2) {
        if (this.paintRaster == null || this.paintRaster.getWidth() < n || this.paintRaster.getHeight() < n2) {
            Raster raster = this.image.getData();
            this.paintRaster = raster.createCompatibleWritableRaster(n, n2);
        }
    }
}

