/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

public final class ScanlineCoverage {
    private Coverage head;
    private Coverage current;
    private Coverage currentPrev;
    private Coverage last;
    private Coverage lastPrev;
    private int minX;
    private int maxX;
    private int maxCoverage;
    private Iterator iterator = new Iterator();

    public void rewind() {
        this.current = this.head;
        this.currentPrev = null;
    }

    public void clear() {
        this.last = this.head;
        this.lastPrev = null;
        this.current = this.head;
        this.currentPrev = null;
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
    }

    public void add(int n, int n2, int n3) {
        Coverage coverage = this.findOrInsert(n);
        coverage.covDelta += n2;
        coverage.pixelCoverage += n3;
        this.minX = Math.min(this.minX, n);
        this.maxX = Math.max(this.maxX, n);
    }

    public int getMaxCoverage() {
        return this.maxCoverage;
    }

    void setMaxCoverage(int n) {
        this.maxCoverage = n;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinX() {
        return this.minX;
    }

    private Coverage findOrInsert(int n) {
        Coverage coverage;
        if (this.head == null) {
            this.head = new Coverage();
            this.head.xPos = n;
            this.current = this.head;
            this.currentPrev = null;
            return this.head;
        }
        Coverage coverage2 = this.current;
        Coverage coverage3 = this.currentPrev;
        while (coverage2 != this.last && coverage2.xPos < n) {
            coverage3 = coverage2;
            coverage2 = coverage2.next;
        }
        if (coverage2 == null) {
            coverage2 = new Coverage();
            coverage2.xPos = n;
            if (coverage3 != null) {
                coverage3.next = coverage2;
            }
            this.current = coverage2;
            this.currentPrev = coverage3;
            return coverage2;
        }
        if (coverage2 == this.last) {
            this.last = coverage2.next;
            this.lastPrev = coverage2;
            coverage2.xPos = n;
            coverage2.covDelta = 0;
            coverage2.pixelCoverage = 0;
            this.current = coverage2;
            this.currentPrev = coverage3;
            return coverage2;
        }
        if (n == coverage2.xPos) {
            this.current = coverage2;
            this.currentPrev = coverage3;
            return coverage2;
        }
        assert (n <= coverage2.xPos);
        assert (coverage3 == null || n > coverage3.xPos);
        if (this.last != null) {
            coverage = this.last;
            this.lastPrev.next = this.last = coverage.next;
        } else {
            coverage = new Coverage();
        }
        coverage.xPos = n;
        coverage.covDelta = 0;
        coverage.pixelCoverage = 0;
        if (coverage3 != null) {
            coverage3.next = coverage;
            coverage.next = coverage2;
            this.current = coverage;
            this.currentPrev = coverage3;
        } else {
            assert (coverage2 == this.head);
            this.head = coverage;
            this.head.next = coverage2;
            this.current = this.head;
            this.currentPrev = null;
        }
        return coverage;
    }

    public Iterator iterate() {
        this.iterator.reset();
        return this.iterator;
    }

    public boolean isEmpty() {
        return this.head == null || this.head == this.last || this.head.next == null || this.head.next == this.last;
    }

    private static final class Coverage {
        int xPos;
        int covDelta;
        int pixelCoverage;
        Coverage next;

        private Coverage() {
        }

        public int getXPos() {
            return this.xPos;
        }

        public int getCoverageDelta() {
            return this.covDelta;
        }

        public String toString() {
            return "Coverage: xPos: " + this.xPos + ", covDelta: " + this.covDelta;
        }

        public String list() {
            String string = this.toString();
            if (this.next != null) {
                string = string + " --> " + this.next.list();
            }
            return string;
        }
    }

    public static final class Range {
        private int xPos;
        private int length;
        private int coverage;

        Range() {
        }

        void setXPos(int n) {
            this.xPos = n;
        }

        public int getXPos() {
            return this.xPos;
        }

        void setLength(int n) {
            this.length = n;
        }

        public int getLength() {
            return this.length;
        }

        public int getXPosEnd() {
            return this.xPos + this.length;
        }

        void setCoverage(int n) {
            this.coverage = n;
        }

        public int getCoverage() {
            return this.coverage;
        }

        public String toString() {
            return "Coverage range: xPos=" + this.xPos + ", length=" + this.length + ", coverage: " + this.coverage;
        }
    }

    public final class Iterator {
        private Range range = new Range();
        private Coverage currentItem;
        private int currentCoverage;
        private boolean handledPixelCoverage;

        Iterator() {
        }

        public Range next() {
            if (!this.handledPixelCoverage) {
                this.range.setXPos(this.currentItem.xPos);
                this.range.setLength(1);
                this.range.setCoverage(this.currentCoverage + this.currentItem.pixelCoverage);
                this.handledPixelCoverage = true;
            } else {
                this.currentCoverage += this.currentItem.covDelta;
                this.range.setCoverage(this.currentCoverage);
                this.range.setXPos(this.currentItem.xPos + 1);
                this.currentItem = this.currentItem.next;
                this.range.setLength(this.currentItem.xPos - this.range.xPos);
                this.handledPixelCoverage = false;
            }
            return this.range;
        }

        public boolean hasNext() {
            boolean bl = this.currentItem != null && !this.handledPixelCoverage ? true : this.currentItem != null && this.currentItem.next != null && this.currentItem.next != ScanlineCoverage.this.last;
            return bl;
        }

        void reset() {
            this.currentItem = ScanlineCoverage.this.head;
            this.currentCoverage = 0;
            this.handledPixelCoverage = false;
        }
    }
}

