/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.ActiveEdges;
import gnu.java.awt.java2d.Pixelizer;
import gnu.java.awt.java2d.PolyEdge;
import gnu.java.awt.java2d.Scanline;
import gnu.java.awt.java2d.ScanlineCoverage;
import gnu.java.math.Fixed;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public final class ScanlineConverter {
    private static int FIXED_DIGITS = 6;
    private static int ONE = Fixed.fixedValue(FIXED_DIGITS, 1.0f);
    private int numScanlines;
    private Scanline[] scanlines = new Scanline[10];
    private int upperBounds;
    private int resolution;
    private int yResolution;
    private int halfStep;
    private float[] coords = new float[6];
    private ActiveEdges activeEdges = new ActiveEdges();
    private PolyEdge edgePool;
    private PolyEdge edgePoolLast = this.edgePool = new PolyEdge();
    private int minY;
    private int maxY;
    private int minX;
    private int maxX;
    private ScanlineCoverage scanlineCoverage = new ScanlineCoverage();

    ScanlineConverter() {
    }

    public void renderShape(Pixelizer pixelizer, Shape shape, Shape shape2, AffineTransform affineTransform, int n, int n2, RenderingHints renderingHints) {
        int n3;
        this.clear();
        this.setResolution(n, n2);
        boolean bl = shape2 != null;
        float f = Fixed.floatValue(FIXED_DIGITS, this.resolution / 2);
        PathIterator pathIterator = shape.getPathIterator(affineTransform, f);
        this.addShape(pathIterator, false);
        if (bl) {
            pathIterator = shape2.getPathIterator(affineTransform, f);
            this.addShape(pathIterator, true);
        }
        this.setUpperBounds(this.minY);
        PolyEdge polyEdge = this.edgePool;
        while (polyEdge != this.edgePoolLast) {
            this.addEdge(polyEdge);
            polyEdge = polyEdge.poolNext;
        }
        this.activeEdges.clear();
        Scanline scanline = null;
        int n4 = Fixed.intValue(FIXED_DIGITS, n3);
        for (n3 = this.upperBounds; n3 <= this.maxY; n3 += this.resolution) {
            int n5 = this.scanlineIndex(n3);
            Scanline scanline2 = scanline = n5 < this.scanlines.length ? this.scanlines[n5] : null;
            if (scanline != null) {
                polyEdge = scanline.getEdges();
                while (polyEdge != null) {
                    this.activeEdges.add(polyEdge);
                    polyEdge = polyEdge.scanlineNext;
                }
            }
            this.activeEdges.intersectSortAndPack(FIXED_DIGITS, n3 + this.halfStep);
            int n6 = Fixed.intValue(FIXED_DIGITS, n3 + this.resolution);
            boolean bl2 = n4 != n6;
            this.doScanline(pixelizer, n3, bl2, bl);
            n4 = n6;
        }
    }

    private void clear() {
        this.edgePoolLast = this.edgePool;
        for (int i = this.scanlines.length - 1; i >= 0; --i) {
            Scanline scanline = this.scanlines[i];
            if (scanline == null) continue;
            scanline.clear();
        }
        this.scanlineCoverage.clear();
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
    }

    private void doScanline(Pixelizer pixelizer, int n, boolean bl, boolean bl2) {
        this.scanlineCoverage.rewind();
        boolean bl3 = !bl2;
        boolean bl4 = false;
        PolyEdge polyEdge = null;
        int n2 = this.activeEdges.getNumActiveEdges();
        for (int i = 0; i < n2; ++i) {
            PolyEdge polyEdge2 = this.activeEdges.getActiveEdge(i);
            if (bl3 && bl4) {
                assert (polyEdge != null);
                int n3 = polyEdge.xIntersection;
                int n4 = polyEdge2.xIntersection;
                assert (n3 <= n4);
                int n5 = Fixed.intValue(FIXED_DIGITS, n3);
                int n6 = Fixed.intValue(FIXED_DIGITS, n4);
                int n7 = ONE - Fixed.trunc(FIXED_DIGITS, n3);
                int n8 = ONE - Fixed.trunc(FIXED_DIGITS, n4);
                this.scanlineCoverage.add(n5, 1 * (1 << this.yResolution), n7 >>= FIXED_DIGITS - this.yResolution);
                this.scanlineCoverage.add(n6, -1 * (1 << this.yResolution), -(n8 >>= FIXED_DIGITS - this.yResolution));
            }
            if (polyEdge2.isClip) {
                bl3 = !bl3;
            } else {
                bl4 = !bl4;
            }
            polyEdge = polyEdge2;
        }
        if (bl && !this.scanlineCoverage.isEmpty()) {
            pixelizer.renderScanline(Fixed.intValue(FIXED_DIGITS, n), this.scanlineCoverage);
            this.scanlineCoverage.clear();
        }
    }

    private void setResolution(int n, int n2) {
        int n3 = 1 << n;
        int n4 = Fixed.fixedValue(FIXED_DIGITS, 1.0f);
        this.resolution = n4 / n3;
        this.halfStep = this.resolution / 2;
        this.scanlineCoverage.setMaxCoverage(n3 << this.yResolution);
        this.yResolution = n2;
    }

    private void setUpperBounds(int n) {
        this.upperBounds = this.fit(n);
    }

    private void addShape(PathIterator pathIterator, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (!pathIterator.isDone()) {
            int n5 = pathIterator.currentSegment(this.coords);
            switch (n5) {
                case 0: {
                    n = n3 = Fixed.fixedValue(FIXED_DIGITS, this.coords[0]);
                    n2 = n4 = Fixed.fixedValue(FIXED_DIGITS, this.coords[1]);
                    this.minY = Math.min(n2, this.minY);
                    this.maxY = Math.max(n2, this.maxY);
                    this.minX = Math.min(n, this.minX);
                    this.maxX = Math.max(n, this.maxX);
                    break;
                }
                case 1: {
                    int n6 = Fixed.fixedValue(FIXED_DIGITS, this.coords[0]);
                    int n7 = Fixed.fixedValue(FIXED_DIGITS, this.coords[1]);
                    this.edgePoolAdd(n3, n4, n6, n7, bl);
                    n3 = n6;
                    n4 = n7;
                    this.minY = Math.min(n4, this.minY);
                    this.maxY = Math.max(n4, this.maxY);
                    this.minX = Math.min(n3, this.minX);
                    this.maxX = Math.max(n3, this.maxX);
                    break;
                }
                case 4: {
                    this.edgePoolAdd(n3, n4, n, n2, bl);
                    n3 = n;
                    n4 = n2;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            pathIterator.next();
        }
    }

    private void addEdge(PolyEdge polyEdge) {
        int n = Math.min(polyEdge.y0, polyEdge.y1);
        int n2 = this.scanlineIndex(n);
        if (n2 >= this.scanlines.length) {
            int n3 = this.scanlines.length;
            int n4 = Math.max(n3 + n3 / 2 + 1, n2 + 10);
            Scanline[] scanlineArray = new Scanline[n4];
            System.arraycopy(this.scanlines, 0, scanlineArray, 0, n3);
            this.scanlines = scanlineArray;
        }
        if (this.scanlines[n2] == null) {
            this.scanlines[n2] = new Scanline();
        }
        this.scanlines[n2].addEdge(polyEdge);
    }

    private int fit(int n) {
        int n2 = Fixed.div(FIXED_DIGITS, n, this.resolution);
        int n3 = Fixed.round(FIXED_DIGITS, n2);
        return Fixed.mul(FIXED_DIGITS, n3, this.resolution);
    }

    private int scanlineIndex(int n) {
        int n2 = this.fit(n);
        return (n2 - this.upperBounds) / this.resolution;
    }

    private void edgePoolAdd(int n, int n2, int n3, int n4, boolean bl) {
        if (n2 != n4) {
            this.edgePoolLast.init(FIXED_DIGITS, n, n2, n3, n4, bl);
            if (this.edgePoolLast.poolNext == null) {
                this.edgePoolLast.poolNext = new PolyEdge();
            }
            this.edgePoolLast = this.edgePoolLast.poolNext;
        }
    }
}

