/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.math.Fixed;

final class PolyEdge
implements Comparable {
    public int x0;
    public int y0;
    public int x1;
    public int y1;
    private int slope;
    int xIntersection;
    boolean isClip;
    PolyEdge poolNext;
    PolyEdge scanlineNext;

    PolyEdge() {
    }

    PolyEdge(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.init(n, n2, n3, n4, n5, bl);
    }

    void init(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.isClip = bl;
        if (n3 < n5) {
            this.x0 = n2;
            this.y0 = n3;
            this.x1 = n4;
            this.y1 = n5;
        } else {
            this.x0 = n4;
            this.y0 = n5;
            this.x1 = n2;
            this.y1 = n3;
        }
        this.slope = Fixed.div(n, this.x1 - this.x0, this.y1 - this.y0);
    }

    public int compareTo(Object object) {
        PolyEdge polyEdge = (PolyEdge)object;
        int n = 0;
        if (this.x0 < polyEdge.x0) {
            n = -1;
        } else if (this.x0 > polyEdge.x0) {
            n = 1;
        }
        return n;
    }

    void intersect(int n, int n2) {
        int n3 = n2 - this.y0;
        int n4 = Fixed.mul(n, this.slope, n3);
        this.xIntersection = this.x0 + n4;
    }

    public String toString() {
        return "Edge: " + this.x0 + ", " + this.y0 + ", " + this.x1 + ", " + this.y1 + ", slope: " + this.slope + ", xIntersection: " + this.xIntersection + ", isClip: " + this.isClip;
    }
}

