/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.AWTError;
import java.awt.AlphaComposite;
import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class AlphaCompositeContext
implements CompositeContext {
    private AlphaComposite composite;
    private ColorModel srcColorModel;
    private ColorModel dstColorModel;
    private float fs;
    private float fd;

    public AlphaCompositeContext(AlphaComposite alphaComposite, ColorModel colorModel, ColorModel colorModel2) {
        this.composite = alphaComposite;
        this.srcColorModel = colorModel;
        this.dstColorModel = colorModel2;
        switch (this.composite.getRule()) {
            case 1: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 9: {
                this.fs = 0.0f;
                this.fd = 1.0f;
                break;
            }
            case 11: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 6: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 8: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 4: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 2: {
                this.fs = 1.0f;
                this.fd = 0.0f;
                break;
            }
            case 10: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 5: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 7: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 3: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 12: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            default: {
                throw new AWTError("Illegal AlphaComposite rule");
            }
        }
    }

    public void dispose() {
    }

    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = n + n3;
        int n6 = n2 + n4;
        Object object = null;
        Object object2 = null;
        int n7 = this.srcColorModel.getNumComponents();
        if (!this.srcColorModel.hasAlpha()) {
            ++n7;
        }
        float[] fArray = new float[n7];
        int n8 = this.dstColorModel.getNumComponents();
        if (!this.dstColorModel.hasAlpha()) {
            ++n8;
        }
        float[] fArray2 = new float[n8];
        if (n7 != n8) {
            throw new AWTError("The color models of the source and destination haveincompatible number of color components");
        }
        int n9 = this.srcColorModel.getTransferType();
        int n10 = this.dstColorModel.getTransferType();
        for (int i = n2; i < n6; ++i) {
            for (int j = n; j < n5; ++j) {
                int n11;
                int n12;
                object = raster.getDataElements(j, i, (int[])object);
                object2 = raster2.getDataElements(j, i, object2);
                fArray = this.srcColorModel.getNormalizedComponents(object, fArray, 0);
                if (!this.srcColorModel.hasAlpha()) {
                    fArray[n7 - 1] = 1.0f;
                }
                fArray2 = this.dstColorModel.getNormalizedComponents(object2, fArray2, 0);
                if (!this.dstColorModel.hasAlpha()) {
                    fArray2[n8 - 1] = 1.0f;
                }
                float f = this.composite.getAlpha();
                int n13 = n7 - 1;
                fArray[n13] = fArray[n13] * f;
                if (this.srcColorModel.isAlphaPremultiplied()) {
                    n12 = n7 - 2;
                    while (n12 >= 0) {
                        int n14 = n12--;
                        fArray[n14] = fArray[n14] * f;
                    }
                } else {
                    n12 = n7 - 2;
                    while (n12 >= 0) {
                        int n15 = n12--;
                        fArray[n15] = fArray[n15] * fArray[n7 - 1];
                    }
                }
                if (!this.dstColorModel.isAlphaPremultiplied()) {
                    n12 = n8 - 2;
                    while (n12 >= 0) {
                        int n16 = n12--;
                        fArray2[n16] = fArray2[n16] * fArray2[fArray2.length - 1];
                    }
                }
                float f2 = fArray[n7 - 1];
                float f3 = fArray2[n8 - 1];
                switch (this.composite.getRule()) {
                    case 11: {
                        this.fs = 1.0f - f3;
                        this.fd = f2;
                        break;
                    }
                    case 6: {
                        this.fd = f2;
                        break;
                    }
                    case 8: {
                        this.fd = 1.0f - f2;
                        break;
                    }
                    case 4: {
                        this.fs = 1.0f - f3;
                        break;
                    }
                    case 10: {
                        this.fs = f2;
                        this.fd = 1.0f - f2;
                        break;
                    }
                    case 5: {
                        this.fs = f3;
                        break;
                    }
                    case 7: {
                        this.fs = 1.0f - f3;
                        break;
                    }
                    case 3: {
                        this.fd = 1.0f - f2;
                        break;
                    }
                    case 12: {
                        this.fs = 1.0f - f3;
                        this.fd = 1.0f - f2;
                        break;
                    }
                }
                for (n11 = 0; n11 < n7; ++n11) {
                    fArray2[n11] = fArray[n11] * this.fs + fArray2[n11] * this.fd;
                }
                f3 = fArray2[n8 - 1];
                if (!this.dstColorModel.isAlphaPremultiplied() && f3 != 0.0f) {
                    for (n11 = 0; n11 < n8 - 1; ++n11) {
                        fArray2[n11] = fArray2[n11] / f3;
                    }
                }
                object2 = this.dstColorModel.getDataElements(fArray2, 0, object2);
                writableRaster.setDataElements(j, i, object2);
            }
        }
    }
}

