/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.PolyEdge;
import gnu.java.lang.CPStringBuilder;

final class ActiveEdges {
    private PolyEdge[] activeEdges = new PolyEdge[8];
    private int numActiveEdges = 0;

    ActiveEdges() {
    }

    void clear() {
        this.numActiveEdges = 0;
    }

    void add(PolyEdge polyEdge) {
        int n = this.activeEdges.length;
        if (this.numActiveEdges >= n) {
            int n2 = n + n / 4 + 1;
            PolyEdge[] polyEdgeArray = new PolyEdge[n2];
            System.arraycopy(this.activeEdges, 0, polyEdgeArray, 0, n);
            this.activeEdges = polyEdgeArray;
        }
        this.activeEdges[this.numActiveEdges] = polyEdge;
        ++this.numActiveEdges;
    }

    void intersectSortAndPack(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.numActiveEdges; ++i) {
            PolyEdge polyEdge = this.activeEdges[i];
            if (polyEdge == null || polyEdge.y1 < n2) continue;
            assert (polyEdge.y1 >= n2 && polyEdge.y0 <= n2) : "edge must cross scanline";
            polyEdge.intersect(n, n2);
            this.activeEdges[n3] = polyEdge;
            for (int j = ++n3 - 1; j > 0 && this.activeEdges[j].xIntersection < this.activeEdges[j - 1].xIntersection; --j) {
                PolyEdge polyEdge2 = this.activeEdges[j];
                this.activeEdges[j] = this.activeEdges[j - 1];
                this.activeEdges[j - 1] = polyEdge2;
            }
        }
        this.numActiveEdges = n3;
    }

    int getNumActiveEdges() {
        return this.numActiveEdges;
    }

    PolyEdge getActiveEdge(int n) {
        return this.activeEdges[n];
    }

    void remove(int n) {
        for (int i = 0; i < this.numActiveEdges; ++i) {
            PolyEdge polyEdge = this.activeEdges[i];
            if (polyEdge == null || polyEdge.y1 >= n) continue;
            this.activeEdges[i] = null;
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append("[ActiveEdges] ");
        for (int i = 0; i < this.numActiveEdges; ++i) {
            cPStringBuilder.append(this.activeEdges[i]);
            cPStringBuilder.append(',');
        }
        return cPStringBuilder.toString();
    }
}

