/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import gnu.java.awt.image.AsyncImage;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageConverter
implements ImageConsumer {
    public static final String IMAGE_TRANSPARENCY_PROPERTY = "gnu.awt.image.transparency";
    public static final String IMAGE_PROPERTIES_PROPERTY = "gnu.awt.image.properties";
    private AsyncImage image = new AsyncImage();
    private BufferedImage bImage;
    private Hashtable imageProperties;
    private int width = 0;
    private int height = 0;
    private ColorModel colorModel;
    private ColorModel targetColorModel;

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        colorModel = this.setupColorModel(colorModel);
        if (this.bImage == null) {
            this.createImage();
        }
        Integer n7 = (Integer)this.imageProperties.get(IMAGE_TRANSPARENCY_PROPERTY);
        int n8 = n7;
        n8 = this.targetColorModel.equals(colorModel) ? this.transferPixels(n, n2, n3, n4, colorModel, byArray, n5, n6, n8) : (colorModel instanceof IndexColorModel && this.targetColorModel.equals(ColorModel.getRGBdefault()) ? this.convertIndexColorModelToSRGB(n, n2, n3, n4, (IndexColorModel)colorModel, byArray, n5, n6, n8) : this.convertPixels(n, n2, n3, n4, colorModel, byArray, n5, n6, n8));
        this.imageProperties.put(IMAGE_TRANSPARENCY_PROPERTY, n8);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        colorModel = this.setupColorModel(colorModel);
        if (this.bImage == null) {
            this.createImage();
        }
        Integer n7 = (Integer)this.imageProperties.get(IMAGE_TRANSPARENCY_PROPERTY);
        int n8 = n7;
        n8 = this.targetColorModel.equals(colorModel) ? this.transferPixels(n, n2, n3, n4, colorModel, nArray, n5, n6, n8) : (colorModel instanceof IndexColorModel && this.targetColorModel.equals(ColorModel.getRGBdefault()) ? this.convertIndexColorModelToSRGB(n, n2, n3, n4, (IndexColorModel)colorModel, nArray, n5, n6, n8) : this.convertPixels(n, n2, n3, n4, colorModel, nArray, n5, n6, n8));
        this.imageProperties.put(IMAGE_TRANSPARENCY_PROPERTY, n8);
    }

    private ColorModel setupColorModel(ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = this.colorModel;
        }
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        if (this.targetColorModel == null) {
            this.targetColorModel = colorModel;
        }
        this.targetColorModel = ColorModel.getRGBdefault();
        return colorModel;
    }

    private void createImage() {
        if (this.imageProperties == null) {
            this.imageProperties = new Hashtable();
        }
        this.imageProperties.put(IMAGE_TRANSPARENCY_PROPERTY, 1);
        this.imageProperties.put(IMAGE_PROPERTIES_PROPERTY, this.imageProperties);
        if (ColorModel.getRGBdefault().equals(this.targetColorModel)) {
            this.bImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.width, this.height, 3);
        } else {
            WritableRaster writableRaster = this.targetColorModel.createCompatibleWritableRaster(this.width, this.height);
            this.bImage = new BufferedImage(this.targetColorModel, writableRaster, false, this.imageProperties);
        }
        this.image.setRealImage(this.bImage);
    }

    private int transferPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6, int n7) {
        this.bImage.getRaster().setDataElements(n, n2, n3, n4, byArray);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = 0xFF & byArray[i * n6 + j + n5];
                int n9 = colorModel.getAlpha(n8);
                n7 = this.updateTransparency(n9, n7);
            }
        }
        return n7;
    }

    private int transferPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6, int n7) {
        this.bImage.getRaster().setDataElements(n, n2, n3, n4, nArray);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = nArray[i * n6 + j + n5];
                int n9 = colorModel.getAlpha(n8);
                n7 = this.updateTransparency(n9, n7);
            }
        }
        return n7;
    }

    private int convertPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6, int n7) {
        Object object = null;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = 0xFF & byArray[i * n6 + j + n5];
                int n9 = colorModel.getRGB(n8);
                int n10 = colorModel.getAlpha(n8);
                n7 = this.updateTransparency(n10, n7);
                object = this.targetColorModel.getDataElements(n9, object);
                this.bImage.getRaster().setDataElements(n + j, n2 + i, object);
            }
        }
        return n7;
    }

    private int convertPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6, int n7) {
        Object object = null;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = nArray[i * n6 + j + n5];
                int n9 = colorModel.getRGB(n8);
                int n10 = colorModel.getAlpha(n8);
                n7 = this.updateTransparency(n10, n7);
                object = this.targetColorModel.getDataElements(n9, object);
                this.bImage.getRaster().setDataElements(n + j, n2 + i, object);
            }
        }
        return n7;
    }

    private int convertIndexColorModelToSRGB(int n, int n2, int n3, int n4, IndexColorModel indexColorModel, byte[] byArray, int n5, int n6, int n7) {
        int n8 = indexColorModel.getMapSize();
        int[] nArray = new int[n8];
        for (int i = 0; i < n8; ++i) {
            nArray[i] = indexColorModel.getRGB(i);
        }
        WritableRaster writableRaster = this.bImage.getRaster();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n9 = singlePixelPackedSampleModel.getOffset(n, n2) + dataBuffer.getOffset();
        int n10 = singlePixelPackedSampleModel.getScanlineStride();
        for (int i = 0; i < n4; ++i) {
            int n11 = n5;
            for (int j = 0; j < n3; ++j) {
                int n12 = nArray[byArray[n11++] & 0xFF];
                dataBuffer.setElem(n9 + j, n12);
                int n13 = n12 >>> 24;
                n7 = this.updateTransparency(n13, n7);
            }
            n5 += n6;
            n9 += n10;
        }
        return n7;
    }

    private int convertIndexColorModelToSRGB(int n, int n2, int n3, int n4, IndexColorModel indexColorModel, int[] nArray, int n5, int n6, int n7) {
        int n8 = indexColorModel.getMapSize();
        int[] nArray2 = new int[n8];
        for (int i = 0; i < n8; ++i) {
            nArray2[i] = indexColorModel.getRGB(i);
        }
        WritableRaster writableRaster = this.bImage.getRaster();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n9 = singlePixelPackedSampleModel.getOffset(n, n2) + dataBuffer.getOffset();
        int n10 = singlePixelPackedSampleModel.getScanlineStride();
        for (int i = 0; i < n4; ++i) {
            int n11 = n5;
            for (int j = 0; j < n3; ++j) {
                int n12 = nArray2[nArray[n11++]];
                dataBuffer.setElem(n9 + j, n12);
                int n13 = n12 >>> 24;
                n7 = this.updateTransparency(n13, n7);
            }
            n5 += n6;
            n9 += n10;
        }
        return n7;
    }

    private int updateTransparency(int n, int n2) {
        if (n != 255) {
            if (n == 0 && n2 <= 2) {
                n2 = 2;
            } else if (n2 < 3) {
                n2 = 3;
            }
        }
        return n2;
    }

    public void imageComplete(int n) {
        this.image.notifyObservers(32, 0, 0, this.width, this.height);
    }

    public void setTargetColorModel(ColorModel colorModel) {
        this.targetColorModel = colorModel;
    }

    public Image getImage() {
        return this.image;
    }
}

