/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.HashSet;
import java.util.Iterator;

public class AsyncImage
extends Image {
    private volatile Image realImage;
    HashSet<ImageObserver> observers = new HashSet();
    private volatile boolean complete = false;

    AsyncImage() {
    }

    public void flush() {
    }

    public Graphics getGraphics() {
        Image image = this.realImage;
        Graphics graphics = null;
        if (image != null) {
            graphics = image.getGraphics();
        }
        return graphics;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getHeight(ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        int n = -1;
        this.waitForImage(imageObserver);
        Image image = this.realImage;
        if (image != null) {
            n = image.getHeight(imageObserver);
        }
        return n;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        Image image = this.realImage;
        Object object = null;
        if (image != null) {
            object = image.getProperty(string, imageObserver);
        }
        return object;
    }

    public ImageProducer getSource() {
        return new AsyncImageSource();
    }

    public int getWidth(ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        int n = -1;
        this.waitForImage(imageObserver);
        Image image = this.realImage;
        if (image != null) {
            n = image.getWidth(imageObserver);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ImageObserver imageObserver) {
        if (imageObserver != null) {
            AsyncImage asyncImage = this;
            synchronized (asyncImage) {
                HashSet<ImageObserver> hashSet = this.observers;
                if (hashSet != null) {
                    hashSet.add(imageObserver);
                }
            }
        }
    }

    public boolean prepareImage(int n, int n2, ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        return this.realImage != null;
    }

    public int checkImage(int n, int n2, ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        int n3 = 0;
        if (this.realImage != null) {
            n3 = 39;
        }
        return n3;
    }

    public Image getRealImage() {
        return this.realImage;
    }

    public void setRealImage(Image image) {
        this.realImage = image;
        int n = 3;
        this.notifyObservers(n, 0, 0, image.getWidth(null), image.getHeight(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(int n, int n2, int n3, int n4, int n5) {
        AsyncImage asyncImage = this;
        synchronized (asyncImage) {
            HashSet<ImageObserver> hashSet = this.observers;
            if (hashSet != null) {
                Iterator<ImageObserver> iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ImageObserver imageObserver = iterator.next();
                    boolean bl = imageObserver.imageUpdate(this, n, n2, n3, this.realImage.getWidth(imageObserver), this.realImage.getHeight(imageObserver));
                    if (!bl) continue;
                    iterator.remove();
                }
            }
            if ((n & 0x20) != 0) {
                this.complete = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForImage(ImageObserver imageObserver) {
        if (!this.complete && imageObserver == null) {
            AsyncImage asyncImage = this;
            synchronized (asyncImage) {
                while (!this.complete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private class AsyncImageSource
    implements ImageProducer {
        private ImageProducer realSource;

        private AsyncImageSource() {
        }

        public void addConsumer(ImageConsumer imageConsumer) {
            this.startProduction(imageConsumer);
        }

        public boolean isConsumer(ImageConsumer imageConsumer) {
            return false;
        }

        public void removeConsumer(ImageConsumer imageConsumer) {
        }

        public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
            this.startProduction(imageConsumer);
        }

        public void startProduction(ImageConsumer imageConsumer) {
            ImageProducer imageProducer = this.getRealSource();
            if (imageProducer == null) {
                imageConsumer.setDimensions(1, 1);
                imageConsumer.imageComplete(2);
            } else {
                imageProducer.startProduction(imageConsumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ImageProducer getRealSource() {
            AsyncImage asyncImage = AsyncImage.this;
            synchronized (asyncImage) {
                Image image;
                ImageProducer imageProducer = this.realSource;
                if (imageProducer == null && (image = AsyncImage.this.realImage) != null) {
                    this.realSource = imageProducer = image.getSource();
                }
                return imageProducer;
            }
        }
    }
}

