/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.geom.PathIterator;

final class ZonePathIterator
implements PathIterator {
    private static final int EMIT_SEGMENT = 0;
    private static final int EMIT_CLOSE = 1;
    private static final int EMIT_MOVETO = 2;
    private int state;
    private Zone zone;
    private int numPoints;
    private int curPoint;
    private int contourStart;
    private int type;
    float[] floats;

    ZonePathIterator(Zone zone, int n) {
        this.zone = zone;
        this.type = n;
        this.numPoints = zone.getSize() - 4;
        this.state = 2;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.state != 1 && this.curPoint >= this.numPoints;
    }

    public void next() {
        if (this.zone.isContourEnd(this.curPoint) && this.state != 1) {
            this.state = 1;
            return;
        }
        if (this.state == 1) {
            this.contourStart = ++this.curPoint;
            this.state = 2;
            return;
        }
        boolean bl = this.zone.isOnCurve(this.curPoint);
        if (this.state == 2 && !bl) {
            this.state = 0;
            return;
        }
        ++this.curPoint;
        if (!bl && this.zone.isOnCurve(this.curPoint)) {
            if (this.zone.isContourEnd(this.curPoint)) {
                this.state = 1;
                return;
            }
            ++this.curPoint;
        }
        this.state = 0;
    }

    private int getSuccessor(int n) {
        if (this.zone.isContourEnd(n)) {
            return this.contourStart;
        }
        return n + 1;
    }

    public int currentSegment(float[] fArray) {
        switch (this.state) {
            case 1: {
                return 4;
            }
            case 2: {
                return this.getStartSegment(this.curPoint, fArray);
            }
        }
        return this.getSegment(this.curPoint, fArray);
    }

    public int currentSegment(double[] dArray) {
        if (this.floats == null) {
            this.floats = new float[6];
        }
        int n = this.currentSegment(this.floats);
        for (int i = 0; i < 6; ++i) {
            dArray[i] = this.floats[i];
        }
        return n;
    }

    private int getSegment(int n, float[] fArray) {
        int n2 = this.zone.getX(n, this.type);
        int n3 = this.zone.getY(n, this.type);
        fArray[0] = Fixed.floatValue(n2);
        fArray[1] = Fixed.floatValue(n3);
        if (this.zone.isOnCurve(n)) {
            return 1;
        }
        int n4 = this.getSuccessor(n);
        int n5 = this.zone.getX(n4, this.type);
        int n6 = this.zone.getY(n4, this.type);
        if (this.zone.isOnCurve(n4)) {
            fArray[2] = Fixed.floatValue(n5);
            fArray[3] = Fixed.floatValue(n6);
        } else {
            fArray[2] = Fixed.floatValue((n2 + n5) / 2);
            fArray[3] = Fixed.floatValue((n3 + n6) / 2);
        }
        return 2;
    }

    private int getStartSegment(int n, float[] fArray) {
        int n2;
        int n3;
        if (this.zone.isOnCurve(n)) {
            n3 = this.zone.getX(n, this.type);
            n2 = this.zone.getY(n, this.type);
        } else {
            int n4 = n;
            while (!this.zone.isContourEnd(n4)) {
                ++n4;
            }
            if (this.zone.isOnCurve(n4)) {
                n3 = this.zone.getX(n4, this.type);
                n2 = this.zone.getY(n4, this.type);
            } else {
                n3 = (this.zone.getX(n, this.type) + this.zone.getX(n4, this.type)) / 2;
                n2 = (this.zone.getY(n, this.type) + this.zone.getY(n4, this.type)) / 2;
            }
        }
        fArray[0] = Fixed.floatValue(n3);
        fArray[1] = Fixed.floatValue(n2);
        return 0;
    }
}

