/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Point;
import gnu.java.awt.font.opentype.truetype.ZonePathIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public final class Zone {
    private Point[] points;
    private int numPoints;
    public double scaleX;
    public double scaleY;
    public double shearX;
    public double shearY;

    public Zone(int n) {
        this.points = new Point[n];
    }

    public int getCapacity() {
        return this.points.length;
    }

    public int getSize() {
        return this.numPoints;
    }

    public int getX(int n) {
        return this.getX(n, 1);
    }

    public int getX(int n, int n2) {
        int n3 = (n2 & 1) != 0 ? this.points[n].x : this.points[n].scaledX;
        return n3;
    }

    public void setX(int n, int n2, boolean bl) {
        this.points[n].scaledX = n2;
        this.points[n].x = n2;
        if (bl) {
            this.points[n].flags = (short)(this.points[n].flags | 1);
        }
    }

    public void setY(int n, int n2, boolean bl) {
        this.points[n].scaledY = n2;
        this.points[n].y = n2;
        if (bl) {
            this.points[n].flags = (short)(this.points[n].flags | 2);
        }
    }

    public int getY(int n) {
        return this.getY(n, 1);
    }

    public int getY(int n, int n2) {
        int n3 = (n2 & 1) != 0 ? this.points[n].y : this.points[n].scaledY;
        return n3;
    }

    public int getOriginalX(int n) {
        return this.points[n].origX;
    }

    public int getOriginalY(int n) {
        return this.points[n].origY;
    }

    public void setOriginalX(int n, int n2) {
        this.points[n].origX = n2;
    }

    public void setOriginalY(int n, int n2) {
        this.points[n].origY = n2;
    }

    public void setNumPoints(int n) {
        for (int i = 0; i < n; ++i) {
            this.points[i] = new Point();
        }
        this.numPoints = n;
    }

    public boolean isOnCurve(int n) {
        return (this.points[n].flags & 4) != 0;
    }

    public void setOnCurve(int n, boolean bl) {
        this.points[n].flags = bl ? (short)(this.points[n].flags | 4) : (short)(this.points[n].flags & 0xFFFFFFFB);
    }

    public boolean isContourEnd(int n) {
        return (this.points[n].flags & 8) != 0;
    }

    public void setContourEnd(int n, boolean bl) {
        this.points[n].flags = bl ? (short)(this.points[n].flags | 8) : (short)(this.points[n].flags & 0xFFFFFFF7);
    }

    void transform(double d, AffineTransform affineTransform, int n, int n2, int n3) {
        double d2 = d / (double)n;
        this.scaleX = affineTransform.getScaleX() * d2;
        this.scaleY = affineTransform.getScaleY() * d2;
        this.shearX = affineTransform.getShearX() * d2;
        this.shearY = affineTransform.getShearY() * d2;
        for (int i = 0; i < this.numPoints; ++i) {
            int n4 = this.points[i].origX + n2;
            int n5 = this.points[i].origY + n3;
            this.points[i].scaledX = this.points[i].x = Fixed.valueOf(this.scaleX * (double)n4 + this.shearX * (double)n5);
            this.points[i].scaledY = this.points[i].y = Fixed.valueOf(this.shearY * (double)n4 + this.scaleY * (double)n5);
        }
    }

    void combineWithSubGlyph(Zone zone, int n) {
        int n2 = this.numPoints - n;
        int n3 = zone.numPoints;
        System.arraycopy(zone.points, 0, this.points, n2, n3);
        this.numPoints += n3 - n;
    }

    private void dump() {
        for (int i = 0; i < this.numPoints; ++i) {
            System.out.print(" " + i + ": ");
            System.out.print(Fixed.toString(this.points[i].scaledX, this.points[i].scaledY));
            System.out.print(' ');
            System.out.print(Fixed.toString(this.points[i].origX, this.points[i].origY));
            System.out.print(' ');
            if (this.isOnCurve(i)) {
                System.out.print('.');
            } else {
                System.out.print('c');
            }
            if (this.isContourEnd(i)) {
                System.out.print('E');
            }
            System.out.println();
            if (!this.isContourEnd(i)) continue;
            System.out.println();
        }
    }

    public PathIterator getPathIterator(int n) {
        return new ZonePathIterator(this, n);
    }

    public GeneralPath getPath(int n) {
        GeneralPath generalPath = new GeneralPath(1, this.numPoints);
        generalPath.append(this.getPathIterator(n), false);
        return generalPath;
    }

    public int getNumContours() {
        int n = 0;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!this.isContourEnd(i)) continue;
            ++n;
        }
        return n;
    }

    public int getContourEnd(int n) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!this.isContourEnd(i)) continue;
            n2 = i;
            if (n3 == n) break;
            ++n3;
        }
        return n2;
    }

    public Point[] getPoints() {
        return this.points;
    }
}

