/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Zone;
import gnu.java.lang.CPStringBuilder;
import java.awt.FontFormatException;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

class VirtualMachine {
    private static final boolean PATENTED_HINTING = false;
    private static final boolean TRACE_EXECUTION = false;
    private static final short ONE_214 = 16384;
    private final int[] storage;
    private int[] stack;
    private final int maxStackElements;
    private int sp;
    private ByteBuffer[] fdefBuffer;
    private int[] fdefEntryPoint;
    private ShortBuffer controlValueTable;
    private int[] cvt;
    private int engineCompensation = 0;
    private ByteBuffer fontProgram;
    private ByteBuffer preProgram;
    private int numTwilightPoints;
    private int pointSize;
    private AffineTransform deviceTransform;
    private int scaleX;
    private int scaleY;
    private int shearX;
    private int shearY;
    private boolean antialiased;
    private int cvtCutIn;
    private int deltaBase;
    private int deltaShift;
    private short freeX;
    private short freeY;
    private int loop;
    private int minimumDistance;
    private short projX;
    private short projY;
    private short dualX;
    private short dualY;
    private int rp0;
    private int rp1;
    private int rp2;
    private boolean scanControl;
    private int scanType;
    private int singleWidthValue;
    private Zone zp0;
    private Zone zp1;
    private Zone zp2;
    private Zone twilightZone;
    private Zone glyphZone;
    private boolean executeGlyphInstructions;
    private boolean ignoreCVTProgram;
    private int roundPeriod;
    private int roundPhase;
    private int roundThreshold;
    private int cachedPixelsPerEM;
    private int unitsPerEm;
    private static final String[] INST_NAME = new String[]{"SVTCA[0]", "SVTCA[1]", "SPVTCA[0]", "SPVTCA[1]", "INST_04", "INST_05", "INST_06", "INST_07", "INST_08", "INST_09", "INST_0A", "INST_0B", "GPV", "GFV", "INST_0E", "ISECT", "SRP0", "SRP1", "SRP2", "SZP0", "SZP1", "SZP2", "SZPS", "SLOOP", "RTG", "RTHG", "SMD", "ELSE", "JMPR", "SCVTCI", "INST_1E", "SSW", "DUP", "POP", "CLEAR", "SWAP", "DEPTH", "CINDEX", "MINDEX", "INST_27", "INST_28", "INST_29", "LOOPCALL", "CALL", "FDEF", "ENDF", "MDAP[0]", "MDAP[1]", "IUP[0]", "IUP[1]", "SHP[0]", "SHP[1]", "INST_34", "INST_35", "INST_36", "INST_37", "INST_38", "IP", "INST_3A", "INST_3B", "INST_3C", "RTDG", "MIAP[0]", "MIAP[1]", "NPUSHB", "NPUSHW", "WS", "RS", "WCVTP", "RCVT", "GC[0]", "GC[1]", "INST_48", "INST_49", "INST_4A", "MPPEM", "MPS", "FLIPON", "FLIPOFF", "DEBUG", "LT", "LTEQ", "GT", "GTEQ", "EQ", "NEQ", "INST_56", "INST_57", "IF", "EIF", "AND", "OR", "NOT", "INST_5D", "SDB", "SDS", "ADD", "SUB", "DIV", "MUL", "ABS", "NEG", "FLOOR", "CEILING", "ROUND[0]", "ROUND[1]", "ROUND[2]", "ROUND[3]", "NROUND[0]", "NROUND[1]", "NROUND[2]", "NROUND[3]", "WCVTF", "INST_71", "INST_72", "DELTAC1", "DELTAC2", "DELTAC3", "SROUND", "S45ROUND", "JROT", "JROF", "ROFF", "INST_7B", "RUTG", "RDTG", "SANGW", "AA", "FLIPPT", "FLIPRGON", "FLIPRGOFF", "INST_83", "INST_84", "SCANCTRL", "INST_86", "INST_87", "GETINFO", "INST_89", "ROLL", "MAX", "MIN", "SCANTYPE", "INSTCTRL", "INST_8F", "INST_90", "INST_91", "INST_92", "INST_93", "INST_94", "INST_95", "INST_96", "INST_97", "INST_98", "INST_99", "INST_9A", "INST_9B", "INST_9C", "INST_9D", "INST_9E", "INST_9F", "INST_A0", "INST_A1", "INST_A2", "INST_A3", "INST_A4", "INST_A5", "INST_A6", "INST_A7", "INST_A8", "INST_A9", "INST_AA", "INST_AB", "INST_AC", "INST_AD", "INST_AE", "INST_AF", "PUSHB[0]", "PUSHB[1]", "PUSHB[2]", "PUSHB[3]", "PUSHB[4]", "PUSHB[5]", "PUSHB[6]", "PUSHB[7]", "PUSHW[0]", "PUSHW[1]", "PUSHW[2]", "PUSHW[3]", "PUSHW[4]", "PUSHW[5]", "PUSHW[6]", "PUSHW[7]", "INST_C0", "INST_C1", "INST_C2", "INST_C3", "INST_C4", "INST_C5", "INST_C6", "INST_C7", "INST_C8", "INST_C9", "INST_CA", "INST_CB", "INST_CC", "INST_CD", "INST_CE", "INST_CF", "INST_D0", "INST_D1", "INST_D2", "INST_D3", "INST_D4", "INST_D5", "INST_D6", "INST_D7", "INST_D8", "INST_D9", "INST_DA", "INST_DB", "INST_DC", "INST_DD", "INST_DE", "INST_DF", "MIRP00000", "MIRP00001", "MIRP00010", "MIRP00011", "MIRP00100", "MIRP00101", "MIRP00110", "MIRP00111", "MIRP01000", "MIRP01001", "MIRP01010", "MIRP01011", "MIRP01100", "MIRP01101", "MIRP01110", "MIRP01111", "MIRP10000", "MIRP10001", "MIRP10010", "MIRP10011", "MIRP10100", "MIRP10101", "MIRP10110", "MIRP10111", "MIRP11000", "MIRP11001", "MIRP11010", "MIRP11011", "MIRP11100", "MIRP11101", "MIRP11110", "MIRP11111"};

    VirtualMachine(int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, ByteBuffer byteBuffer4) throws FontFormatException {
        if (byteBuffer.getInt(0) != 65536) {
            throw new FontFormatException("unsupported maxp version");
        }
        this.unitsPerEm = n;
        char c = byteBuffer.getChar(18);
        int n2 = byteBuffer.getChar(20);
        if (n2 == 0) {
            n2 = 64;
        }
        this.fdefBuffer = new ByteBuffer[n2];
        this.fdefEntryPoint = new int[n2];
        if (byteBuffer2 != null) {
            this.controlValueTable = byteBuffer2.asShortBuffer();
        }
        char c2 = byteBuffer.getChar(22);
        this.maxStackElements = byteBuffer.getChar(24);
        this.storage = new int[c];
        this.fontProgram = byteBuffer3;
        this.preProgram = byteBuffer4;
        this.numTwilightPoints = byteBuffer.getChar(16);
    }

    private void resetGraphicsState() {
        this.dualX = (short)16384;
        this.projX = (short)16384;
        this.freeX = (short)16384;
        this.dualX = 0;
        this.projY = 0;
        this.freeY = 0;
        this.cachedPixelsPerEM = 0;
        this.cvtCutIn = 68;
        this.deltaBase = 9;
        this.deltaShift = 3;
        this.loop = 1;
        this.minimumDistance = 64;
        this.singleWidthValue = 0;
        this.rp2 = 0;
        this.rp1 = 0;
        this.rp0 = 0;
        this.scanControl = false;
        this.scanType = 2;
        this.zp1 = this.zp2 = this.getZone(1);
        this.zp0 = this.zp2;
        this.setRoundingMode(64, 72);
    }

    private void reloadControlValueTable() {
        if (this.controlValueTable == null) {
            return;
        }
        if (this.cvt == null) {
            this.cvt = new int[this.controlValueTable.capacity()];
        }
        for (int i = 0; i < this.cvt.length; ++i) {
            this.cvt[i] = this.funitsToPixels(this.controlValueTable.get(i));
        }
    }

    private int funitsToPixels(int n) {
        return (int)(((long)n * (long)this.scaleY + (long)(this.unitsPerEm >> 1)) / (long)this.unitsPerEm);
    }

    public boolean setup(double d, AffineTransform affineTransform, boolean bl) {
        int n;
        boolean bl2;
        if (this.stack == null) {
            this.stack = new int[this.maxStackElements];
        }
        if (this.twilightZone == null) {
            this.twilightZone = new Zone(this.numTwilightPoints);
        }
        if (this.fontProgram != null) {
            this.resetGraphicsState();
            this.sp = -1;
            this.execute(this.fontProgram, 0);
            this.fontProgram = null;
        }
        boolean bl3 = bl2 = (n = Fixed.valueOf(d)) != this.pointSize || !affineTransform.equals(this.deviceTransform) || bl != this.antialiased;
        if (bl2) {
            this.pointSize = n;
            this.deviceTransform = affineTransform;
            this.antialiased = bl;
            this.scaleX = (int)(affineTransform.getScaleX() * d * 64.0);
            this.scaleY = (int)(affineTransform.getScaleY() * d * 64.0);
            this.shearX = (int)(affineTransform.getShearX() * d * 64.0);
            this.shearY = (int)(affineTransform.getShearY() * d * 64.0);
            this.resetGraphicsState();
            this.reloadControlValueTable();
            this.executeGlyphInstructions = true;
            this.ignoreCVTProgram = false;
            if (this.preProgram != null) {
                this.sp = -1;
                this.execute(this.preProgram, 0);
                if (this.ignoreCVTProgram) {
                    this.reloadControlValueTable();
                }
            }
        }
        return this.executeGlyphInstructions;
    }

    private void execute(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(n);
        while (byteBuffer.hasRemaining() && this.executeInstruction(byteBuffer)) {
        }
    }

    private void dumpInstruction(ByteBuffer byteBuffer) {
        int n;
        int n2;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(40);
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.get(n3) & 0xFF;
        int n5 = 99;
        for (n2 = 0; n2 < this.fdefBuffer.length; ++n2) {
            if (this.fdefBuffer[n2] != byteBuffer) continue;
            n5 = 102;
            break;
        }
        cPStringBuilder.append((char)n5);
        cPStringBuilder.append(VirtualMachine.getHex((short)byteBuffer.position()));
        cPStringBuilder.append(": ");
        cPStringBuilder.append(VirtualMachine.getHex((byte)n4));
        cPStringBuilder.append("  ");
        cPStringBuilder.append(INST_NAME[n4]);
        if (n4 == 64) {
            n = byteBuffer.get(n3 + 1) & 0xFF;
            cPStringBuilder.append(" (");
            cPStringBuilder.append(n);
            cPStringBuilder.append(") ");
            for (n2 = 0; n2 < n; ++n2) {
                if (n2 > 0) {
                    cPStringBuilder.append(" ");
                }
                cPStringBuilder.append('$');
                cPStringBuilder.append(VirtualMachine.getHex(byteBuffer.get(n3 + 2 + n2)));
            }
        }
        if (n4 == 65) {
            n = byteBuffer.get(n3 + 1) & 0xFF;
            cPStringBuilder.append(" (");
            cPStringBuilder.append(n);
            cPStringBuilder.append(") ");
            for (n2 = 0; n2 < n; ++n2) {
                if (n2 > 0) {
                    cPStringBuilder.append(' ');
                }
                cPStringBuilder.append('$');
                cPStringBuilder.append(VirtualMachine.getHex(byteBuffer.getShort(n3 + 2 + 2 * n2)));
            }
        } else {
            n = VirtualMachine.getInstructionLength(n4) - 1;
            for (n2 = 0; n2 < n; ++n2) {
                cPStringBuilder.append(" $");
                cPStringBuilder.append(VirtualMachine.getHex(byteBuffer.get(n3 + 1 + n2)));
            }
        }
        while (cPStringBuilder.length() < 30) {
            cPStringBuilder.append(' ');
        }
        cPStringBuilder.append('|');
        cPStringBuilder.append(this.sp + 1);
        cPStringBuilder.append("| ");
        for (n2 = this.sp; n2 >= Math.max(0, this.sp - 5); --n2) {
            if (n2 < this.sp) {
                cPStringBuilder.append(" ");
            }
            if (this.stack[n2] >> 16 != 0) {
                cPStringBuilder.append(VirtualMachine.getHex((short)(this.stack[n2] >> 16)));
            }
            cPStringBuilder.append(VirtualMachine.getHex((short)this.stack[n2]));
        }
        System.out.println(cPStringBuilder);
    }

    private static char getNibble(int n, int n2) {
        if ((n = n >> n2 & 0xF) < 10) {
            return (char)(n + 48);
        }
        return (char)(n + 97 - 10);
    }

    private static String getHex(byte by) {
        char[] cArray = new char[]{VirtualMachine.getNibble(by, 4), VirtualMachine.getNibble(by, 0)};
        return new String(cArray);
    }

    private static String getHex(short s) {
        char[] cArray = new char[]{VirtualMachine.getNibble(s, 12), VirtualMachine.getNibble(s, 8), VirtualMachine.getNibble(s, 4), VirtualMachine.getNibble(s, 0)};
        return new String(cArray);
    }

    private static void skipAfter(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        block2: {
            int n6;
            n5 = byteBuffer.position();
            int n7 = 0;
            do {
                n6 = byteBuffer.get(n5) & 0xFF;
                int n8 = VirtualMachine.getInstructionLength(n6);
                n5 = n6 == 64 ? (n5 += 1 + (byteBuffer.get(n5 + 1) & 0xFF)) : (n6 == 65 ? (n5 += 1 + 2 * (byteBuffer.get(n5 + 1) & 0xFF)) : (n5 += n8));
                if (n7 == 0 && (n6 == n || n6 == n2)) break block2;
                if (!bl) continue;
                if (n6 == 88) {
                    ++n7;
                    continue;
                }
                if (n6 != 89) continue;
                --n7;
            } while (n7 >= 0 && n6 != n3 && n6 != n4);
            throw new IllegalStateException();
        }
        byteBuffer.position(n5);
    }

    private static int getInstructionLength(int n) {
        if (n == 64 || n == 65) {
            return -1;
        }
        if (n >= 176 && n <= 183) {
            return n - 174;
        }
        if (n >= 184 && n <= 191) {
            return 1 + (n - 183 << 1);
        }
        return 1;
    }

    private boolean executeInstruction(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 0: {
                this.setFreedomVector((short)0, (short)16384);
                this.setProjectionVector((short)0, (short)16384);
                break;
            }
            case 1: {
                this.setFreedomVector((short)16384, (short)0);
                this.setProjectionVector((short)16384, (short)0);
                break;
            }
            case 2: {
                this.setProjectionVector((short)0, (short)16384);
                break;
            }
            case 3: {
                this.setProjectionVector((short)16384, (short)0);
                break;
            }
            case 12: {
                this.stack[++this.sp] = this.projX;
                this.stack[++this.sp] = this.projY;
                break;
            }
            case 13: {
                this.stack[++this.sp] = this.freeX;
                this.stack[++this.sp] = this.freeY;
                break;
            }
            case 15: {
                this.sp -= 4;
                this.handleISECT(this.stack[this.sp], this.stack[this.sp + 1], this.stack[this.sp + 2], this.stack[this.sp + 3], this.stack[this.sp + 4]);
                break;
            }
            case 16: {
                this.rp0 = this.stack[this.sp--];
                break;
            }
            case 17: {
                this.rp1 = this.stack[this.sp--];
                break;
            }
            case 18: {
                this.rp2 = this.stack[this.sp--];
                break;
            }
            case 19: {
                this.zp0 = this.getZone(this.stack[this.sp--]);
                break;
            }
            case 20: {
                this.zp1 = this.getZone(this.stack[this.sp--]);
                break;
            }
            case 21: {
                this.zp2 = this.getZone(this.stack[this.sp--]);
                break;
            }
            case 22: {
                this.zp1 = this.zp2 = this.getZone(this.stack[this.sp--]);
                this.zp0 = this.zp2;
                break;
            }
            case 23: {
                this.loop = this.stack[this.sp--];
                break;
            }
            case 24: {
                this.setRoundingMode(64, 72);
                break;
            }
            case 25: {
                this.setRoundingMode(64, 104);
                break;
            }
            case 26: {
                this.minimumDistance = this.stack[this.sp--];
                break;
            }
            case 27: {
                VirtualMachine.skipAfter(byteBuffer, 89, -1, -1, -1, true);
                break;
            }
            case 28: {
                byteBuffer.position(byteBuffer.position() - 1 + this.stack[this.sp--]);
                break;
            }
            case 29: {
                this.cvtCutIn = this.stack[this.sp--];
                break;
            }
            case 31: {
                this.singleWidthValue = this.stack[this.sp--];
                break;
            }
            case 32: {
                int n2 = this.stack[this.sp];
                this.stack[++this.sp] = n2;
                break;
            }
            case 33: {
                --this.sp;
                break;
            }
            case 34: {
                this.sp = -1;
                break;
            }
            case 35: {
                int n3 = this.stack[this.sp--];
                int n4 = this.stack[this.sp];
                this.stack[this.sp] = n3;
                this.stack[++this.sp] = n4;
                break;
            }
            case 36: {
                this.stack[++this.sp] = this.sp + 1;
                break;
            }
            case 37: {
                this.stack[this.sp] = this.stack[this.sp - this.stack[this.sp]];
                break;
            }
            case 38: {
                int n5 = this.stack[this.sp];
                int n6 = this.stack[this.sp - n5];
                System.arraycopy(this.stack, this.sp - n5 + 1, this.stack, this.sp - n5, n5 - 1);
                --this.sp;
                this.stack[this.sp] = n6;
                break;
            }
            case 42: {
                int n7 = this.stack[this.sp--];
                int n8 = this.stack[this.sp--];
                int n9 = byteBuffer.position();
                int n10 = this.sp;
                for (int i = 0; i < n8; ++i) {
                    this.execute(this.fdefBuffer[n7], this.fdefEntryPoint[n7]);
                }
                byteBuffer.position(n9);
                break;
            }
            case 43: {
                int n11 = this.stack[this.sp--];
                int n12 = byteBuffer.position();
                int n13 = this.sp;
                this.execute(this.fdefBuffer[n11], this.fdefEntryPoint[n11]);
                byteBuffer.position(n12);
                break;
            }
            case 44: {
                int n14 = this.stack[this.sp--];
                this.fdefBuffer[n14] = byteBuffer;
                this.fdefEntryPoint[n14] = byteBuffer.position();
                VirtualMachine.skipAfter(byteBuffer, 45, -1, 137, 44, false);
                break;
            }
            case 45: {
                return false;
            }
            case 46: {
                this.handleMDAP(this.stack[this.sp--], false);
                break;
            }
            case 47: {
                this.handleMDAP(this.stack[this.sp--], true);
                break;
            }
            case 57: {
                this.handleIP();
                break;
            }
            case 61: {
                this.setRoundingMode(64, 8);
                this.roundThreshold /= 64;
                break;
            }
            case 62: {
                int n15 = this.stack[this.sp--];
                this.handleMIAP(n15, this.stack[this.sp--], false);
                break;
            }
            case 63: {
                int n16 = this.stack[this.sp--];
                this.handleMIAP(n16, this.stack[this.sp--], true);
                break;
            }
            case 64: {
                int n17 = byteBuffer.get() & 0xFF;
                for (int i = 0; i < n17; ++i) {
                    this.stack[++this.sp] = byteBuffer.get() & 0xFF;
                }
                break;
            }
            case 65: {
                int n18 = byteBuffer.get() & 0xFF;
                for (int i = 0; i < n18; ++i) {
                    this.stack[++this.sp] = byteBuffer.getShort();
                }
                break;
            }
            case 66: {
                int n19 = this.stack[this.sp--];
                int n20 = this.stack[this.sp--];
                this.storage[n20] = n19;
                break;
            }
            case 67: {
                this.stack[this.sp] = this.storage[this.stack[this.sp]];
                break;
            }
            case 68: {
                int n21 = this.stack[this.sp--];
                int n22 = this.stack[this.sp--];
                if (n22 >= this.cvt.length) break;
                this.cvt[n22] = n21;
                break;
            }
            case 69: {
                if (this.stack[this.sp] < this.cvt.length) {
                    this.stack[this.sp] = this.cvt[this.stack[this.sp]];
                    break;
                }
                this.stack[this.sp] = 0;
                break;
            }
            case 70: {
                this.stack[this.sp] = this.getProjection(this.zp2, this.stack[this.sp]);
                break;
            }
            case 71: {
                this.stack[this.sp] = this.getOriginalProjection(this.zp2, this.stack[this.sp]);
                break;
            }
            case 75: {
                this.stack[++this.sp] = this.getPixelsPerEM();
                break;
            }
            case 76: {
                this.stack[++this.sp] = this.pointSize;
                break;
            }
            case 79: {
                --this.sp;
                break;
            }
            case 80: {
                int n23 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] < n23 ? 1 : 0;
                break;
            }
            case 81: {
                int n24 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] <= n24 ? 1 : 0;
                break;
            }
            case 82: {
                int n25 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] > n25 ? 1 : 0;
                break;
            }
            case 83: {
                int n26 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] >= n26 ? 1 : 0;
                break;
            }
            case 84: {
                int n27 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] == n27 ? 1 : 0;
                break;
            }
            case 85: {
                int n28 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] != n28 ? 1 : 0;
                break;
            }
            case 88: {
                if (this.stack[this.sp--] != 0) break;
                VirtualMachine.skipAfter(byteBuffer, 27, 89, -1, -1, true);
                break;
            }
            case 89: {
                break;
            }
            case 90: {
                int n29 = this.stack[this.sp--];
                this.stack[this.sp] = n29 != 0 && this.stack[this.sp] != 0 ? 1 : 0;
                break;
            }
            case 91: {
                int n30 = this.stack[this.sp--];
                this.stack[this.sp] = n30 != 0 || this.stack[this.sp] != 0 ? 1 : 0;
                break;
            }
            case 92: {
                this.stack[this.sp] = this.stack[this.sp] != 0 ? 0 : 1;
                break;
            }
            case 94: {
                this.deltaBase = this.stack[this.sp--];
                break;
            }
            case 95: {
                this.deltaShift = this.stack[this.sp--];
                break;
            }
            case 96: {
                int n31 = this.stack[this.sp--];
                int n32 = this.sp;
                this.stack[n32] = this.stack[n32] + n31;
                break;
            }
            case 97: {
                int n33 = this.stack[this.sp--];
                int n34 = this.sp;
                this.stack[n34] = this.stack[n34] - n33;
                break;
            }
            case 98: {
                int n35 = this.stack[this.sp--];
                this.stack[this.sp] = Fixed.div(n35, this.stack[this.sp]);
                break;
            }
            case 99: {
                int n36 = this.stack[this.sp--];
                this.stack[this.sp] = Fixed.mul(n36, this.stack[this.sp]);
                break;
            }
            case 100: {
                this.stack[this.sp] = Math.abs(this.stack[this.sp]);
                break;
            }
            case 101: {
                this.stack[this.sp] = -this.stack[this.sp];
                break;
            }
            case 102: {
                this.stack[this.sp] = Fixed.floor(this.stack[this.sp]);
                break;
            }
            case 103: {
                this.stack[this.sp] = Fixed.ceil(this.stack[this.sp]);
                break;
            }
            case 104: {
                this.stack[this.sp] = this.round(this.stack[this.sp], 0);
                break;
            }
            case 105: {
                this.stack[this.sp] = this.round(this.stack[this.sp], -this.engineCompensation);
                break;
            }
            case 106: {
                this.stack[this.sp] = this.round(this.stack[this.sp], this.engineCompensation);
                break;
            }
            case 107: {
                this.stack[this.sp] = this.round(this.stack[this.sp], 0);
                break;
            }
            case 108: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], 0);
                break;
            }
            case 109: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], -this.engineCompensation);
                break;
            }
            case 110: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], this.engineCompensation);
                break;
            }
            case 111: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], 0);
                break;
            }
            case 112: {
                int n37 = this.stack[this.sp--];
                this.cvt[this.stack[this.sp--]] = n37 * this.getPixelsPerEM();
                break;
            }
            case 115: {
                int n38 = this.stack[this.sp--];
                this.sp -= 2 * n38;
                this.deltaC(this.stack, this.sp + 1, n38, 0);
                break;
            }
            case 116: {
                int n39 = this.stack[this.sp--];
                this.sp -= 2 * n39;
                this.deltaC(this.stack, this.sp + 1, n39, 16);
                break;
            }
            case 117: {
                int n40 = this.stack[this.sp--];
                this.sp -= 2 * n40;
                this.deltaC(this.stack, this.sp + 1, n40, 32);
                break;
            }
            case 118: {
                this.setRoundingMode(64, this.stack[this.sp--]);
                break;
            }
            case 119: {
                this.setRoundingMode(45, this.stack[this.sp--]);
                break;
            }
            case 120: {
                int n41 = this.stack[this.sp--];
                int n42 = byteBuffer.position() - 1 + this.stack[this.sp--];
                if (n41 == 0) break;
                byteBuffer.position(n42);
                break;
            }
            case 121: {
                int n43 = this.stack[this.sp--];
                int n44 = byteBuffer.position() - 1 + this.stack[this.sp--];
                if (n43 != 0) break;
                byteBuffer.position(n44);
                break;
            }
            case 122: {
                this.roundPeriod = 0;
                break;
            }
            case 124: {
                this.setRoundingMode(64, 64);
                break;
            }
            case 125: {
                this.setRoundingMode(64, 64);
                this.roundThreshold = 0;
                break;
            }
            case 126: 
            case 127: {
                --this.sp;
                break;
            }
            case 133: {
                boolean bl;
                int n45 = this.stack[this.sp--];
                int n46 = n45 & 0xFF;
                this.scanControl = false;
                boolean bl2 = bl = n46 == 255 || n46 != 0 && this.getPixelsPerEM() > n46;
                if ((n45 & 0x100) != 0 && bl) {
                    this.scanControl = true;
                }
                if ((n45 & 0x200) != 0 && this.isRotated()) {
                    this.scanControl = true;
                }
                if ((n45 & 0x400) != 0 && this.isStretched()) {
                    this.scanControl = true;
                }
                if ((n45 & 0x800) != 0 && !bl) {
                    this.scanControl = false;
                }
                if ((n45 & 0x1000) != 0 && !this.isRotated()) {
                    this.scanControl = false;
                }
                if ((n45 & 0x2000) == 0 || this.isStretched()) break;
                this.scanControl = false;
                break;
            }
            case 136: {
                int n47 = 0;
                if ((this.stack[this.sp] & 1) != 0) {
                    n47 |= 0x23;
                }
                if ((this.stack[this.sp] & 2) != 0 && this.isRotated()) {
                    n47 |= 0x100;
                }
                if ((this.stack[this.sp] & 4) != 0 && this.isStretched()) {
                    n47 |= 0x200;
                }
                if ((this.stack[this.sp] & 0x20) != 0 && this.antialiased) {
                    n47 |= 0x1000;
                }
                this.stack[this.sp] = n47;
                break;
            }
            case 138: {
                int n48 = this.stack[this.sp - 2];
                this.stack[this.sp - 2] = this.stack[this.sp - 1];
                this.stack[this.sp - 1] = this.stack[this.sp];
                this.stack[this.sp] = n48;
                break;
            }
            case 139: {
                int n49 = this.stack[this.sp--];
                this.stack[this.sp] = Math.max(n49, this.stack[this.sp]);
                break;
            }
            case 140: {
                int n50 = this.stack[this.sp--];
                this.stack[this.sp] = Math.min(n50, this.stack[this.sp]);
                break;
            }
            case 141: {
                this.scanType = this.stack[this.sp--];
                break;
            }
            case 142: {
                int n51 = this.stack[this.sp--];
                int n52 = this.stack[this.sp--];
                switch (n51) {
                    case 1: {
                        this.executeGlyphInstructions = n52 == 0;
                        break;
                    }
                    case 2: {
                        this.ignoreCVTProgram = n52 != 0;
                    }
                }
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                int n53 = n - 176 + 1;
                for (int i = 0; i < n53; ++i) {
                    this.stack[++this.sp] = byteBuffer.get() & 0xFF;
                }
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                int n54 = n - 184 + 1;
                for (int i = 0; i < n54; ++i) {
                    this.stack[++this.sp] = byteBuffer.getShort();
                }
                break;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                int n55 = this.stack[this.sp--];
                this.handleMIRP(n, n55, this.stack[this.sp--]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private void setRoundingMode(int n, int n2) {
        switch ((n2 & 0xC0) >> 6) {
            case 0: {
                this.roundPeriod = n / 2;
                break;
            }
            case 2: {
                this.roundPeriod = n * 2;
                break;
            }
            default: {
                this.roundPeriod = n;
            }
        }
        switch ((n2 & 0x30) >> 4) {
            case 0: {
                this.roundPhase = 0;
                break;
            }
            case 1: {
                this.roundPhase = this.roundPeriod >> 2;
                break;
            }
            case 2: {
                this.roundPhase = this.roundPeriod >> 1;
                break;
            }
            case 3: {
                this.roundPhase = (this.roundPeriod >> 1) + (this.roundPeriod >> 2);
            }
        }
        int n3 = n2 & 0xF;
        this.roundThreshold = n3 == 0 ? this.roundPeriod - 64 : (n3 - 4) * this.roundPeriod / 8;
    }

    private void deltaC(int[] nArray, int n, int n2, int n3) {
        int n4 = this.getPixelsPerEM() - (this.deltaBase + n3);
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6 = nArray[n + 2 * i];
            int n7 = n6 >> 4 & 0xF;
            if (n7 != n4) continue;
            int n8 = (n6 & 0xF) - 8;
            if (n8 >= 0) {
                ++n8;
            }
            if ((n5 = this.deltaShift - 6) > 0) {
                n8 >>= n5;
            } else if (n5 < 0) {
                n8 <<= -n5;
            }
            int n9 = nArray[n + 2 * i + 1];
            this.cvt[n9] = this.cvt[n9] + n8;
            break;
        }
    }

    private Zone getZone(int n) {
        return n == 0 ? this.twilightZone : this.glyphZone;
    }

    private int getProjection(int n, int n2) {
        return (int)((long)n * (long)this.projX + (long)n2 * (long)this.projY >> 14);
    }

    private int getDualProjection(int n, int n2) {
        return (int)((long)n * (long)this.dualX + (long)n2 * (long)this.dualY >> 14);
    }

    private int getProjection(Zone zone, int n) {
        return this.getProjection(zone.getX(n), zone.getY(n));
    }

    private int getOriginalProjection(Zone zone, int n) {
        return this.getDualProjection(zone.getOriginalX(n), zone.getOriginalY(n));
    }

    private void handleISECT(int n, int n2, int n3, int n4, int n5) {
        System.out.println("FIXME: Unimplemented ISECT " + n5);
    }

    private static int muldiv(int n, int n2, int n3) {
        int n4 = n;
        n = Math.abs(n);
        n4 ^= n2;
        n2 = Math.abs(n2);
        n4 ^= n3;
        n3 = Math.abs(n3);
        n = (int)(((long)n * (long)n2 + (long)(n3 >> 1)) / (long)n3);
        return n4 < 0 ? -n : n;
    }

    private int getFreeDotProj() {
        int n = (this.projX * this.freeX << 2) + (this.projY * this.freeY << 2);
        if (Math.abs(n) < 0x4000000) {
            n = 0x40000000;
        }
        return n;
    }

    private void movePoint(Zone zone, int n, int n2) {
        int n3;
        int n4 = this.getFreeDotProj();
        if (this.freeX != 0) {
            n3 = zone.getX(n);
            zone.setX(n, n3 += VirtualMachine.muldiv(n2, this.freeX << 16, n4), true);
        }
        if (this.freeY != 0) {
            n3 = zone.getY(n);
            zone.setY(n, n3 += VirtualMachine.muldiv(n2, this.freeY << 16, n4), true);
        }
    }

    private void dumpVectors() {
        System.out.println("  proj=" + Fixed.toString(this.projX >> 8, this.projY >> 8) + ", free=" + Fixed.toString(this.freeX >> 8, this.freeY >> 8));
    }

    private void handleIP() {
        int n = this.getOriginalProjection(this.zp0, this.rp1);
        int n2 = this.getProjection(this.zp0, this.rp1);
        int n3 = this.getOriginalProjection(this.zp1, this.rp2);
        int n4 = this.getProjection(this.zp1, this.rp2);
        while (--this.loop >= 0) {
            int n5 = this.stack[this.sp--];
            int n6 = this.getOriginalProjection(this.zp2, n5);
            int n7 = this.getProjection(this.zp2, n5);
            int n8 = n <= n3 && n6 <= n || n > n3 && n6 >= n ? n2 - n + (n6 - n7) : (n <= n3 && n6 >= n3 || n > n3 && n6 < n3 ? n4 - n3 + (n6 - n7) : VirtualMachine.muldiv(n4 - n2, n6 - n, n3 - n) + (n2 - n7));
            this.movePoint(this.zp2, n5, n8);
        }
        this.loop = 1;
    }

    private void handleMDAP(int n, boolean bl) {
        System.out.println("FIXME: Unimplemented MDAP: point " + n + "/" + this.zp0);
    }

    private void handleMIAP(int n, int n2, boolean bl) {
        int n3 = this.getProjection(this.zp0, n2);
        int n4 = this.cvt[n];
        if (bl) {
            if (Math.abs(n4 - n3) > this.cvtCutIn) {
                n4 = n3;
            }
            n4 = this.round(n4, 0);
        }
        this.movePoint(this.zp0, n2, n4 - n3);
        this.rp0 = this.rp1 = n2;
    }

    private void handleMIRP(int n, int n2, int n3) {
        System.out.println("FIXME: Unimplemented mirp " + n2 + ", " + n3);
    }

    private int round(int n, int n2) {
        if (this.roundPeriod == 0) {
            return VirtualMachine.nround(n, n2);
        }
        if (n >= 0) {
            int n3 = n + n2 - this.roundPhase + this.roundThreshold;
            return Math.max(n3 &= -this.roundPeriod, 0) + this.roundPhase;
        }
        int n4 = n2 - this.roundPhase + this.roundThreshold - n;
        return Math.max(-(n4 &= -this.roundPeriod), 0) - this.roundPhase;
    }

    private static int nround(int n, int n2) {
        if (n >= 0) {
            return Math.max(n + n2, 0);
        }
        return Math.min(n - n2, 0);
    }

    private boolean isRotated() {
        return this.shearX != 0 || this.shearY != 0;
    }

    private boolean isStretched() {
        return this.scaleX != this.scaleY;
    }

    private int getPixelsPerEM() {
        if (this.cachedPixelsPerEM == 0) {
            this.cachedPixelsPerEM = Fixed.intValue(Fixed.vectorLength(this.applyCTM_x(this.projX >> 8, this.projY >> 8), this.applyCTM_y(this.projX >> 8, this.projY >> 8)));
        }
        return this.cachedPixelsPerEM;
    }

    private void setProjectionVector(short s, short s2) {
    }

    private void setFreedomVector(short s, short s2) {
    }

    private void setDualVector(short s, short s2) {
    }

    private int applyCTM_x(int n, int n2) {
        return (int)((long)this.scaleX * (long)n + (long)this.shearX * (long)n2 >> 6);
    }

    private int applyCTM_y(int n, int n2) {
        return (int)((long)this.shearY * (long)n + (long)this.scaleY * (long)n2 >> 6);
    }
}

