/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Locale;

public class NameDecoder {
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FAMILY = 1;
    public static final int NAME_SUBFAMILY = 2;
    public static final int NAME_UNIQUE = 3;
    public static final int NAME_FULL = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_POSTSCRIPT = 6;
    public static final int NAME_TRADEMARK = 7;
    public static final int NAME_MANUFACTURER = 8;
    public static final int NAME_DESIGNER = 9;
    public static final int NAME_DESCRIPTION = 10;
    public static final int NAME_VENDOR_URL = 11;
    public static final int NAME_DESIGNER_URL = 12;
    public static final int NAME_LICENSE = 13;
    public static final int NAME_LICENSE_URL = 14;
    public static final int NAME_PREFERRED_FAMILY = 16;
    public static final int NAME_PREFERRED_SUBFAMILY = 17;
    public static final int NAME_FULL_MACCOMPATIBLE = 18;
    public static final int NAME_SAMPLE_TEXT = 19;
    public static final int NAME_POSTSCRIPT_CID = 20;
    private static final int PLATFORM_MACINTOSH = 1;
    private static final int PLATFORM_MICROSOFT = 3;
    private static final String macLanguageCodes = "enfrdeitnlsvesdaptnoiwjaarfielismttrhrzhurhithkoltplhuetlv  fofaruzhnlgdsqrocssksljisrmkbgukbeuzkkazazhykamokytgtkmnmnpskukssdbonesamrbnasgupaormlkntatesimykmloviintlmsmsamti  soswrwrn  mgeo                                                                  cyeucalaqugnayttugtsjwsuglafbriugdgvgatoelklaz";
    private static final String microsoftLanguageCodes = "  arbgcazhcsdadeelenesfifriwhuisitjakonlnoplptrmrorushsksqsvthtrurinukbesletlvlttgfavihyazeu  mk  ts    xhzuafkafohimt  gajimskkkyswtkuzttbnpaguortateknmlasmrsamnbocykmlomygl    sd  si  iuam  ksnefypstl      ha  yo              omtign  laso";

    public static String getName(ByteBuffer byteBuffer, int n, Locale locale) {
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.position(0);
        if (byteBuffer.getShort() != 0) {
            return null;
        }
        int n2 = NameDecoder.getMacLanguageCode(locale);
        int n3 = NameDecoder.getMicrosoftLanguageCode(locale);
        int n4 = byteBuffer.getShort();
        short s = byteBuffer.getShort();
        for (int i = 0; i < n4; ++i) {
            String string;
            short s2 = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            short s4 = byteBuffer.getShort();
            short s5 = byteBuffer.getShort();
            short s6 = byteBuffer.getShort();
            int n5 = s + byteBuffer.getShort();
            if (s5 != n) continue;
            if (n == 6) {
                string = byteBuffer.get(n5) == 0 ? NameDecoder.decodeName("UTF-16BE", byteBuffer, n5, s6) : NameDecoder.decodeName("ASCII", byteBuffer, n5, s6);
                return string;
            }
            boolean bl = false;
            switch (s2) {
                case 1: {
                    if (s4 == n2 || locale == null) {
                        bl = true;
                        break;
                    }
                    switch (n2) {
                        case 49: {
                            bl = s4 == 50 || s4 == 150;
                            break;
                        }
                        case 57: {
                            bl = s4 == 58;
                            break;
                        }
                        case 83: {
                            bl = s4 == 84;
                        }
                    }
                    break;
                }
                case 3: {
                    if ((s4 & 0xFF) != n3 && locale != null) break;
                    bl = true;
                }
            }
            if (!bl || (string = NameDecoder.decodeName(s2, s3, s4, byteBuffer, n5, s6)) == null) continue;
            return string;
        }
        return null;
    }

    private static int getMacLanguageCode(Locale locale) {
        if (locale == null) {
            return -1;
        }
        int n = NameDecoder.findLanguageCode(locale.getLanguage(), macLanguageCodes);
        switch (n) {
            case 19: {
                if (!locale.equals(Locale.SIMPLIFIED_CHINESE)) break;
                n = 33;
            }
        }
        return n;
    }

    private static int getMicrosoftLanguageCode(Locale locale) {
        if (locale == null) {
            return -1;
        }
        String string = locale.getLanguage();
        int n = NameDecoder.findLanguageCode(string, microsoftLanguageCodes);
        if (n == -1) {
            if (string.equals("hr") || string.equals("sr")) {
                n = 26;
            } else if (string.equals("gd")) {
                n = 60;
            }
        }
        return n;
    }

    private static int findLanguageCode(String string, String string2) {
        if (string == null) {
            return -1;
        }
        if (string.length() != 2) {
            return -1;
        }
        int n = 0;
        while ((n = string2.indexOf(string, n)) >= 0 && (n & 1) != 0) {
        }
        if (n < 0) {
            return -1;
        }
        return n /= 2;
    }

    private static String decodeName(int n, int n2, int n3, ByteBuffer byteBuffer, int n4, int n5) {
        String string = NameDecoder.getCharsetName(n, n3, n2);
        if (string == null) {
            return null;
        }
        return NameDecoder.decodeName(string, byteBuffer, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String decodeName(String string, ByteBuffer byteBuffer, int n, int n2) {
        String string2;
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        try {
            byteBuffer.position(n);
            byteBuffer.get(byArray);
            try {
                string2 = new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object var8_9 = null;
                byteBuffer.position(n3);
                return null;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            byteBuffer.position(n3);
            throw throwable;
        }
        byteBuffer.position(n3);
        return string2;
    }

    private static Locale getMacLocale(int n) {
        switch (n) {
            case 0: {
                return Locale.ENGLISH;
            }
            case 1: {
                return Locale.FRENCH;
            }
            case 2: {
                return Locale.GERMAN;
            }
            case 3: {
                return Locale.ITALIAN;
            }
            case 11: {
                return Locale.JAPANESE;
            }
            case 23: {
                return Locale.KOREAN;
            }
            case 19: {
                return Locale.TRADITIONAL_CHINESE;
            }
            case 33: {
                return Locale.SIMPLIFIED_CHINESE;
            }
        }
        if (n < 0 || n > 150) {
            return null;
        }
        String string = macLanguageCodes.substring(n << 1, n + 1 << 1);
        if (string.charAt(0) == ' ') {
            return null;
        }
        return new Locale(string);
    }

    private static Locale getWindowsLocale(int n) {
        switch (n) {
            case 1031: {
                return Locale.GERMAN;
            }
            case 1032: {
                return new Locale("el", "GR");
            }
            case 1033: {
                return Locale.ENGLISH;
            }
            case 1035: {
                return new Locale("fi");
            }
            case 1036: {
                return Locale.FRENCH;
            }
            case 1046: {
                return new Locale("pt");
            }
            case 2055: {
                return new Locale("de", "CH");
            }
            case 2057: {
                return new Locale("en", "UK");
            }
            case 2060: {
                return new Locale("fr", "BE");
            }
            case 2070: {
                return new Locale("pt", "BR");
            }
            case 3079: {
                return new Locale("de", "AT");
            }
            case 3081: {
                return new Locale("en", "AU");
            }
            case 3084: {
                return new Locale("fr", "CA");
            }
            case 4103: {
                return new Locale("de", "LU");
            }
            case 4105: {
                return new Locale("en", "CA");
            }
            case 4108: {
                return new Locale("fr", "CH");
            }
            case 5127: {
                return new Locale("de", "LI");
            }
            case 5129: {
                return new Locale("en", "NZ");
            }
            case 5132: {
                return new Locale("fr", "LU");
            }
            case 6153: {
                return new Locale("en", "IE");
            }
        }
        return null;
    }

    private static String getMacCharsetName(int n) {
        switch (n) {
            case 0: {
                return "MacRoman";
            }
            case 1: {
                return "MacJapanese";
            }
            case 2: {
                return "MacKorean";
            }
            case 3: {
                return "MacTradChinese";
            }
            case 4: {
                return "MacArabic";
            }
            case 5: {
                return "MacHebrew";
            }
            case 6: {
                return "MacGreek";
            }
            case 7: {
                return "MacCyrillic";
            }
            case 8: {
                return "MacRSymbol";
            }
            case 9: {
                return "MacDevanagari";
            }
            case 10: {
                return "MacGurmukhi";
            }
            case 11: {
                return "MacGujarati";
            }
            case 12: {
                return "MacOriya";
            }
            case 13: {
                return "MacBengali";
            }
            case 14: {
                return "MacTamil";
            }
            case 15: {
                return "MacTelugu";
            }
            case 16: {
                return "MacKannada";
            }
            case 17: {
                return "MacMalayalam";
            }
            case 18: {
                return "MacSinhalese";
            }
            case 19: {
                return "MacBurmese";
            }
            case 20: {
                return "MacKhmer";
            }
            case 21: {
                return "MacThai";
            }
            case 22: {
                return "MacLao";
            }
            case 23: {
                return "MacGeorgian";
            }
            case 24: {
                return "MacArmenian";
            }
            case 25: {
                return "MacSimpChinese";
            }
            case 26: {
                return "MacTibetan";
            }
            case 27: {
                return "MacMongolian";
            }
            case 28: {
                return "MacEthiopic";
            }
            case 29: {
                return "MacCentralEurope";
            }
            case 30: {
                return "MacVietnamese";
            }
            case 31: {
                return "MacExtArabic";
            }
        }
        return null;
    }

    private static String getMicrosoftCharsetName(int n) {
        int n2 = 63;
        int n3 = n & 0x3FF;
        if (n3 < 100) {
            n2 = " 612D022322225022EC2202201?002A462110777 68 ?2 1      2 2     2112 ?1           1     2           2 ".charAt(n3);
        }
        if (n2 == 63) {
            switch (n) {
                case 1050: 
                case 2074: {
                    n2 = 48;
                    break;
                }
                case 1068: 
                case 1091: {
                    n2 = 52;
                    break;
                }
                case 2092: 
                case 2115: 
                case 3098: {
                    n2 = 49;
                }
            }
        }
        switch (n2) {
            case 48: {
                return "windows-1250";
            }
            case 49: {
                return "windows-1251";
            }
            case 50: {
                return "windows-1252";
            }
            case 51: {
                return "windows-1253";
            }
            case 52: {
                return "windows-1254";
            }
            case 53: {
                return "windows-1255";
            }
            case 54: {
                return "windows-1256";
            }
            case 55: {
                return "windows-1257";
            }
            case 56: {
                return "windows-1258";
            }
            case 65: {
                return "windows-874";
            }
            case 66: {
                return "windows-936";
            }
            case 67: {
                return "windows-949";
            }
            case 68: {
                return "windows-950";
            }
            case 69: {
                return "windows-932";
            }
        }
        return null;
    }

    public static Locale getLocale(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return NameDecoder.getMacLocale(n2);
            }
            case 3: {
                return NameDecoder.getWindowsLocale(n2);
            }
        }
        return null;
    }

    public static String getCharsetName(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return NameDecoder.getMacCharsetName(n3);
            }
            case 3: {
                return NameDecoder.getMicrosoftCharsetName(n2);
            }
        }
        return null;
    }
}

