/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.Constants;
import gnu.java.awt.font.autofit.Width;
import gnu.java.awt.font.opentype.truetype.Fixed;

class Utils
implements Constants {
    private static final int ATAN_BITS = 8;
    private static final byte[] ATAN = new byte[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35, 36, 36, 36, 36, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 39, 40, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 42, 42, 43, 43, 43, 43, 44, 44, 44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 46, 47, 47, 47, 47, 48, 48, 48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 64, 64, 64};
    private static final int ANGLE_PI = 256;
    private static final int ANGLE_PI2 = 128;
    private static final int ANGLE_PI4 = 64;
    private static final int ANGLE_2PI = 512;

    Utils() {
    }

    static int computeDirection(int n, int n2) {
        int n3 = 0;
        if (n < 0) {
            if (n2 < 0) {
                if (-n * 12 < -n2) {
                    n3 = 2;
                } else if (-n2 * 12 < -n) {
                    n3 = -1;
                }
            } else if (-n * 12 < n2) {
                n3 = -2;
            } else if (n2 * 12 < -n) {
                n3 = -1;
            }
        } else if (n2 < 0) {
            if (n * 12 < -n2) {
                n3 = 2;
            } else if (-n2 * 12 < n) {
                n3 = 1;
            }
        } else if (n * 12 < n2) {
            n3 = -2;
        } else if (n2 * 12 < n) {
            n3 = 1;
        }
        return n3;
    }

    public static int atan(int n, int n2) {
        if (n2 == 0) {
            int n3 = 0;
            if (n < 0) {
                n3 = 256;
            }
            return n3;
        }
        if (n == 0) {
            int n4 = 128;
            if (n2 < 0) {
                n4 = -128;
            }
            return n4;
        }
        int n5 = 0;
        if (n < 0) {
            n = -n;
            n2 = -n2;
            n5 = 256;
        }
        if (n2 < 0) {
            int n6 = n;
            n = -n2;
            n2 = n6;
            n5 -= 128;
        }
        if (n == 0 && n2 == 0) {
            return 0;
        }
        n5 = n == n2 ? (n5 += 64) : (n > n2 ? (n5 += ATAN[Fixed.div(n2, n) << 2]) : (n5 += 128 - ATAN[Fixed.div(n, n2) << 2]));
        if (n5 > 256) {
            n5 -= 512;
        }
        return n5;
    }

    public static int angleDiff(int n, int n2) {
        int n3 = n2 - n;
        if ((n3 %= 512) < 0) {
            n3 += 512;
        }
        if (n3 > 256) {
            n3 -= 512;
        }
        return n3;
    }

    static void sort(int n, int[] nArray) {
        for (int i = 1; i < n; ++i) {
            for (int j = i; j > 0 && nArray[j] <= nArray[j - 1]; --j) {
                int n2 = nArray[j];
                nArray[j] = nArray[j - 1];
                nArray[j - 1] = n2;
            }
        }
    }

    static void sort(int n, Width[] widthArray) {
        for (int i = 1; i < n; ++i) {
            for (int j = 1; j > 0 && widthArray[j].org <= widthArray[j - 1].org; --j) {
                Width width = widthArray[j];
                widthArray[j] = widthArray[j - 1];
                widthArray[j - 1] = width;
            }
        }
    }

    static int pixRound(int n) {
        return Utils.pixFloor(n + 32);
    }

    static int pixFloor(int n) {
        return n & 0xFFFFFFC0;
    }

    public static int mulDiv(int n, int n2, int n3) {
        long l = n * n2;
        long l2 = l / (long)n3;
        return (int)l2;
    }
}

