/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.font.FontFactory;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.lang.CPStringBuilder;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTypeFontPeer
extends ClasspathFontPeer {
    private static Properties fontProperties = new Properties();
    private static Set<String> availableFontNames;
    private static Map<String, Map<String, String>> fontToFileMap;
    private static final AffineTransform IDENDITY;
    private FontDelegate fontDelegate;

    public OpenTypeFontPeer(String string, int n, int n2) {
        super(string, n, n2);
        try {
            String string2 = OpenTypeFontPeer.encodeFont(string, n);
            String string3 = this.mapFontToFilename(string2);
            File file = new File(string3);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            this.fontDelegate = FontFactory.createFonts(mappedByteBuffer)[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OpenTypeFontPeer(String string, Map map) {
        super(string, map);
        try {
            String string2 = OpenTypeFontPeer.encodeFont(string, map);
            String string3 = this.mapFontToFilename(string2);
            File file = new File(string3);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            this.fontDelegate = FontFactory.createFonts(mappedByteBuffer)[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean canDisplay(Font font, int n) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int canDisplayUpTo(Font font, CharacterIterator characterIterator, int n, int n2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getSubFamilyName(Font font, Locale locale) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getPostScriptName(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int getNumGlyphs(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int getMissingGlyphCode(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public byte getBaselineFor(Font font, char c) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getGlyphName(Font font, int n) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return this.fontDelegate.createGlyphVector(font, fontRenderContext, characterIterator);
    }

    @Override
    public GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public GlyphVector layoutGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray), n, n2, 0);
        return this.fontDelegate.createGlyphVector(font, fontRenderContext, stringCharacterIterator);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return new XFontMetrics(font);
    }

    @Override
    public boolean hasUniformLineMetrics(Font font) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LineMetrics getLineMetrics(Font font, CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return new XLineMetrics(font, characterIterator, n, n2, fontRenderContext);
    }

    @Override
    public Rectangle2D getMaxCharBounds(Font font, FontRenderContext fontRenderContext) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static String encodeFont(String string, Map map) {
        Float f;
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            string2 = (String)map.get(TextAttribute.FAMILY);
        }
        if (string2 == null) {
            string2 = "SansSerif";
        }
        int n = 0;
        Float f2 = (Float)map.get(TextAttribute.POSTURE);
        if (f2 != null && !f2.equals(TextAttribute.POSTURE_REGULAR)) {
            n |= 2;
        }
        if ((f = (Float)map.get(TextAttribute.WEIGHT)) != null && f.compareTo(TextAttribute.WEIGHT_REGULAR) > 0) {
            n |= 1;
        }
        return OpenTypeFontPeer.encodeFont(string, n);
    }

    static String encodeFont(String string, int n) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(OpenTypeFontPeer.validName(string));
        cPStringBuilder.append('/');
        switch (n) {
            case 1: {
                cPStringBuilder.append("b");
                break;
            }
            case 2: {
                cPStringBuilder.append("i");
                break;
            }
            case 3: {
                cPStringBuilder.append("bi");
                break;
            }
            default: {
                cPStringBuilder.append("p");
            }
        }
        return cPStringBuilder.toString();
    }

    static String validName(String string) {
        Set<String> set = OpenTypeFontPeer.getFontNames();
        String string2 = set.contains(string) ? string : "SansSerif";
        return string2;
    }

    public static String[] getAvailableFontFamilyNames(Locale locale) {
        Set<String> set = OpenTypeFontPeer.getFontNames();
        int n = set.size();
        String[] stringArray = set.toArray(new String[n]);
        return stringArray;
    }

    private static synchronized Set<String> getFontNames() {
        if (availableFontNames == null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Object k : fontProperties.keySet()) {
                if (!(k instanceof String)) continue;
                String string = (String)k;
                int n = string.indexOf(47);
                String string2 = string.substring(0, n);
                hashSet.add(string2);
            }
            availableFontNames = hashSet;
        }
        return availableFontNames;
    }

    private synchronized String mapFontToFilename(String string) {
        String string2;
        String string32;
        if (fontToFileMap == null) {
            Map<String, String> map;
            String string4;
            String string5;
            int n;
            fontToFileMap = new HashMap<String, Map<String, String>>();
            for (String string32 : fontProperties.keySet()) {
                if (!(string32 instanceof String)) continue;
                string2 = string32;
                n = string2.indexOf(47);
                string5 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
                if (string4.equals("a")) continue;
                map = fontToFileMap.get(string5);
                if (map == null) {
                    map = new HashMap<String, String>();
                    fontToFileMap.put(string5, map);
                }
                map.put(string4, fontProperties.getProperty(string2));
            }
            for (String string32 : fontProperties.keySet()) {
                if (!(string32 instanceof String)) continue;
                string2 = string32;
                n = string2.indexOf(47);
                string5 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
                if (!string4.equals("a")) continue;
                map = fontProperties.getProperty(string2);
                Map<String, String> map2 = fontToFileMap.get(map);
                fontToFileMap.put(string5, map2);
            }
        }
        int n = string.indexOf(47);
        string32 = string.substring(0, n);
        string2 = string.substring(n + 1);
        return fontToFileMap.get(string32).get(string2);
    }

    static {
        InputStream inputStream = OpenTypeFontPeer.class.getResourceAsStream("fonts.properties");
        try {
            fontProperties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        IDENDITY = new AffineTransform();
    }

    private class XFontMetrics
    extends FontMetrics {
        private Point2D cachedPoint;

        XFontMetrics(Font font) {
            super(font);
            this.cachedPoint = new Point2D.Double();
        }

        public int getAscent() {
            return (int)OpenTypeFontPeer.this.fontDelegate.getAscent(this.getFont().getSize(), IDENDITY, false, false, false);
        }

        public int getDescent() {
            return (int)OpenTypeFontPeer.this.fontDelegate.getDescent(this.getFont().getSize(), IDENDITY, false, false, false);
        }

        public int getHeight() {
            GlyphVector glyphVector = OpenTypeFontPeer.this.fontDelegate.createGlyphVector(this.getFont(), new FontRenderContext(IDENDITY, false, false), new StringCharacterIterator("m"));
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            return (int)rectangle2D.getHeight();
        }

        public int charWidth(char c) {
            int n = OpenTypeFontPeer.this.fontDelegate.getGlyphIndex(c);
            Point2D point2D = this.cachedPoint;
            OpenTypeFontPeer.this.fontDelegate.getAdvance(n, this.font.getSize2D(), IDENDITY, false, false, true, point2D);
            return (int)point2D.getX();
        }

        public int charsWidth(char[] cArray, int n, int n2) {
            return this.stringWidth(new String(cArray, n, n2));
        }

        public int stringWidth(String string) {
            GlyphVector glyphVector = OpenTypeFontPeer.this.fontDelegate.createGlyphVector(this.getFont(), new FontRenderContext(IDENDITY, false, false), new StringCharacterIterator(string));
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            return (int)rectangle2D.getWidth();
        }
    }

    private class XLineMetrics
    extends LineMetrics {
        private Font font;
        private GlyphVector glyphVector;
        private FontRenderContext fontRenderContext;

        XLineMetrics(Font font, CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
            this.font = font;
            this.fontRenderContext = fontRenderContext;
            this.glyphVector = OpenTypeFontPeer.this.fontDelegate.createGlyphVector(this.font, this.fontRenderContext, characterIterator);
        }

        public float getAscent() {
            return OpenTypeFontPeer.this.fontDelegate.getAscent(this.font.getSize(), this.fontRenderContext.getTransform(), this.fontRenderContext.isAntiAliased(), this.fontRenderContext.usesFractionalMetrics(), true);
        }

        public int getBaselineIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public float[] getBaselineOffsets() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public float getDescent() {
            return (int)OpenTypeFontPeer.this.fontDelegate.getDescent(this.font.getSize(), IDENDITY, false, false, false);
        }

        public float getHeight() {
            return (float)this.glyphVector.getLogicalBounds().getHeight();
        }

        public float getLeading() {
            return this.getHeight() - this.getAscent() - this.getDescent();
        }

        public int getNumChars() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public float getStrikethroughOffset() {
            return 0.0f;
        }

        public float getStrikethroughThickness() {
            return 0.0f;
        }

        public float getUnderlineOffset() {
            return 0.0f;
        }

        public float getUnderlineThickness() {
            return 0.0f;
        }
    }
}

