/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.java2d.ShapeWrapper;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GNUGlyphVector
extends GlyphVector {
    private FontDelegate fontDelegate;
    private Font font;
    private FontRenderContext renderContext;
    private int[] glyphs;
    private float fontSize;
    private AffineTransform transform;
    private boolean valid;
    private float[] pos;
    private AffineTransform[] transforms;
    private int layoutFlags;
    private Shape cleanOutline;

    public GNUGlyphVector(FontDelegate fontDelegate, Font font, FontRenderContext fontRenderContext, int[] nArray) {
        this.fontDelegate = fontDelegate;
        this.font = font;
        this.renderContext = fontRenderContext;
        this.glyphs = nArray;
        this.fontSize = font.getSize2D();
        this.transform = font.getTransform();
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.renderContext;
    }

    public void performDefaultLayout() {
        Point2D.Float float_ = new Point2D.Float();
        this.pos = new float[(this.glyphs.length + 1) * 2];
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        n = 0;
        for (int i = 0; i < this.glyphs.length; ++i) {
            AffineTransform affineTransform;
            n += 2;
            if (this.transforms == null || (affineTransform = this.transforms[i]) == null) {
                affineTransform = this.transform;
            } else {
                affineTransform = new AffineTransform(affineTransform);
                affineTransform.concatenate(this.transform);
            }
            this.fontDelegate.getAdvance(this.glyphs[i], this.fontSize, affineTransform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), true, float_);
            this.pos[n] = f2 += (float)Math.round(float_.x);
            this.pos[n + 1] = f += float_.y;
        }
        this.valid = true;
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public int getGlyphCode(int n) {
        return this.glyphs[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        System.arraycopy(this.glyphs, n, nArray, 0, n2);
        return nArray;
    }

    public Rectangle2D getLogicalBounds() {
        this.validate();
        return new Rectangle2D.Float(0.0f, 0.0f, this.pos[this.pos.length - 2], this.getAscent() - this.getDescent());
    }

    public Rectangle2D getVisualBounds() {
        this.validate();
        return this.getLogicalBounds();
    }

    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    public Shape getOutline(float f, float f2) {
        Shape shape;
        GeneralPath generalPath;
        this.validate();
        if (this.cleanOutline == null) {
            generalPath = new GeneralPath();
            int n = this.glyphs.length;
            for (int i = 0; i < n; ++i) {
                GeneralPath generalPath2 = new GeneralPath(this.getGlyphOutline(i));
                generalPath.append(generalPath2, false);
            }
            shape = this.cleanOutline = new ShapeWrapper(generalPath);
        } else {
            shape = this.cleanOutline;
        }
        if (f != 0.0f || f2 != 0.0f) {
            generalPath = new GeneralPath(shape);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f, f2);
            generalPath.transform(affineTransform);
            shape = generalPath;
        }
        return shape;
    }

    public Shape getOutline(float f, float f2, int n) {
        this.validate();
        GeneralPath generalPath = new GeneralPath();
        int n2 = this.glyphs.length;
        for (int i = 0; i < n2; ++i) {
            GeneralPath generalPath2 = new GeneralPath(this.getGlyphOutline(i, n));
            generalPath.append(generalPath2, false);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f, f2);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Shape getGlyphOutline(int n) {
        AffineTransform affineTransform;
        AffineTransform affineTransform2;
        this.validate();
        if (this.transforms != null && (affineTransform2 = this.transforms[n]) != null) {
            affineTransform = new AffineTransform(this.transform);
            affineTransform.concatenate(affineTransform2);
        } else {
            affineTransform = this.transform;
        }
        GeneralPath generalPath = this.fontDelegate.getGlyphOutline(this.glyphs[n], this.fontSize, affineTransform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), 1);
        affineTransform = new AffineTransform();
        affineTransform.translate(this.pos[n * 2], this.pos[n * 2 + 1]);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Shape getGlyphOutline(int n, int n2) {
        AffineTransform affineTransform;
        AffineTransform affineTransform2;
        this.validate();
        if (this.transforms != null && (affineTransform2 = this.transforms[n]) != null) {
            affineTransform = new AffineTransform(this.transform);
            affineTransform.concatenate(affineTransform2);
        } else {
            affineTransform = this.transform;
        }
        GeneralPath generalPath = this.fontDelegate.getGlyphOutline(this.glyphs[n], this.fontSize, affineTransform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), n2);
        affineTransform = new AffineTransform();
        affineTransform.translate(this.pos[n * 2], this.pos[n * 2 + 1]);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Point2D getGlyphPosition(int n) {
        this.validate();
        return new Point2D.Float(this.pos[n * 2], this.pos[n * 2 + 1]);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.validate();
        this.pos[n * 2] = (float)point2D.getX();
        this.pos[n * 2 + 1] = (float)point2D.getY();
    }

    public AffineTransform getGlyphTransform(int n) {
        if (this.transforms == null) {
            return null;
        }
        return this.transforms[n];
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (this.transforms == null) {
            this.transforms = new AffineTransform[this.glyphs.length];
        }
        this.transforms[n] = affineTransform;
        if (affineTransform != null) {
            this.layoutFlags |= 1;
        }
        this.valid = false;
    }

    public int getLayoutFlags() {
        return this.layoutFlags;
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.validate();
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        System.arraycopy(this.pos, n * 2, fArray, 0, n2 * 2);
        return fArray;
    }

    private float getAscent() {
        return this.fontDelegate.getAscent(this.fontSize, this.transform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), true);
    }

    private float getDescent() {
        return this.fontDelegate.getDescent(this.fontSize, this.transform, this.renderContext.isAntiAliased(), this.renderContext.usesFractionalMetrics(), true);
    }

    public Shape getGlyphLogicalBounds(int n) {
        this.validate();
        float f = this.getAscent();
        float f2 = this.pos[n * 2];
        float f3 = this.pos[n * 2 + 1];
        return new Rectangle2D.Float(f2, f3 - f, this.pos[(n + 1) * 2] - f2, f - this.getDescent());
    }

    public Shape getGlyphVisualBounds(int n) {
        return this.getGlyphOutline(n).getBounds2D();
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        throw new UnsupportedOperationException();
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(GlyphVector glyphVector) {
        int n;
        if (!(glyphVector instanceof GNUGlyphVector)) {
            return false;
        }
        GNUGlyphVector gNUGlyphVector = (GNUGlyphVector)glyphVector;
        if (this.font != gNUGlyphVector.font || this.fontDelegate != gNUGlyphVector.fontDelegate || this.renderContext != gNUGlyphVector.renderContext || this.glyphs.length != gNUGlyphVector.glyphs.length) {
            return false;
        }
        for (n = 0; n < this.glyphs.length; ++n) {
            if (this.glyphs[n] == gNUGlyphVector.glyphs[n]) continue;
            return false;
        }
        this.validate();
        gNUGlyphVector.validate();
        for (n = 0; n < this.pos.length; ++n) {
            if (this.pos[n] == gNUGlyphVector.pos[n]) continue;
            return false;
        }
        return true;
    }

    private void validate() {
        if (!this.valid) {
            this.performDefaultLayout();
        }
    }
}

