/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.dnd.peer.gtk;

import gnu.java.awt.dnd.peer.gtk.GtkDropTargetContextPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;

public class GtkDragSourceContextPeer
extends GtkGenericPeer
implements DragSourceContextPeer {
    private ComponentPeer peer;
    private Cursor cursor;
    private DragSourceContext context;
    public static Component target;

    native void nativeStartDrag(Image var1, int var2, int var3, int var4, String var5);

    native void connectSignals(ComponentPeer var1);

    native void create(ComponentPeer var1);

    native void nativeSetCursor(int var1);

    native void setTarget(GtkDropTargetContextPeer var1);

    public GtkDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent.getComponent());
        Component component = dragGestureEvent.getComponent();
        this.peer = this.getComponentPeer(component);
        this.create(this.peer);
        this.connectSignals(this.peer);
        this.cursor = component.getCursor();
        if (target != null) {
            this.setTarget(new GtkDropTargetContextPeer(target));
        }
    }

    ComponentPeer getComponentPeer(Component component) {
        if (component == null) {
            return null;
        }
        Component component2 = component;
        while (component2.getPeer() instanceof LightweightPeer) {
            component2 = component2.getParent();
        }
        if (component2 != null) {
            return component2.getPeer();
        }
        return null;
    }

    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.context = dragSourceContext;
        if (point == null) {
            point = new Point();
        }
        this.setCursor(cursor);
        this.nativeStartDrag(image, point.x, point.y, dragSourceContext.getTrigger().getDragAction(), "text/plain");
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        if (cursor != null) {
            this.nativeSetCursor(cursor.getType());
            this.cursor = cursor;
        }
    }

    public void transferablesFlavorsChanged() {
    }

    public void dragEnter(int n, int n2) {
        this.context.dragEnter(new DragSourceDragEvent(this.context, n, n & this.context.getSourceActions(), n2));
    }

    public void dragExit(int n, int n2, int n3) {
        this.context.dragExit(new DragSourceEvent(this.context, n2, n3));
    }

    public void dragDropEnd(int n, boolean bl, int n2, int n3) {
        this.context.dragDropEnd(new DragSourceDropEvent(this.context, n, bl, n2, n3));
    }

    public void dragMouseMoved(int n, int n2) {
        this.context.dragMouseMoved(new DragSourceDragEvent(this.context, n, n & this.context.getSourceActions(), n2));
    }

    public void dragOver(int n, int n2) {
        this.context.dragOver(new DragSourceDragEvent(this.context, n, n & this.context.getSourceActions(), n2));
    }

    public void dragActionChanged(int n, int n2) {
        this.context.dropActionChanged(new DragSourceDragEvent(this.context, n, n & this.context.getSourceActions(), n2));
    }
}

