/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class GradientPaintContext
implements PaintContext {
    private final float x1;
    private final float y1;
    private final Color c1;
    private final float x2;
    private final float y2;
    private final Color c2;
    private final boolean cyclic;
    private final double length;

    public GradientPaintContext(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        this.x1 = f;
        this.y1 = f2;
        this.c1 = color;
        this.x2 = f3;
        this.y2 = f4;
        this.c2 = color2;
        this.cyclic = bl;
        this.length = Point2D.distance(f, f2, f3, f4);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        double d = (this.x1 - this.x2) * (this.x1 - this.x2) + (this.y1 - this.y2) * (this.y1 - this.y2);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d2 = 0.0;
                if (d != 0.0) {
                    d2 = (double)(((float)(n + j) - this.x1) * (this.x2 - this.x1) + ((float)(n2 + i) - this.y1) * (this.y2 - this.y1)) / Math.sqrt(d);
                }
                double d3 = d2 / this.length;
                d3 = this.cyclic ? Math.abs(d3 - Math.floor((d3 + 1.0) / 2.0) * 2.0) : Math.max(0.0, Math.min(1.0, d3));
                int n5 = (i * n3 + j) * 4;
                nArray[n5] = (int)((double)this.c1.getRed() + d3 * (double)(this.c2.getRed() - this.c1.getRed()));
                nArray[n5 + 1] = (int)((double)this.c1.getGreen() + d3 * (double)(this.c2.getGreen() - this.c1.getGreen()));
                nArray[n5 + 2] = (int)((double)this.c1.getBlue() + d3 * (double)(this.c2.getBlue() - this.c1.getBlue()));
                nArray[n5 + 3] = (int)((double)this.c1.getAlpha() + d3 * (double)(this.c2.getAlpha() - this.c1.getAlpha()));
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    public void dispose() {
    }
}

