/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSequentialList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class AWTUtilities {
    static WeakHashMap visibleChildrenCache = new WeakHashMap();

    public static List getVisibleChildren(Container container) {
        Component[] componentArray = container.getComponents();
        Object v = visibleChildrenCache.get(componentArray);
        VisibleComponentList visibleComponentList = null;
        if (v == null) {
            visibleComponentList = new VisibleComponentList(componentArray);
            visibleChildrenCache.put(componentArray, visibleComponentList);
        } else {
            visibleComponentList = (VisibleComponentList)v;
        }
        return visibleComponentList;
    }

    public static Rectangle calculateInsetArea(Rectangle rectangle, Insets insets, Rectangle rectangle2) {
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        return rectangle2;
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static Container getAncestorNamed(String string, Component component) {
        while (component != null && component.getName() != string) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Container getAncestorOfClass(Class clazz, Component component) {
        while (component != null && !clazz.isInstance(component)) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Window windowForComponent(Component component) {
        return (Window)AWTUtilities.getAncestorOfClass(Window.class, component);
    }

    public static Component getRoot(Component component) {
        Applet applet = null;
        Window window = null;
        while (component != null) {
            if (window == null && component instanceof Window) {
                window = (Window)component;
            } else if (component instanceof Applet) {
                applet = (Applet)component;
            }
            component = component.getParent();
        }
        if (window != null) {
            return window;
        }
        return applet;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null && component2 != null) {
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (component == null || !component.contains(n, n2)) {
            return null;
        }
        if (!(component instanceof Container)) {
            return component;
        }
        Container container = (Container)component;
        return container.findComponentAt(n, n2);
    }

    public static void convertPointToScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(point2.x, point2.y);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null) {
            component = AWTUtilities.getRoot(component2);
        }
        if (component2 == null) {
            component2 = AWTUtilities.getRoot(component);
        }
        if (component.isShowing() && component2.isShowing()) {
            AWTUtilities.convertPointToScreen(point, component);
            AWTUtilities.convertPointFromScreen(point, component2);
        }
        return point;
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = AWTUtilities.convertPoint(component, rectangle.x, rectangle.y, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = AWTUtilities.convertPoint(component, mouseEvent.getX(), mouseEvent.getY(), component2);
        return new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static boolean isValidKey(int n) {
        switch (n) {
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 160: 
            case 161: 
            case 162: 
            case 192: 
            case 222: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 61440: 
            case 61441: 
            case 61442: 
            case 61443: 
            case 61444: 
            case 61445: 
            case 61446: 
            case 61447: 
            case 61448: 
            case 61449: 
            case 61450: 
            case 61451: 
            case 65312: 
            case 65368: 
            case 65406: 
            case 65480: 
            case 65481: 
            case 65482: 
            case 65483: 
            case 65485: 
            case 65487: 
            case 65488: 
            case 65489: {
                return true;
            }
        }
        return false;
    }

    static class VisibleComponentList
    extends AbstractSequentialList {
        Component[] components;

        VisibleComponentList(Component[] componentArray) {
            this.components = componentArray;
        }

        public ListIterator listIterator(int n) {
            return new VisibleComponentIterator(n);
        }

        public int size() {
            int n = 0;
            for (int i = 0; i < this.components.length; ++i) {
                if (!this.components[i].isVisible()) continue;
                ++n;
            }
            return n;
        }

        class VisibleComponentIterator
        implements ListIterator {
            int index;
            int listIndex;

            VisibleComponentIterator(int n) {
                this.listIndex = n;
                int n2 = 0;
                this.index = 0;
                while (n2 != n) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        ++n2;
                    }
                    ++this.index;
                }
            }

            public boolean hasNext() {
                boolean bl = false;
                for (int i = this.index; i < VisibleComponentList.this.components.length; ++i) {
                    if (!VisibleComponentList.this.components[i].isVisible()) continue;
                    bl = true;
                    break;
                }
                return bl;
            }

            public Object next() {
                Component component = null;
                while (this.index < VisibleComponentList.this.components.length) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        component = VisibleComponentList.this.components[this.index];
                        break;
                    }
                    ++this.index;
                }
                if (component != null) {
                    ++this.index;
                    ++this.listIndex;
                    return component;
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                boolean bl = false;
                for (int i = this.index - 1; i >= 0; --i) {
                    if (!VisibleComponentList.this.components[i].isVisible()) continue;
                    bl = true;
                    break;
                }
                return bl;
            }

            public Object previous() {
                Component component = null;
                --this.index;
                while (this.index >= 0) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        component = VisibleComponentList.this.components[this.index];
                        break;
                    }
                    --this.index;
                }
                if (component != null) {
                    --this.listIndex;
                    return component;
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.listIndex + 1;
            }

            public int previousIndex() {
                return this.listIndex - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void set(Object object) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void add(Object object) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }
        }
    }
}

