/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.value;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.InvalidTagException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.value.BooleanValue;
import gnu.classpath.jdwp.value.ByteValue;
import gnu.classpath.jdwp.value.CharValue;
import gnu.classpath.jdwp.value.DoubleValue;
import gnu.classpath.jdwp.value.FloatValue;
import gnu.classpath.jdwp.value.IntValue;
import gnu.classpath.jdwp.value.LongValue;
import gnu.classpath.jdwp.value.ObjectValue;
import gnu.classpath.jdwp.value.ShortValue;
import gnu.classpath.jdwp.value.StringValue;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.VoidValue;
import java.nio.ByteBuffer;

public class ValueFactory {
    public static Value createFromTagged(ByteBuffer byteBuffer) throws JdwpInternalErrorException, InvalidObjectException, InvalidTagException {
        return ValueFactory.create(byteBuffer, byteBuffer.get());
    }

    public static Value createFromUntagged(ByteBuffer byteBuffer, Class clazz) throws JdwpInternalErrorException, InvalidObjectException, InvalidClassException {
        byte by = ValueFactory.getTagForClass(clazz);
        try {
            return ValueFactory.create(byteBuffer, by);
        }
        catch (InvalidTagException invalidTagException) {
            throw new InvalidClassException(invalidTagException);
        }
    }

    private static Value create(ByteBuffer byteBuffer, byte by) throws JdwpInternalErrorException, InvalidObjectException, InvalidTagException {
        Value value = null;
        switch (by) {
            case 66: {
                value = new ByteValue(byteBuffer.get());
                break;
            }
            case 90: {
                value = new BooleanValue(byteBuffer.get() != 0);
                break;
            }
            case 67: {
                value = new CharValue(byteBuffer.getChar());
                break;
            }
            case 83: {
                value = new ShortValue(byteBuffer.getShort());
                break;
            }
            case 73: {
                value = new IntValue(byteBuffer.getInt());
                break;
            }
            case 70: {
                value = new FloatValue(byteBuffer.getFloat());
                break;
            }
            case 74: {
                value = new LongValue(byteBuffer.getLong());
                break;
            }
            case 68: {
                value = new DoubleValue(byteBuffer.getDouble());
                break;
            }
            case 86: {
                value = new VoidValue();
                break;
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 116: {
                ObjectId objectId = VMIdManager.getDefault().readObjectId(byteBuffer);
                value = new ObjectValue(objectId.getObject());
                break;
            }
            case 115: {
                value = new StringValue(JdwpString.readString(byteBuffer));
                break;
            }
            default: {
                throw new InvalidTagException(by);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte getTagForClass(Class clazz) throws JdwpInternalErrorException {
        if (!clazz.isPrimitive()) return (byte)76;
        if (clazz == Byte.TYPE) {
            return (byte)66;
        }
        if (clazz == Boolean.TYPE) {
            return (byte)90;
        }
        if (clazz == Character.TYPE) {
            return (byte)67;
        }
        if (clazz == Short.TYPE) {
            return (byte)83;
        }
        if (clazz == Integer.TYPE) {
            return (byte)73;
        }
        if (clazz == Float.TYPE) {
            return (byte)70;
        }
        if (clazz == Long.TYPE) {
            return (byte)74;
        }
        if (clazz == Double.TYPE) {
            return (byte)68;
        }
        if (clazz != Void.TYPE) throw new JdwpInternalErrorException("Invalid primitive class");
        return (byte)86;
    }

    public static Value createFromObject(Object object, Class clazz) {
        Value value = null;
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                value = new ByteValue((Byte)object);
            } else if (clazz == Boolean.TYPE) {
                value = new BooleanValue((Boolean)object);
            } else if (clazz == Character.TYPE) {
                value = new CharValue(((Character)object).charValue());
            } else if (clazz == Short.TYPE) {
                value = new ShortValue((Short)object);
            } else if (clazz == Integer.TYPE) {
                value = new IntValue((Integer)object);
            } else if (clazz == Float.TYPE) {
                value = new FloatValue(((Float)object).floatValue());
            } else if (clazz == Long.TYPE) {
                value = new LongValue((Long)object);
            } else if (clazz == Double.TYPE) {
                value = new DoubleValue((Double)object);
            } else if (clazz == Void.TYPE) {
                value = new VoidValue();
            }
        } else {
            value = clazz.isAssignableFrom(String.class) ? new StringValue((String)object) : new ObjectValue(object);
        }
        return value;
    }
}

