/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.value;

import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.InvalidTagException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Value {
    private byte _tag;

    protected Value(byte by) {
        this._tag = by;
    }

    public byte getTag() {
        return this._tag;
    }

    public void writeUntagged(DataOutputStream dataOutputStream) throws IOException {
        this.write(dataOutputStream);
    }

    public void writeTagged(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this._tag);
        this.write(dataOutputStream);
    }

    protected abstract void write(DataOutputStream var1) throws IOException;

    protected abstract Object getObject();

    public static Object getUntaggedObject(ByteBuffer byteBuffer, Class clazz) throws JdwpInternalErrorException, InvalidObjectException, InvalidClassException {
        Value value = ValueFactory.createFromUntagged(byteBuffer, clazz);
        return value.getObject();
    }

    public static Object getTaggedObject(ByteBuffer byteBuffer) throws JdwpInternalErrorException, InvalidObjectException, InvalidTagException {
        Value value = ValueFactory.createFromTagged(byteBuffer);
        return value.getObject();
    }
}

