/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.java.lang.CPStringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Signature {
    public static String computeClassSignature(Class clazz) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        Signature._addToSignature(cPStringBuilder, clazz);
        return cPStringBuilder.toString();
    }

    public static String computeFieldSignature(Field field) {
        return Signature.computeClassSignature(field.getType());
    }

    public static String computeMethodSignature(Method method) {
        return Signature._computeSignature(method.getReturnType(), method.getParameterTypes());
    }

    private static String _computeSignature(Class clazz, Class[] classArray) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder("(");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Signature._addToSignature(cPStringBuilder, classArray[i]);
            }
        }
        cPStringBuilder.append(")");
        Signature._addToSignature(cPStringBuilder, clazz);
        return cPStringBuilder.toString();
    }

    private static void _addToSignature(CPStringBuilder cPStringBuilder, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                cPStringBuilder.append('V');
            } else if (clazz == Boolean.TYPE) {
                cPStringBuilder.append('Z');
            } else if (clazz == Byte.TYPE) {
                cPStringBuilder.append('B');
            } else if (clazz == Character.TYPE) {
                cPStringBuilder.append('C');
            } else if (clazz == Short.TYPE) {
                cPStringBuilder.append('S');
            } else if (clazz == Integer.TYPE) {
                cPStringBuilder.append('I');
            } else if (clazz == Float.TYPE) {
                cPStringBuilder.append('F');
            } else if (clazz == Double.TYPE) {
                cPStringBuilder.append('D');
            } else if (clazz == Long.TYPE) {
                cPStringBuilder.append('J');
            }
            return;
        }
        String string = clazz.getName();
        int n = string.length();
        cPStringBuilder.ensureCapacity(n);
        if (!clazz.isArray()) {
            cPStringBuilder.append('L');
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                c = '/';
            }
            cPStringBuilder.append(c);
        }
        if (!clazz.isArray()) {
            cPStringBuilder.append(';');
        }
    }
}

