/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Location {
    private VMMethod method;
    private long index;

    public Location(VMMethod vMMethod, long l) {
        this.method = vMMethod;
        this.index = l;
    }

    public Location(ByteBuffer byteBuffer) throws IOException, JdwpException {
        byte by = byteBuffer.get();
        ClassReferenceTypeId classReferenceTypeId = (ClassReferenceTypeId)VMIdManager.getDefault().readReferenceTypeId(byteBuffer);
        Class clazz = classReferenceTypeId.getType();
        this.method = VMMethod.readId(clazz, byteBuffer);
        this.index = byteBuffer.getLong();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        if (this.method != null) {
            VMIdManager vMIdManager = VMIdManager.getDefault();
            ClassReferenceTypeId classReferenceTypeId = (ClassReferenceTypeId)vMIdManager.getReferenceTypeId(this.method.getDeclaringClass());
            classReferenceTypeId.writeTagged(dataOutputStream);
            this.method.writeId(dataOutputStream);
            dataOutputStream.writeLong(this.index);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeLong(0L);
            dataOutputStream.writeLong(0L);
            dataOutputStream.writeLong(0L);
        }
    }

    public static Location getEmptyLocation() {
        return new Location(null, 0L);
    }

    public VMMethod getMethod() {
        return this.method;
    }

    public long getIndex() {
        return this.index;
    }

    public String toString() {
        return this.method.toString() + "." + this.index;
    }

    public boolean equals(Object object) {
        if (object instanceof Location) {
            Location location = (Location)object;
            return this.getMethod().equals(location.getMethod()) && this.getIndex() == location.getIndex();
        }
        return false;
    }
}

