/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.SocketTransport;
import gnu.classpath.jdwp.transport.TransportException;
import java.util.HashMap;

public class TransportFactory {
    private static final String _TRANSPORT_PROPERTY = "transport";
    private static TransportMethod[] _transportMethods = new TransportMethod[]{new TransportMethod("dt_socket", SocketTransport.class)};

    public static ITransport newInstance(HashMap hashMap) throws TransportException {
        String string = null;
        if (hashMap != null) {
            string = (String)hashMap.get(_TRANSPORT_PROPERTY);
        }
        if (string == null) {
            throw new TransportException("no transport specified");
        }
        for (int i = 0; i < _transportMethods.length; ++i) {
            if (!TransportFactory._transportMethods[i].name.equals(string)) continue;
            try {
                ITransport iTransport = (ITransport)TransportFactory._transportMethods[i].clazz.newInstance();
                iTransport.configure(hashMap);
                return iTransport;
            }
            catch (TransportException transportException) {
                throw transportException;
            }
            catch (Exception exception) {
                throw new TransportException(exception);
            }
        }
        throw new TransportException("transport \"" + string + "\" not found");
    }

    private static class TransportMethod {
        String name;
        Class clazz;

        public TransportMethod(String string, Class clazz) {
            this.name = string;
            this.clazz = clazz;
        }
    }
}

