/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StringReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeValue(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in String Reference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeValue(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        String string = (String)objectId.getObject();
        JdwpString.writeString(dataOutputStream, string);
    }
}

