/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.filters.ClassExcludeFilter;
import gnu.classpath.jdwp.event.filters.ClassMatchFilter;
import gnu.classpath.jdwp.event.filters.ClassOnlyFilter;
import gnu.classpath.jdwp.event.filters.ConditionalFilter;
import gnu.classpath.jdwp.event.filters.CountFilter;
import gnu.classpath.jdwp.event.filters.ExceptionOnlyFilter;
import gnu.classpath.jdwp.event.filters.FieldOnlyFilter;
import gnu.classpath.jdwp.event.filters.IEventFilter;
import gnu.classpath.jdwp.event.filters.InstanceOnlyFilter;
import gnu.classpath.jdwp.event.filters.LocationOnlyFilter;
import gnu.classpath.jdwp.event.filters.StepFilter;
import gnu.classpath.jdwp.event.filters.ThreadOnlyFilter;
import gnu.classpath.jdwp.exception.JdwpIllegalArgumentException;
import java.util.Collection;
import java.util.LinkedList;

public class EventRequest {
    public static final byte EVENT_SINGLE_STEP = 1;
    public static final byte EVENT_BREAKPOINT = 2;
    public static final byte EVENT_FRAME_POP = 3;
    public static final byte EVENT_EXCEPTION = 4;
    public static final byte EVENT_USER_DEFINED = 5;
    public static final byte EVENT_THREAD_START = 6;
    public static final byte EVENT_THREAD_END = 7;
    public static final byte EVENT_CLASS_PREPARE = 8;
    public static final byte EVENT_CLASS_UNLOAD = 9;
    public static final byte EVENT_CLASS_LOAD = 10;
    public static final byte EVENT_FIELD_ACCESS = 20;
    public static final byte EVENT_FIELD_MODIFY = 21;
    public static final byte EVENT_METHOD_ENTRY = 40;
    public static final byte EVENT_METHOD_EXIT = 41;
    public static final byte EVENT_VM_INIT = 90;
    public static final byte EVENT_VM_DEATH = 99;
    public static final byte SUSPEND_NONE = 0;
    public static final byte SUSPEND_THREAD = 1;
    public static final byte SUSPEND_ALL = 2;
    private static int _last_id = 0;
    private static Object _idLock = new Object();
    private LinkedList _filters = new LinkedList();
    private int _id;
    private byte _suspendPolicy;
    private byte _kind;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventRequest(byte by, byte by2) {
        Object object = _idLock;
        synchronized (object) {
            this._id = ++_last_id;
        }
        this._kind = by;
        this._suspendPolicy = by2;
    }

    public EventRequest(int n, byte by, byte by2) {
        this._kind = by;
        this._suspendPolicy = by2;
    }

    public void addFilter(IEventFilter iEventFilter) throws JdwpIllegalArgumentException {
        boolean bl = true;
        Class<? extends Object> clazz = iEventFilter.getClass();
        if (clazz == ClassExcludeFilter.class) {
            if (this._kind == 6 || this._kind == 7) {
                bl = false;
            }
        } else if (clazz == ClassMatchFilter.class) {
            if (this._kind == 6 || this._kind == 7) {
                bl = false;
            }
        } else if (clazz == ClassOnlyFilter.class) {
            if (this._kind == 9 || this._kind == 6 || this._kind == 7) {
                bl = false;
            }
        } else if (clazz != ConditionalFilter.class && clazz != CountFilter.class) {
            if (clazz == ExceptionOnlyFilter.class) {
                if (this._kind != 4) {
                    bl = false;
                }
            } else if (clazz == FieldOnlyFilter.class) {
                if (this._kind != 20 && this._kind != 21) {
                    bl = false;
                }
            } else if (clazz == InstanceOnlyFilter.class) {
                if (this._kind == 8 || this._kind == 9 || this._kind == 6 || this._kind == 7) {
                    bl = false;
                }
            } else if (clazz == LocationOnlyFilter.class) {
                if (this._kind != 2 && this._kind != 20 && this._kind != 21 && this._kind != 1 && this._kind != 4) {
                    bl = false;
                }
            } else if (clazz == StepFilter.class) {
                if (this._kind != 1) {
                    bl = false;
                }
            } else if (clazz == ThreadOnlyFilter.class && this._kind == 9) {
                bl = false;
            }
        }
        if (!bl) {
            String string = "cannot use " + iEventFilter.getClass().getName() + " with class unload events";
            throw new JdwpIllegalArgumentException(string);
        }
        this._filters.add(iEventFilter);
    }

    public Collection getFilters() {
        return this._filters;
    }

    public byte getSuspendPolicy() {
        return this._suspendPolicy;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public byte getEventKind() {
        return this._kind;
    }

    public boolean matches(Event event) {
        boolean bl = true;
        for (IEventFilter iEventFilter : this._filters) {
            if (iEventFilter.matches(event)) continue;
            bl = false;
        }
        return bl;
    }
}

