/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.debug;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.PreciseFilter;
import gnu.java.security.action.GetPropertyAction;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SystemLogger
extends Logger {
    public static final SystemLogger SYSTEM = new SystemLogger();

    public static SystemLogger getSystemLogger() {
        return SYSTEM;
    }

    private SystemLogger() {
        super("gnu.classpath", null);
    }

    public void logv(Level level, String string, Object ... objectArray) {
        this.log(level, string, objectArray);
    }

    static {
        SYSTEM.setFilter(PreciseFilter.GLOBAL);
        String string = AccessController.doPrivileged(new GetPropertyAction("gnu.classpath.debug.components"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                Component component = Component.forName(stringTokenizer.nextToken());
                if (component != null) {
                    PreciseFilter.GLOBAL.enable(component);
                }
                SYSTEM.log(Level.INFO, "enabled: {0}", component);
            }
        }
    }
}

