/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import gnu.classpath.ServiceProviderLoadingAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceFactory {
    private static final Logger LOGGER = Logger.getLogger("gnu.classpath");

    private ServiceFactory() {
    }

    public static <P> Iterator<P> lookupProviders(Class<P> clazz, ClassLoader classLoader) {
        return ServiceFactory.lookupProviders(clazz, classLoader, false);
    }

    public static <P> Iterator<P> lookupProviders(Class<P> clazz, ClassLoader classLoader, boolean bl) {
        Enumeration<URL> enumeration;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String string = "META-INF/services/" + clazz.getName();
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            ServiceFactory.log(Level.WARNING, "cannot access {0}", string, iOException);
            if (bl) {
                throw new ServiceConfigurationError("Failed to access + " + string, iOException);
            }
            List list2 = Collections.emptyList();
            return list2.iterator();
        }
        return new ServiceIterator<P>(clazz, enumeration, classLoader, bl, AccessController.getContext());
    }

    public static <P> Iterator<P> lookupProviders(Class<P> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ServiceFactory.lookupProviders(clazz, classLoader);
    }

    static void log(Level level, String string, Object object, Throwable throwable) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        if (object != null && object.getClass().isArray()) {
            logRecord.setParameters((Object[])object);
        } else {
            logRecord.setParameters(new Object[]{object});
        }
        logRecord.setThrown(throwable);
        logRecord.setSourceClassName(ServiceFactory.class.getName());
        logRecord.setSourceMethodName("lookupProviders");
        LOGGER.log(logRecord);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServiceIterator<P>
    implements Iterator<P> {
        private final Class<P> spi;
        private final Enumeration<URL> urls;
        private final ClassLoader loader;
        private final AccessControlContext securityContext;
        private BufferedReader reader;
        private URL currentURL;
        private P nextProvider;
        private boolean error;

        ServiceIterator(Class<P> clazz, Enumeration<URL> enumeration, ClassLoader classLoader, boolean bl, AccessControlContext accessControlContext) {
            this.spi = clazz;
            this.urls = enumeration;
            this.loader = classLoader;
            this.securityContext = accessControlContext;
            this.error = bl;
            this.nextProvider = this.loadNextServiceProvider();
        }

        @Override
        public P next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            P p = this.nextProvider;
            this.nextProvider = this.loadNextServiceProvider();
            return p;
        }

        @Override
        public boolean hasNext() {
            return this.nextProvider != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private P loadNextServiceProvider() {
            if (this.reader == null) {
                this.advanceReader();
            }
            while (true) {
                String string;
                block9: {
                    if (this.reader == null) {
                        return null;
                    }
                    try {
                        string = this.reader.readLine();
                    }
                    catch (IOException iOException) {
                        ServiceFactory.log(Level.WARNING, "IOException upon reading {0}", this.currentURL, iOException);
                        string = null;
                        if (!this.error) break block9;
                        throw new ServiceConfigurationError("Error reading " + this.currentURL, iOException);
                    }
                }
                if (string == null) {
                    this.advanceReader();
                    continue;
                }
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                try {
                    ServiceFactory.log(Level.FINE, "Loading service provider \"{0}\", specified by \"META-INF/services/{1}\" in {2}.", new Object[]{string, this.spi.getName(), this.currentURL}, null);
                    return AccessController.doPrivileged(new ServiceProviderLoadingAction<P>(this.spi, string, this.loader), this.securityContext);
                }
                catch (Exception exception) {
                    String string2 = "Cannot load service provider class \"{0}\", specified by \"META-INF/services/{1}\" in {2}";
                    if (exception instanceof PrivilegedActionException && exception.getCause() instanceof ClassCastException) {
                        string2 = "Service provider class \"{0}\" is not an instance of \"{1}\". Specified by \"META-INF/services/{1}\" in {2}.";
                    }
                    ServiceFactory.log(Level.WARNING, string2, new Object[]{string, this.spi.getName(), this.currentURL}, exception);
                    if (this.error) throw new ServiceConfigurationError("Cannot load service provider class " + string + " specified by \"META-INF/services/" + this.spi.getName() + "\" in " + this.currentURL, exception);
                    continue;
                }
                break;
            }
        }

        private void advanceReader() {
            do {
                if (this.reader != null) {
                    block7: {
                        try {
                            this.reader.close();
                            ServiceFactory.log(Level.FINE, "closed {0}", this.currentURL, null);
                        }
                        catch (Exception exception) {
                            ServiceFactory.log(Level.WARNING, "cannot close {0}", this.currentURL, exception);
                            if (!this.error) break block7;
                            throw new ServiceConfigurationError("Cannot close " + this.currentURL, exception);
                        }
                    }
                    this.reader = null;
                    this.currentURL = null;
                }
                if (!this.urls.hasMoreElements()) {
                    return;
                }
                this.currentURL = this.urls.nextElement();
                try {
                    this.reader = new BufferedReader(new InputStreamReader(this.currentURL.openStream(), "UTF-8"));
                    ServiceFactory.log(Level.FINE, "opened {0}", this.currentURL, null);
                }
                catch (Exception exception) {
                    ServiceFactory.log(Level.WARNING, "cannot open {0}", this.currentURL, exception);
                    if (!this.error) continue;
                    throw new ServiceConfigurationError("Cannot open " + this.currentURL, exception);
                }
            } while (this.reader == null);
        }
    }
}

