/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.NamingService.Binding_iterator_impl;
import gnu.CORBA.NamingService.Ext;
import gnu.CORBA.NamingService.NameValidator;
import gnu.CORBA.NamingService.NamingMap;
import gnu.CORBA.SafeForDirectCalls;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextOperations;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.CosNaming._NamingContextImplBase;

public class TransientContext
extends _NamingContextImplBase
implements NamingContext,
NamingContextOperations,
SafeForDirectCalls {
    private static final long serialVersionUID = 2L;
    protected final NamingMap named_contexts;
    protected final NamingMap named_objects;

    public TransientContext() {
        this(new NamingMap(), new NamingMap());
    }

    public TransientContext(NamingMap namingMap, NamingMap namingMap2) {
        this.named_contexts = namingMap;
        this.named_objects = namingMap2;
    }

    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nameComponentArray.length == 1) {
            this.named_objects.bind(nameComponentArray[0], object);
        } else {
            NamingContext namingContext = (NamingContext)this.named_contexts.get(nameComponentArray[0]);
            namingContext.bind(this.getSuffix(nameComponentArray), object);
        }
    }

    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nameComponentArray.length == 1) {
            this.named_contexts.bind(nameComponentArray[0], namingContext);
        } else {
            NamingContext namingContext2 = (NamingContext)this.named_contexts.get(nameComponentArray[0]);
            namingContext2.bind_context(this.getSuffix(nameComponentArray), namingContext);
        }
    }

    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (this.named_contexts.containsKey(nameComponentArray[0]) || this.named_objects.containsKey(nameComponentArray[0])) {
            throw new AlreadyBound();
        }
        NamingContext namingContext = this.new_context();
        this.bind_context(nameComponentArray, namingContext);
        return namingContext;
    }

    public void destroy() throws NotEmpty {
        if (this.named_contexts.size() > 0 || this.named_objects.size() > 0) {
            throw new NotEmpty();
        }
    }

    public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        int n2 = this.named_contexts.size() + this.named_objects.size();
        int n3 = n2;
        if (n3 > n) {
            n3 = n;
        }
        bindingListHolder.value = new Binding[n3];
        Iterator iterator = this.named_contexts.entries().iterator();
        Iterator iterator2 = this.named_objects.entries().iterator();
        for (int i = 0; i < n3; ++i) {
            if (iterator.hasNext()) {
                bindingListHolder.value[i] = this.mkBinding(iterator.next(), BindingType.ncontext);
                continue;
            }
            if (iterator2.hasNext()) {
                bindingListHolder.value[i] = this.mkBinding(iterator2.next(), BindingType.nobject);
                continue;
            }
            throw new InternalError();
        }
        Binding[] bindingArray = new Binding[n2 - n3];
        int n4 = 0;
        while (iterator.hasNext()) {
            bindingArray[n4++] = this.mkBinding(iterator.next(), BindingType.ncontext);
        }
        while (iterator2.hasNext()) {
            bindingArray[n4++] = this.mkBinding(iterator2.next(), BindingType.nobject);
        }
        Binding_iterator_impl binding_iterator_impl = new Binding_iterator_impl(bindingArray);
        this._orb().connect(binding_iterator_impl);
        bindingIteratorHolder.value = binding_iterator_impl;
    }

    public NamingContext new_context() {
        Ext ext = new Ext(new TransientContext());
        this._orb().connect(ext);
        return ext;
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        if (nameComponentArray.length == 1) {
            this.named_objects.rebind(nameComponentArray[0], object);
        } else {
            NamingContext namingContext = (NamingContext)this.named_contexts.get(nameComponentArray[0]);
            namingContext.rebind(this.getSuffix(nameComponentArray), object);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        if (nameComponentArray.length == 1) {
            this.named_contexts.rebind(nameComponentArray[0], namingContext);
        } else {
            NamingContext namingContext2 = (NamingContext)this.named_contexts.get(nameComponentArray[0]);
            namingContext2.rebind_context(this.getSuffix(nameComponentArray), namingContext);
        }
    }

    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NameValidator.check(nameComponentArray);
        if (nameComponentArray.length > 1) {
            return this.resolveSubContext(nameComponentArray);
        }
        Object object = this.named_objects.get(nameComponentArray[0]);
        if (object != null) {
            return object;
        }
        object = this.named_contexts.get(nameComponentArray[0]);
        if (object != null) {
            return object;
        }
        throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NameValidator.check(nameComponentArray);
        if (nameComponentArray.length == 1) {
            if (this.named_objects.containsKey(nameComponentArray[0])) {
                this.named_objects.remove(nameComponentArray[0]);
                return;
            } else {
                if (!this.named_contexts.containsKey(nameComponentArray[0])) throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
                this.named_contexts.remove(nameComponentArray[0]);
            }
            return;
        } else {
            NamingContext namingContext = (NamingContext)this.named_contexts.get(nameComponentArray[0]);
            if (namingContext == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            namingContext.unbind(this.getSuffix(nameComponentArray));
        }
    }

    private NameComponent[] getSuffix(NameComponent[] nameComponentArray) {
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray2.length);
        return nameComponentArray2;
    }

    private Binding mkBinding(java.lang.Object object, BindingType bindingType) {
        Map.Entry entry = (Map.Entry)object;
        Binding binding = new Binding();
        binding.binding_name = new NameComponent[]{(NameComponent)entry.getKey()};
        binding.binding_type = bindingType;
        return binding;
    }

    private Object resolveSubContext(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContext namingContext = (NamingContext)this.named_contexts.get(nameComponentArray[0]);
        if (namingContext == null) {
            throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
        }
        NameComponent[] nameComponentArray2 = this.getSuffix(nameComponentArray);
        return namingContext.resolve(nameComponentArray2);
    }
}

