/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;

public final class AnnotationInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6182022883658399397L;
    private final Class type;
    private final Map memberValues;

    public AnnotationInvocationHandler(Class clazz, Map map) {
        this.type = clazz;
        this.memberValues = map;
    }

    public static Annotation create(Class clazz, Map map) {
        for (Method method : clazz.getDeclaredMethods()) {
            String string = method.getName();
            if (map.containsKey(string)) continue;
            map.put(string, method.getDefaultValue());
        }
        AnnotationInvocationHandler annotationInvocationHandler = new AnnotationInvocationHandler(clazz, map);
        return (Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, annotationInvocationHandler);
    }

    public static boolean equals(Class clazz, Map map, Object object) {
        if (clazz.isInstance(object)) {
            try {
                Method[] methodArray = clazz.getDeclaredMethods();
                if (methodArray.length == map.size()) {
                    for (int i = 0; i < methodArray.length; ++i) {
                        String string = methodArray[i].getName();
                        Object object2 = methodArray[i].invoke(object, new Object[0]);
                        if (AnnotationInvocationHandler.deepEquals(map.get(string), object2)) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean deepEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }

    private static int deepHashCode(Object object) {
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof Object[]) {
            return Arrays.hashCode((Object[])object);
        }
        return object.hashCode();
    }

    public static int hashCode(Class clazz, Map map) {
        int n = 0;
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            n += AnnotationInvocationHandler.deepHashCode(v) ^ 127 * k.hashCode();
        }
        return n;
    }

    private static String deepToString(Object object) {
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof Object[]) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    public static String toString(Class clazz, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('@').append(clazz.getName()).append('(');
        String string = "";
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            stringBuffer.append(string).append(k).append('=').append(AnnotationInvocationHandler.deepToString(v));
            string = ", ";
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static Class getBoxedReturnType(Method method) {
        Class<?> clazz = method.getReturnType();
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    private Object arrayClone(Object object) {
        if (object instanceof boolean[]) {
            return ((boolean[])object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object instanceof char[]) {
            return ((char[])object).clone();
        }
        if (object instanceof short[]) {
            return ((short[])object).clone();
        }
        if (object instanceof int[]) {
            return ((int[])object).clone();
        }
        if (object instanceof float[]) {
            return ((float[])object).clone();
        }
        if (object instanceof long[]) {
            return ((long[])object).clone();
        }
        if (object instanceof double[]) {
            return ((double[])object).clone();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).clone();
        }
        return object;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName().intern();
        if (objectArray == null || objectArray.length == 0) {
            if (string == "toString") {
                return AnnotationInvocationHandler.toString(this.type, this.memberValues);
            }
            if (string == "hashCode") {
                return AnnotationInvocationHandler.hashCode(this.type, this.memberValues);
            }
            if (string == "annotationType") {
                return this.type;
            }
            Object object2 = this.memberValues.get(string);
            if (object2 == null) {
                throw new IncompleteAnnotationException(this.type, string);
            }
            if (!AnnotationInvocationHandler.getBoxedReturnType(method).isInstance(object2)) {
                throw new AnnotationTypeMismatchException(method, object2.getClass().getName());
            }
            if (object2.getClass().isArray()) {
                object2 = this.arrayClone(object2);
            }
            return object2;
        }
        if (objectArray.length == 1 && string == "equals") {
            return AnnotationInvocationHandler.equals(this.type, this.memberValues, objectArray[0]);
        }
        throw new InternalError("Invalid annotation proxy");
    }
}

