/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import gnu.xml.dom.DomDocumentBuilderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;

public abstract class DocumentBuilderFactory {
    private boolean namespaceAware;
    private boolean validating;
    private boolean ignoringElementContentWhitespace;
    private boolean expandEntityReferences = true;
    private boolean ignoringComments;
    private boolean coalescing;
    private Schema schema;
    private boolean xIncludeAware;

    protected DocumentBuilderFactory() {
    }

    public static DocumentBuilderFactory newInstance() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DocumentBuilderFactory.class.getClassLoader();
        }
        String string = null;
        int n = 0;
        do {
            if ((string = DocumentBuilderFactory.getFactoryClassName(classLoader, n++)) == null) continue;
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                return (DocumentBuilderFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string);
            }
        } while (string == null && n < 3);
        return new DomDocumentBuilderFactory();
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        switch (n) {
            case 0: {
                return System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty("javax.xml.parsers.DocumentBuilderFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : DocumentBuilderFactory.class.getResourceAsStream(string);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string2 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string2;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringElementContentWhitespace = bl;
    }

    public void setExpandEntityReferences(boolean bl) {
        this.expandEntityReferences = bl;
    }

    public void setIgnoringComments(boolean bl) {
        this.ignoringComments = bl;
    }

    public void setCoalescing(boolean bl) {
        this.coalescing = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean bl) {
        this.xIncludeAware = bl;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException;
}

