/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.javax.swing.tree.GnuPath;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    private static final Rectangle RECT_CACHE = new Rectangle();
    Set<Object> expanded = new HashSet<Object>();
    Hashtable<Object, NodeRecord> nodes = new Hashtable();
    ArrayList<Object> row2node = new ArrayList();
    boolean dirty;
    int totalHeight;
    int maximalWidth;

    @Override
    public int getRowCount() {
        if (this.dirty) {
            this.update();
        }
        return this.row2node.size();
    }

    private final void update() {
        this.nodes.clear();
        this.row2node.clear();
        this.maximalWidth = 0;
        this.totalHeight = 0;
        if (this.treeModel == null) {
            return;
        }
        Object object = this.treeModel.getRoot();
        this.countRows(object, null, 0, 0);
        this.dirty = false;
    }

    private final int countRows(Object object, Object object2, int n, int n2) {
        boolean bl = object != this.treeModel.getRoot() || this.rootVisible;
        int n3 = this.row2node.size();
        if (bl) {
            this.row2node.add(object);
        }
        NodeRecord nodeRecord = new NodeRecord(n3, n, object, object2);
        AbstractLayoutCache.NodeDimensions nodeDimensions = this.getNodeDimensions();
        Rectangle rectangle = RECT_CACHE;
        if (nodeDimensions != null) {
            rectangle = nodeDimensions.getNodeDimensions(object, n3, n, nodeRecord.isExpanded, rectangle);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        rectangle.y = !bl ? -1 : Math.max(0, n2);
        if (this.isFixedRowHeight()) {
            rectangle.height = this.getRowHeight();
        }
        nodeRecord.bounds.setBounds(rectangle);
        this.nodes.put(object, nodeRecord);
        if (bl) {
            n2 += rectangle.height;
        }
        int n4 = this.treeModel.getChildCount(object);
        int n5 = n + 1;
        if (this.expanded.contains(object)) {
            for (int i = 0; i < n4; ++i) {
                Object object3 = this.treeModel.getChild(object, i);
                n2 = this.countRows(object3, object, n5, n2);
            }
        }
        return n2;
    }

    @Override
    public void invalidatePathBounds(TreePath treePath) {
        NodeRecord nodeRecord = this.nodes.get(treePath.getLastPathComponent());
        if (nodeRecord != null) {
            nodeRecord.bounds = null;
        }
    }

    @Override
    public void invalidateSizes() {
        this.dirty = true;
    }

    @Override
    public void setExpandedState(TreePath treePath, boolean bl) {
        if (bl) {
            int n = treePath.getPathCount();
            for (int i = 0; i < n; ++i) {
                this.expanded.add(treePath.getPathComponent(i));
            }
        } else {
            this.expanded.remove(treePath.getLastPathComponent());
        }
        this.dirty = true;
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        return this.expanded.contains(treePath.getLastPathComponent());
    }

    @Override
    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        if (treePath == null) {
            return null;
        }
        if (this.dirty) {
            this.update();
        }
        Object object = treePath.getLastPathComponent();
        Rectangle rectangle2 = null;
        NodeRecord nodeRecord = this.nodes.get(object);
        if (nodeRecord != null) {
            rectangle2 = rectangle;
            if (rectangle2 == null) {
                rectangle2 = new Rectangle(nodeRecord.bounds);
            } else {
                rectangle2.setBounds(nodeRecord.bounds);
            }
        }
        return rectangle2;
    }

    @Override
    public TreePath getPathForRow(int n) {
        if (this.dirty) {
            this.update();
        }
        TreePath treePath = null;
        Enumeration<NodeRecord> enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements() && treePath == null) {
            NodeRecord nodeRecord = enumeration.nextElement();
            if (nodeRecord.row != n) continue;
            treePath = nodeRecord.getPath();
        }
        return treePath;
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        NodeRecord nodeRecord;
        if (treePath == null) {
            return -1;
        }
        if (this.dirty) {
            this.update();
        }
        if ((nodeRecord = this.nodes.get(treePath.getLastPathComponent())) == null) {
            return -1;
        }
        return nodeRecord.row;
    }

    @Override
    public TreePath getPathClosestTo(int n, int n2) {
        if (this.dirty) {
            this.update();
        }
        NodeRecord nodeRecord = null;
        Enumeration<NodeRecord> enumeration = this.nodes.elements();
        int n3 = Integer.MAX_VALUE;
        while (enumeration.hasMoreElements() && n3 > 0) {
            NodeRecord nodeRecord2 = enumeration.nextElement();
            if (nodeRecord == null) {
                nodeRecord = nodeRecord2;
                n3 = this.distance(nodeRecord2.getBounds(), n, n2);
                continue;
            }
            int n4 = this.distance(nodeRecord2.getBounds(), n, n2);
            if (n4 >= n3) continue;
            nodeRecord = nodeRecord2;
            n3 = n4;
        }
        if (nodeRecord == null) {
            return null;
        }
        return nodeRecord.getPath();
    }

    int distance(Rectangle rectangle, int n, int n2) {
        if (n2 < rectangle.y) {
            return rectangle.y - n2;
        }
        if (n2 > rectangle.y + rectangle.height - 1) {
            return n2 - (rectangle.y + rectangle.height - 1);
        }
        return 0;
    }

    @Override
    public int getVisibleChildCount(TreePath treePath) {
        if (!this.isExpanded(treePath) || this.treeModel == null) {
            return 0;
        }
        return this.treeModel.getChildCount(treePath.getLastPathComponent());
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath treePath) {
        if (this.dirty) {
            this.update();
        }
        Vector<TreePath> vector = new Vector<TreePath>(treePath.getPathCount());
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            Object object = treePath.getPathComponent(i);
            NodeRecord nodeRecord = this.nodes.get(object);
            if (nodeRecord == null || nodeRecord.row < 0) continue;
            vector.add((TreePath)object);
        }
        return vector.elements();
    }

    @Override
    public boolean getExpandedState(TreePath treePath) {
        return this.expanded.contains(treePath.getLastPathComponent());
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    @Override
    public void setModel(TreeModel treeModel) {
        this.treeModel = treeModel;
        this.dirty = true;
        if (this.treeModel != null) {
            this.expanded.add(this.treeModel.getRoot());
        }
    }

    @Override
    public void setRootVisible(boolean bl) {
        this.rootVisible = bl;
        this.dirty = true;
    }

    @Override
    public int getPreferredHeight() {
        if (this.dirty) {
            this.update();
        }
        int n = 0;
        int n2 = this.getRowCount();
        if (n2 > 0) {
            NodeRecord nodeRecord = this.nodes.get(this.row2node.get(n2 - 1));
            n = nodeRecord.bounds.y + nodeRecord.bounds.height;
        }
        return n;
    }

    @Override
    public int getPreferredWidth(Rectangle rectangle) {
        if (this.dirty) {
            this.update();
        }
        this.maximalWidth = 0;
        Enumeration<NodeRecord> enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            NodeRecord nodeRecord = enumeration.nextElement();
            if (nodeRecord == null) continue;
            Rectangle rectangle2 = nodeRecord.getBounds();
            int n = rectangle2.x + rectangle2.width;
            if (n <= this.maximalWidth) continue;
            this.maximalWidth = n;
        }
        return this.maximalWidth;
    }

    @Override
    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions nodeDimensions) {
        super.setNodeDimensions(nodeDimensions);
        this.dirty = true;
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        this.dirty = true;
    }

    class NodeRecord {
        final int row;
        final int depth;
        final Object parent;
        final Object node;
        final boolean isExpanded;
        Rectangle bounds;
        private TreePath path;

        NodeRecord(int n, int n2, Object object, Object object2) {
            this.row = n;
            this.depth = n2;
            this.parent = object2;
            this.node = object;
            this.isExpanded = VariableHeightLayoutCache.this.expanded.contains(object);
            this.bounds = new Rectangle(0, -1, 0, 0);
        }

        TreePath getPath() {
            if (this.path == null) {
                int n;
                int n2;
                boolean bl = false;
                if (this.parent != null && (n2 = VariableHeightLayoutCache.this.treeModel.getChildCount(this.parent)) > 0 && (n = VariableHeightLayoutCache.this.treeModel.getIndexOfChild(this.parent, this.node)) == n2 - 1) {
                    bl = true;
                }
                LinkedList<Object> linkedList = new LinkedList<Object>();
                NodeRecord nodeRecord = this;
                while (nodeRecord != null) {
                    linkedList.addFirst(nodeRecord.node);
                    if (nodeRecord.parent != null) {
                        Object object = nodeRecord.parent;
                        nodeRecord = VariableHeightLayoutCache.this.nodes.get(object);
                        if (nodeRecord != null) continue;
                        linkedList.addFirst(object);
                        continue;
                    }
                    nodeRecord = null;
                }
                this.path = new GnuPath(linkedList.toArray(), bl);
            }
            return this.path;
        }

        Rectangle getBounds() {
            return this.bounds;
        }
    }
}

