/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.java.lang.CPStringBuilder;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    static final long serialVersionUID = 3288129636638950196L;
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList;
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel;
    protected int selectionMode;
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow = -1;
    private transient HashSet<TreePath> selectedPaths;
    private transient HashSet<TreePath> tmpPaths;

    public DefaultTreeSelectionModel() {
        this.setSelectionMode(4);
        this.listSelectionModel = new DefaultListSelectionModel();
        this.listenerList = new EventListenerList();
        this.leadIndex = -1;
        this.tmpPaths = new HashSet();
        this.selectedPaths = new HashSet();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)super.clone();
        defaultTreeSelectionModel.changeSupport = null;
        defaultTreeSelectionModel.selection = (TreePath[])this.selection.clone();
        defaultTreeSelectionModel.listenerList = new EventListenerList();
        defaultTreeSelectionModel.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        defaultTreeSelectionModel.selectedPaths = new HashSet();
        defaultTreeSelectionModel.tmpPaths = new HashSet();
        return defaultTreeSelectionModel;
    }

    public String toString() {
        if (this.isSelectionEmpty()) {
            return "[selection empty]";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("selected rows: [");
        for (int i = 0; i < this.selection.length; ++i) {
            cPStringBuilder.append(this.getRow(this.selection[i]));
            cPStringBuilder.append(' ');
        }
        cPStringBuilder.append(", lead " + this.getLeadSelectionRow());
        return cPStringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
        this.resetRowSelection();
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (n2 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, n2, this.selectionMode);
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        TreePath[] treePathArray = null;
        if (treePath != null) {
            treePathArray = new TreePath[]{treePath};
        }
        this.setSelectionPaths(treePathArray);
    }

    int getRow(TreePath treePath) {
        RowMapper rowMapper = this.getRowMapper();
        if (rowMapper instanceof AbstractLayoutCache) {
            AbstractLayoutCache abstractLayoutCache = (AbstractLayoutCache)rowMapper;
            return abstractLayoutCache.getRowForPath(treePath);
        }
        if (rowMapper != null) {
            int[] nArray = rowMapper.getRowsForPaths(new TreePath[]{treePath});
            if (nArray.length == 0) {
                return -1;
            }
            return nArray[0];
        }
        return -1;
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        int n = 0;
        if (this.selection != null) {
            n = this.selection.length;
        }
        int n2 = 0;
        if (treePathArray != null) {
            n2 = treePathArray.length;
        }
        if (n2 > 0 || n > 0) {
            if (this.selectionMode == 1 && n2 > 1 || this.selectionMode == 2 && n2 > 0 && !this.arePathsContiguous(treePathArray)) {
                treePathArray = new TreePath[]{treePathArray[0]};
                n2 = 1;
            }
            Vector<PathPlaceHolder> vector = null;
            this.tmpPaths.clear();
            int n3 = 0;
            TreePath treePath = this.leadPath;
            for (int i = 0; i < n2; ++i) {
                if (treePathArray[i] == null || this.tmpPaths.contains(treePathArray[i])) continue;
                ++n3;
                this.tmpPaths.add(treePathArray[i]);
                if (!this.selectedPaths.contains(treePathArray[i])) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(new PathPlaceHolder(treePathArray[i], true));
                }
                this.leadPath = treePathArray[i];
            }
            TreePath[] treePathArray2 = null;
            if (n3 != 0) {
                if (n3 != n2) {
                    treePathArray2 = new TreePath[n3];
                    Iterator<TreePath> iterator = this.tmpPaths.iterator();
                    n3 = 0;
                    int n4 = 0;
                    while (iterator.hasNext()) {
                        treePathArray2[n4] = iterator.next();
                        ++n4;
                    }
                } else {
                    treePathArray2 = new TreePath[treePathArray.length];
                    System.arraycopy(treePathArray, 0, treePathArray2, 0, treePathArray.length);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (this.selection[i] == null || this.tmpPaths.contains(this.selection[i])) continue;
                if (vector == null) {
                    vector = new Vector<PathPlaceHolder>();
                }
                vector.add(new PathPlaceHolder(this.selection[i], false));
            }
            this.selection = treePathArray2;
            HashSet<TreePath> hashSet = this.selectedPaths;
            this.selectedPaths = this.tmpPaths;
            this.tmpPaths = hashSet;
            this.tmpPaths.clear();
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (vector != null && vector.size() > 0) {
                this.notifyPathChange(vector, treePath);
            }
        }
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.addSelectionPaths(treePathArray);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        int n;
        int n2 = n = treePathArray != null ? treePathArray.length : 0;
        if (n > 0) {
            if (this.selectionMode == 1) {
                this.setSelectionPaths(treePathArray);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(treePathArray)) {
                if (this.arePathsContiguous(treePathArray)) {
                    this.setSelectionPaths(treePathArray);
                } else {
                    this.setSelectionPaths(new TreePath[]{treePathArray[0]});
                }
            } else {
                int n3;
                Vector<PathPlaceHolder> vector = null;
                this.tmpPaths.clear();
                int n4 = 0;
                TreePath treePath = this.leadPath;
                int n5 = 0;
                if (this.selection != null) {
                    n5 = this.selection.length;
                }
                for (n3 = 0; n3 < n; ++n3) {
                    if (treePathArray[n3] == null) continue;
                    if (!this.selectedPaths.contains(treePathArray[n3])) {
                        ++n4;
                        if (vector == null) {
                            vector = new Vector<PathPlaceHolder>();
                        }
                        vector.add(new PathPlaceHolder(treePathArray[n3], true));
                        this.selectedPaths.add(treePathArray[n3]);
                        this.tmpPaths.add(treePathArray[n3]);
                    }
                    this.leadPath = treePathArray[n3];
                }
                if (n4 > 0) {
                    TreePath[] treePathArray2 = new TreePath[n5 + n4];
                    if (n5 > 0) {
                        System.arraycopy(this.selection, 0, treePathArray2, 0, n5);
                    }
                    if (n4 != treePathArray.length) {
                        Iterator<TreePath> iterator = this.tmpPaths.iterator();
                        n3 = n5;
                        while (iterator.hasNext()) {
                            treePathArray2[n3] = iterator.next();
                            ++n3;
                        }
                    } else {
                        System.arraycopy(treePathArray, 0, treePathArray2, n5, n4);
                    }
                    this.selection = treePathArray2;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    if (vector != null && vector.size() > 0) {
                        this.notifyPathChange(vector, treePath);
                    }
                } else {
                    this.leadPath = treePath;
                }
                this.tmpPaths.clear();
            }
        }
    }

    @Override
    public void removeSelectionPath(TreePath treePath) {
        if (treePath != null) {
            this.removeSelectionPaths(new TreePath[]{treePath});
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null && this.selection != null && treePathArray.length > 0) {
            if (!this.canPathsBeRemoved(treePathArray)) {
                this.clearSelection();
            } else {
                int n;
                Vector<PathPlaceHolder> vector = null;
                for (n = treePathArray.length - 1; n >= 0; --n) {
                    if (treePathArray[n] == null || !this.selectedPaths.contains(treePathArray[n])) continue;
                    if (vector == null) {
                        vector = new Vector<PathPlaceHolder>();
                    }
                    this.selectedPaths.remove(treePathArray[n]);
                    vector.add(new PathPlaceHolder(treePathArray[n], false));
                }
                if (vector != null) {
                    n = vector.size();
                    TreePath treePath = this.leadPath;
                    if (n == this.selection.length) {
                        this.selection = null;
                    } else {
                        this.selection = new TreePath[this.selection.length - n];
                        Iterator<TreePath> iterator = this.selectedPaths.iterator();
                        int n2 = 0;
                        while (iterator.hasNext()) {
                            this.selection[n2] = iterator.next();
                            ++n2;
                        }
                    }
                    this.leadPath = this.leadPath != null && !this.selectedPaths.contains(this.leadPath) ? (this.selection != null ? this.selection[this.selection.length - 1] : null) : (this.selection != null ? this.selection[this.selection.length - 1] : null);
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                }
            }
        }
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.selection == null || this.selection.length == 0) {
            return null;
        }
        return this.selection[0];
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    @Override
    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    @Override
    public boolean isPathSelected(TreePath treePath) {
        if (this.selection == null) {
            return false;
        }
        for (int i = 0; i < this.selection.length; ++i) {
            if (!this.selection[i].equals(treePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection == null || this.selection.length == 0;
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            int n = this.selection.length;
            boolean[] blArray = new boolean[n];
            Arrays.fill(blArray, false);
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, this.selection, blArray, this.leadPath, null);
            this.leadPath = null;
            this.leadIndex = 0;
            this.leadRow = 0;
            this.selectedPaths.clear();
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(TreeSelectionListener.class, treeSelectionListener);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(TreeSelectionListener.class, treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.getListeners(TreeSelectionListener.class);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionListener[] treeSelectionListenerArray = this.getTreeSelectionListeners();
        for (int i = 0; i < treeSelectionListenerArray.length; ++i) {
            treeSelectionListenerArray[i].valueChanged(treeSelectionEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public int[] getSelectionRows() {
        int[] nArray = null;
        if (this.rowMapper != null && this.selection != null && (nArray = this.rowMapper.getRowsForPaths(this.selection)) != null) {
            int n = 0;
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] != -1) continue;
                ++n;
            }
            if (n > 0) {
                if (n == nArray.length) {
                    nArray = null;
                } else {
                    int[] nArray2 = new int[nArray.length - n];
                    int n2 = 0;
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        if (nArray[i] == -1) continue;
                        nArray2[n2] = nArray[i];
                        ++n2;
                    }
                    nArray = nArray2;
                }
            }
        }
        return nArray;
    }

    @Override
    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isRowSelected(int n) {
        return this.listSelectionModel.isSelectedIndex(n);
    }

    @Override
    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            TreePath[] treePathArray;
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n == -1) continue;
                this.listSelectionModel.addSelectionInterval(n, n);
            }
            this.leadRow = this.leadIndex != -1 && nArray != null ? nArray[this.leadIndex] : (this.leadPath != null ? ((nArray = this.rowMapper.getRowsForPaths(treePathArray = new TreePath[]{this.leadPath})) != null ? nArray[0] : -1) : -1);
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    @Override
    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        PropertyChangeListener[] propertyChangeListenerArray = null;
        propertyChangeListenerArray = this.changeSupport != null ? this.changeSupport.getPropertyChangeListeners() : new PropertyChangeListener[]{};
        return propertyChangeListenerArray;
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            int n = this.listSelectionModel.getMinSelectionIndex();
            if (n != -1) {
                int n2 = this.listSelectionModel.getMaxSelectionIndex();
                for (int i = n; i <= n2; ++i) {
                    if (this.listSelectionModel.isSelectedIndex(i)) continue;
                    if (i == n) {
                        this.clearSelection();
                        continue;
                    }
                    TreePath[] treePathArray = new TreePath[i - n];
                    int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
                    for (int j = 0; j < nArray.length; ++j) {
                        if (nArray[j] >= i) continue;
                        treePathArray[nArray[j] - n] = this.selection[j];
                    }
                    this.setSelectionPaths(treePathArray);
                    break;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        int n;
        if (this.rowMapper == null || treePathArray.length < 2) {
            return true;
        }
        int n2 = treePathArray.length;
        TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
        int n3 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        BitSet bitSet = new BitSet();
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (treePathArray[n] == null) continue;
            treePathArray2[0] = treePathArray[n];
            int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
            if (nArray == null) {
                return false;
            }
            int n5 = nArray[0];
            if (n5 == -1 || n5 < n3 - n2 || n5 > n3 + n2) {
                return false;
            }
            n3 = Math.min(n3, n5);
            if (bitSet.get(n5)) continue;
            bitSet.set(n5);
            ++n4;
        }
        n = n4 + n3;
        for (int i = n3; i < n; ++i) {
            if (bitSet.get(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        int n;
        if (treePathArray == null || treePathArray.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int n2 = this.listSelectionModel.getMinSelectionIndex();
        int n3 = this.listSelectionModel.getMaxSelectionIndex();
        TreePath[] treePathArray2 = new TreePath[1];
        if (n2 != -1) {
            for (n = n2; n <= n3; ++n) {
                bitSet.set(n);
            }
        } else {
            treePathArray2[0] = treePathArray[0];
            n3 = n2 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        }
        for (n = treePathArray.length - 1; n >= 0; --n) {
            if (treePathArray[n] == null) continue;
            treePathArray2[0] = treePathArray[n];
            int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
            if (nArray == null) {
                return false;
            }
            int n4 = nArray[0];
            if (n4 == -1) {
                return false;
            }
            n2 = Math.min(n2, n4);
            n3 = Math.max(n3, n4);
            bitSet.set(n4);
        }
        for (n = n2; n <= n3; ++n) {
            if (bitSet.get(n)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        int n;
        if (this.rowMapper == null || this.isSelectionEmpty() || this.selectionMode == 4) {
            return true;
        }
        HashSet<TreePath> hashSet = new HashSet<TreePath>();
        for (n = 0; n < this.selection.length; ++n) {
            hashSet.add(this.selection[n]);
        }
        for (n = 0; n < treePathArray.length; ++n) {
            hashSet.remove(treePathArray[n]);
        }
        TreePath[] treePathArray2 = new TreePath[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        for (int i = 0; i < treePathArray2.length; ++i) {
            treePathArray2[i] = (TreePath)iterator.next();
        }
        return this.arePathsContiguous(treePathArray2);
    }

    protected void notifyPathChange(Vector<PathPlaceHolder> vector, TreePath treePath) {
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        TreePath[] treePathArray = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            PathPlaceHolder pathPlaceHolder = vector.get(i);
            blArray[i] = pathPlaceHolder.isNew;
            treePathArray[i] = pathPlaceHolder.path;
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
        this.fireValueChanged(treeSelectionEvent);
    }

    protected void updateLeadIndex() {
        this.leadIndex = -1;
        if (this.leadPath != null) {
            this.leadRow = -1;
            if (this.selection == null) {
                this.leadPath = null;
            } else {
                for (int i = this.selection.length - 1; i >= 0 && this.leadIndex == -1; --i) {
                    if (this.selection[i] != this.leadPath) continue;
                    this.leadIndex = i;
                }
            }
        }
    }

    protected void insureUniqueness() {
    }

    private static class PathPlaceHolder {
        TreePath path;
        boolean isNew;

        PathPlaceHolder(TreePath treePath, boolean bl) {
            this.path = treePath;
            this.isNew = bl;
        }
    }
}

