/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public DefaultTreeCellRenderer() {
        this.setLeafIcon(this.getDefaultLeafIcon());
        this.setOpenIcon(this.getDefaultOpenIcon());
        this.setClosedIcon(this.getDefaultClosedIcon());
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font != null && font instanceof UIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setBackground(Color color) {
        if (color != null && color instanceof UIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl3) {
            this.setIcon(this.getLeafIcon());
        } else if (bl2) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.setText(object.toString());
        this.selected = bl;
        this.hasFocus = bl4;
        this.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setVerticalAlignment(0);
        this.setEnabled(true);
        super.setFont(UIManager.getFont("Tree.font"));
        if (bl) {
            super.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
            if (bl4) {
                this.setBorderSelectionColor(UIManager.getLookAndFeelDefaults().getColor("Tree.selectionBorderColor"));
            } else {
                this.setBorderSelectionColor(null);
            }
        } else {
            super.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
            this.setBorderSelectionColor(null);
        }
        return this;
    }

    public Font getFont() {
        return super.getFont();
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n = -1;
        if (color != null) {
            n = this.getXOffset();
            graphics.setColor(color);
            graphics.fillRect(n, 0, this.getWidth() - n, this.getHeight());
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.getXOffset();
            }
            this.paintFocus(graphics, n, 0, this.getWidth() - n, this.getHeight());
        }
        super.paint(graphics);
    }

    private void paintFocus(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.getBorderSelectionColor();
        if (color != null) {
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    private int getXOffset() {
        Icon icon = this.getIcon();
        int n = 0;
        if (icon != null && this.getText() != null) {
            n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 3;
        return dimension;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

