/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    private EventListenerList listenerList = new EventListenerList();
    protected TreeCellEditor realEditor;
    protected DefaultTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this(jTree, defaultTreeCellRenderer, null);
    }

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        this.renderer = defaultTreeCellRenderer;
        this.realEditor = treeCellEditor;
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setTree(jTree);
        Color color = UIManager.getColor("Tree.editorBorderSelectionColor");
        this.setBorderSelectionColor(color);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font != null ? font : this.renderer.getFont();
    }

    public Font getFont() {
        return this.font;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setTree(jTree);
        this.lastRow = n;
        this.determineOffset(jTree, object, bl, bl2, bl3, n);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = jTree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        boolean bl2 = false;
        if (eventObject != null && eventObject.getSource() instanceof JTree) {
            this.setTree((JTree)eventObject.getSource());
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                boolean bl3 = bl2 = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
                if (treePath != null) {
                    this.lastRow = this.tree.getRowForPath(treePath);
                    Object object = treePath.getLastPathComponent();
                    boolean bl4 = this.tree.isRowSelected(this.lastRow);
                    boolean bl5 = this.tree.isExpanded(treePath);
                    TreeModel treeModel = this.tree.getModel();
                    boolean bl6 = treeModel.isLeaf(object);
                    this.determineOffset(this.tree, object, bl4, bl5, bl6, this.lastRow);
                }
            }
        }
        if (!this.realEditor.isCellEditable(eventObject)) {
            bl = false;
        } else if (this.canEditImmediately(eventObject)) {
            bl = true;
        } else if (bl2 && this.shouldStartEditingTimer(eventObject)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (bl) {
            this.prepareForEditing();
        }
        return bl;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        boolean bl = false;
        if (this.realEditor.stopCellEditing()) {
            this.finish();
            bl = true;
        }
        return bl;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        this.finish();
    }

    private void finish() {
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(JTree jTree) {
        if (this.tree != jTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = jTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        boolean bl = false;
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            bl = SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return bl;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        return eventObject == null || !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() > 2 && this.inHitRegion(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
    }

    protected boolean inHitRegion(int n, int n2) {
        Rectangle rectangle = this.tree.getPathBounds(this.lastPath);
        return rectangle.contains(n, n2);
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.renderer != null) {
            this.editingIcon = bl3 ? this.renderer.getLeafIcon() : (bl2 ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.add(this.editingComponent);
        }
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultTextField defaultTextField = new DefaultTextField(border);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(defaultTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.realEditor = defaultCellEditor;
        return defaultCellEditor;
    }

    public class DefaultTextField
    extends JTextField {
        static final long serialVersionUID = -6629304544265300143L;
        protected Border border;

        public DefaultTextField(Border border) {
            this.border = border;
        }

        public Font getFont() {
            Font font = super.getFont();
            if (font == null) {
                Container container = this.getParent();
                if (container != null) {
                    return container.getFont();
                }
                return null;
            }
            return font;
        }

        public Border getBorder() {
            return this.border;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (DefaultTreeCellEditor.this.renderer != null && DefaultTreeCellEditor.this.getFont() == null) {
                dimension.height = DefaultTreeCellEditor.this.renderer.getPreferredSize().height;
            }
            return DefaultTreeCellEditor.this.renderer.getPreferredSize();
        }
    }

    public class EditorContainer
    extends Container {
        static final long serialVersionUID = 6470339600449699810L;

        public EditorContainer() {
            this.setLayout(null);
        }

        public void EditorContainer() {
        }

        public void paint(Graphics graphics) {
            Color color;
            if (DefaultTreeCellEditor.this.editingIcon != null) {
                int n = Math.max(0, (this.getHeight() - DefaultTreeCellEditor.this.editingIcon.getIconHeight()) / 2);
                DefaultTreeCellEditor.this.editingIcon.paintIcon(this, graphics, 0, n);
            }
            if ((color = DefaultTreeCellEditor.this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(graphics);
        }

        public void doLayout() {
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                DefaultTreeCellEditor.this.editingComponent.setBounds(DefaultTreeCellEditor.this.offset, 0, this.getWidth() - DefaultTreeCellEditor.this.offset, this.getHeight());
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension;
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                dimension = DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                dimension.width += DefaultTreeCellEditor.this.offset + 5;
                if (DefaultTreeCellEditor.this.renderer != null) {
                    Dimension dimension2 = DefaultTreeCellEditor.this.renderer.getPreferredSize();
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
                if (DefaultTreeCellEditor.this.editingIcon != null) {
                    dimension.height = Math.max(dimension.height, DefaultTreeCellEditor.this.editingIcon.getIconHeight());
                }
                dimension.width = Math.max(100, dimension.width);
            } else {
                dimension = new Dimension(0, 0);
            }
            return dimension;
        }
    }
}

