/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;

public class DTD
implements DTDConstants {
    public static final int FILE_VERSION = 1;
    static Hashtable<String, DTD> dtdHash = new Hashtable();
    public Element applet;
    public Element base;
    public Element body;
    public Element head;
    public Element html;
    public Element isindex;
    public Element meta;
    public Element p;
    public Element param;
    public Element pcdata;
    public Element title;
    public Hashtable<String, Element> elementHash = new Hashtable();
    public Hashtable<Object, Entity> entityHash = new Hashtable();
    public String name;
    public Vector<Element> elements = new Vector();

    protected DTD(String string) {
        this.name = string;
    }

    public static DTD getDTD(String string) throws IOException {
        DTD dTD = dtdHash.get(string);
        if (dTD == null) {
            dTD = new DTD(string);
            dtdHash.put(dTD.name, dTD);
        }
        return dTD;
    }

    public Element getElement(String string) {
        return this.newElement(string);
    }

    public Element getElement(int n) {
        return this.elements.get(n);
    }

    public Entity getEntity(int n) {
        String string = Entity.mapper.get(n);
        if (string != null) {
            return this.entityHash.get(string);
        }
        return null;
    }

    public Entity getEntity(String string) {
        return this.entityHash.get(string);
    }

    public String getName() {
        return this.name;
    }

    public Entity defEntity(String string, int n, int n2) {
        Entity entity = this.newEntity(string, n);
        entity.data = new char[]{(char)n2};
        return entity;
    }

    public void defineAttributes(String string, AttributeList attributeList) {
        Element element = this.elementHash.get(string.toLowerCase());
        if (element == null) {
            element = this.newElement(string);
        }
        element.atts = attributeList;
    }

    public Element defineElement(String string, int n, boolean bl, boolean bl2, ContentModel contentModel, BitSet bitSet, BitSet bitSet2, AttributeList attributeList) {
        Element element = this.newElement(string);
        element.type = n;
        element.oStart = bl;
        element.oEnd = bl2;
        element.content = contentModel;
        element.exclusions = bitSet;
        element.inclusions = bitSet2;
        element.atts = attributeList;
        return element;
    }

    public Entity defineEntity(String string, int n, char[] cArray) {
        Entity entity = this.newEntity(string, n);
        entity.data = cArray;
        return entity;
    }

    public static void putDTDHash(String string, DTD dTD) {
        dtdHash.put(string, dTD);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
        try {
            while (true) {
                DTDConstants dTDConstants;
                Object object;
                if ((object = objectInputStream.readObject()) instanceof Element) {
                    dTDConstants = (Element)object;
                    this.elementHash.put(dTDConstants.name.toLowerCase(), (Element)dTDConstants);
                    this.assignField((Element)dTDConstants);
                    continue;
                }
                if (!(object instanceof Entity)) continue;
                dTDConstants = (Entity)object;
                this.entityHash.put(((Entity)dTDConstants).name, (Entity)dTDConstants);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public String toString() {
        return this.name;
    }

    protected AttributeList defAttributeList(String string, int n, int n2, String string2, String string3, AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList(string);
        attributeList2.modifier = n2;
        attributeList2.value = string2;
        attributeList2.next = attributeList;
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " \t|");
            Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            attributeList2.values = vector;
        }
        return attributeList2;
    }

    protected ContentModel defContentModel(int n, Object object, ContentModel contentModel) {
        ContentModel contentModel2 = new ContentModel();
        contentModel2.type = n;
        contentModel2.next = contentModel;
        contentModel2.content = object;
        return contentModel2;
    }

    protected Element defElement(String string, int n, boolean bl, boolean bl2, ContentModel contentModel, String[] stringArray, String[] stringArray2, AttributeList attributeList) {
        BitSet bitSet = this.bitSet(stringArray);
        BitSet bitSet2 = this.bitSet(stringArray2);
        Element element = this.defineElement(string, n, bl, bl2, contentModel, bitSet, bitSet2, attributeList);
        return element;
    }

    protected Entity defEntity(String string, int n, String string2) {
        Entity entity = this.newEntity(string, n);
        entity.data = string2.toCharArray();
        return entity;
    }

    private void assignField(Element element) {
        block5: {
            String string = element.name;
            try {
                Field field = this.getClass().getField(string.toLowerCase());
                if ((field.getModifiers() & 1) != 0 && (field.getModifiers() & 8) == 0 && field.getType().isAssignableFrom(element.getClass())) {
                    field.set(this, element);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.unexpected(illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OutOfMemoryError)) break block5;
                throw (Error)throwable;
            }
        }
    }

    private BitSet bitSet(String[] stringArray) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element = this.getElement(stringArray[i]);
            if (element == null) {
                element = this.newElement(stringArray[i]);
            }
            bitSet.set(element.index);
        }
        return bitSet;
    }

    private Element newElement(String string) {
        Element element = this.elementHash.get(string.toLowerCase());
        if (element == null) {
            element = new Element();
            element.name = string;
            element.index = this.elements.size();
            this.elements.add(element);
            this.elementHash.put(element.name.toLowerCase(), element);
            this.assignField(element);
        }
        return element;
    }

    private Entity newEntity(String string, int n) {
        Entity entity = new Entity(string, n, null);
        this.entityHash.put(entity.name, entity);
        return entity;
    }

    private void unexpected(Exception exception) {
        throw new Error("This should never happen, report a bug", exception);
    }
}

