/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.BorderWidth;
import gnu.javax.swing.text.html.css.CSSColor;
import gnu.javax.swing.text.html.css.CSSParser;
import gnu.javax.swing.text.html.css.CSSParserCallback;
import gnu.javax.swing.text.html.css.FontSize;
import gnu.javax.swing.text.html.css.FontStyle;
import gnu.javax.swing.text.html.css.FontWeight;
import gnu.javax.swing.text.html.css.Length;
import gnu.javax.swing.text.html.css.Selector;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CSSBorder;
import javax.swing.text.html.HTML;
import javax.swing.text.html.MultiStyle;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.ViewAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheet
extends StyleContext {
    URL base;
    int baseFontSize = 4;
    private ArrayList<StyleSheet> linked;
    ArrayList<CSSStyle> css = new ArrayList();
    private HashMap<String, Style> resolvedStyles = new HashMap();

    public Style getRule(HTML.Tag tag, Element element) {
        AttributeSet attributeSet;
        Element element2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (element2 = element; element2 != null; element2 = element2.getParentElement()) {
            arrayList.add(element2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        for (int i = n - 1; i > 0; --i) {
            element2 = (Element)arrayList.get(i);
            attributeSet = element2.getAttributes();
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            stringBuilder.append(object.toString());
            if (attributeSet.isDefined(HTML.Attribute.ID)) {
                stringBuilder.append('#');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.ID));
            }
            if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                stringBuilder.append('.');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
            }
            if (attributeSet.isDefined(HTML.Attribute.DYNAMIC_CLASS)) {
                stringBuilder.append(':');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.DYNAMIC_CLASS));
            }
            if (attributeSet.isDefined(HTML.Attribute.PSEUDO_CLASS)) {
                stringBuilder.append(':');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.PSEUDO_CLASS));
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append(tag.toString());
        element2 = (Element)arrayList.get(0);
        attributeSet = element2.getAttributes();
        if (element2.isLeaf()) {
            Object object = attributeSet.getAttribute(tag);
            attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
        }
        if (attributeSet != null) {
            if (attributeSet.isDefined(HTML.Attribute.ID)) {
                stringBuilder.append('#');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.ID));
            }
            if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                stringBuilder.append('.');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
            }
            if (attributeSet.isDefined(HTML.Attribute.DYNAMIC_CLASS)) {
                stringBuilder.append(':');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.DYNAMIC_CLASS));
            }
            if (attributeSet.isDefined(HTML.Attribute.PSEUDO_CLASS)) {
                stringBuilder.append(':');
                stringBuilder.append(attributeSet.getAttribute(HTML.Attribute.PSEUDO_CLASS));
            }
        }
        return this.getResolvedStyle(stringBuilder.toString(), arrayList, tag);
    }

    private Style getResolvedStyle(String string, List<Element> list2, HTML.Tag tag) {
        Style style = this.resolvedStyles.get(string);
        if (style == null) {
            style = this.resolveStyle(string, list2, tag);
        }
        return style;
    }

    private Style resolveStyle(String string, List<Element> list2, HTML.Tag tag) {
        int n = list2.size();
        String[] stringArray = new String[n];
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(n);
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element = list2.get(i);
            AttributeSet attributeSet = element.getAttributes();
            if (i == 0 && element.isLeaf()) {
                object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                object = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                stringArray[i] = object != null ? ((HTML.Tag)object).toString() : null;
                arrayList.add(this.attributeSetToMap(attributeSet));
                continue;
            }
            stringArray[i] = null;
            arrayList.add(null);
        }
        stringArray[0] = tag.toString();
        return this.resolveStyle(string, stringArray, arrayList);
    }

    private Style resolveStyle(String string, String[] stringArray, List<Map<String, String>> list2) {
        ArrayList<CSSStyle> arrayList = new ArrayList<CSSStyle>();
        for (CSSStyle object2 : this.css) {
            if (!object2.selector.matches(stringArray, list2)) continue;
            arrayList.add(object2);
        }
        if (this.linked != null) {
            for (int i = this.linked.size() - 1; i >= 0; --i) {
                StyleSheet styleSheet = this.linked.get(i);
                for (int j = styleSheet.css.size() - 1; j >= 0; --j) {
                    CSSStyle cSSStyle = styleSheet.css.get(j);
                    if (!cSSStyle.selector.matches(stringArray, list2)) continue;
                    arrayList.add(cSSStyle);
                }
            }
        }
        Collections.sort(arrayList);
        AttributeSet[] attributeSetArray = arrayList.toArray(new Style[arrayList.size()]);
        MultiStyle multiStyle = new MultiStyle(string, attributeSetArray);
        this.resolvedStyles.put(string, multiStyle);
        return multiStyle;
    }

    public Style getRule(String string) {
        CSSStyle cSSStyle = null;
        for (CSSStyle cSSStyle2 : this.css) {
            if (cSSStyle2.compareTo(cSSStyle) >= 0) continue;
            cSSStyle = cSSStyle2;
        }
        return cSSStyle;
    }

    public void addRule(String string) {
        CSSStyleSheetParserCallback cSSStyleSheetParserCallback = new CSSStyleSheetParserCallback(200000);
        StringReader stringReader = new StringReader(string);
        CSSParser cSSParser = new CSSParser(stringReader, cSSStyleSheetParserCallback);
        try {
            cSSParser.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resolvedStyles.clear();
    }

    public AttributeSet getDeclaration(String string) {
        if (string == null) {
            return SimpleAttributeSet.EMPTY;
        }
        return null;
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
        CSSStyleSheetParserCallback cSSStyleSheetParserCallback = new CSSStyleSheetParserCallback(0);
        CSSParser cSSParser = new CSSParser(reader, cSSStyleSheetParserCallback);
        cSSParser.parse();
    }

    public AttributeSet getViewAttributes(View view) {
        return new ViewAttributeSet(view, this);
    }

    @Override
    public void removeStyle(String string) {
        super.removeStyle(string);
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        if (this.linked == null) {
            this.linked = new ArrayList();
        }
        this.linked.add(styleSheet);
    }

    public void removeStyleSheet(StyleSheet styleSheet) {
        if (this.linked != null) {
            this.linked.remove(styleSheet);
        }
    }

    public StyleSheet[] getStyleSheets() {
        StyleSheet[] styleSheetArray;
        if (this.linked != null) {
            styleSheetArray = new StyleSheet[this.linked.size()];
            styleSheetArray = this.linked.toArray(styleSheetArray);
        } else {
            styleSheetArray = null;
        }
        return styleSheetArray;
    }

    public void importStyleSheet(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            CSSStyleSheetParserCallback cSSStyleSheetParserCallback = new CSSStyleSheetParserCallback(200000);
            CSSParser cSSParser = new CSSParser(bufferedReader, cSSStyleSheetParserCallback);
            cSSParser.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setBase(URL uRL) {
        this.base = uRL;
    }

    public URL getBase() {
        return this.base;
    }

    public void addCSSAttribute(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        Object object = CSS.getValue(attribute, string);
        CSS.addInternal(mutableAttributeSet, attribute, string);
        mutableAttributeSet.addAttribute(attribute, object);
    }

    public boolean addCSSAttributeFromHTML(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        mutableAttributeSet.addAttribute(attribute, string);
        return mutableAttributeSet.containsAttribute(attribute, string);
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        HTML.Tag tag;
        AttributeSet attributeSet2 = attributeSet.copyAttributes();
        Object object = attributeSet.getAttribute(HTML.Attribute.ALIGN);
        if (object != null) {
            attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.TEXT_ALIGN, object);
        }
        if ((object = attributeSet.getAttribute(HTML.Attribute.WIDTH)) != null) {
            attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.WIDTH, new Length(object.toString()));
        }
        if ((object = attributeSet.getAttribute(HTML.Attribute.HEIGHT)) != null) {
            attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.HEIGHT, new Length(object.toString()));
        }
        if ((object = attributeSet.getAttribute(HTML.Attribute.NOWRAP)) != null) {
            attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.WHITE_SPACE, "nowrap");
        }
        if ((object = attributeSet.getAttribute(HTML.Attribute.CELLSPACING)) != null) {
            attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.BORDER_SPACING, new Length(object.toString()));
        }
        if (((tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.TD || tag == HTML.Tag.TH) && attributeSet instanceof Element) {
            Element element = (Element)((Object)attributeSet);
            AttributeSet attributeSet3 = element.getParentElement().getParentElement().getAttributes();
            object = attributeSet3.getAttribute(HTML.Attribute.CELLPADDING);
            if (object != null) {
                Length length = new Length(object.toString());
                attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.PADDING_BOTTOM, length);
                attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.PADDING_LEFT, length);
                attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.PADDING_RIGHT, length);
                attributeSet2 = this.addAttribute(attributeSet2, CSS.Attribute.PADDING_TOP, length);
            }
            object = attributeSet3.getAttribute(HTML.Attribute.BORDER);
            attributeSet2 = this.translateBorder(attributeSet2, object);
        }
        object = attributeSet2.getAttribute(HTML.Attribute.BORDER);
        attributeSet2 = this.translateBorder(attributeSet2, object);
        return attributeSet2;
    }

    private AttributeSet translateBorder(AttributeSet attributeSet, Object object) {
        BorderWidth borderWidth;
        if (object != null && (borderWidth = new BorderWidth(object.toString())).getValue() > 0.0f) {
            attributeSet = this.addAttribute(attributeSet, CSS.Attribute.BORDER_WIDTH, borderWidth);
            attributeSet = this.addAttribute(attributeSet, CSS.Attribute.BORDER_STYLE, "solid");
            attributeSet = this.addAttribute(attributeSet, CSS.Attribute.BORDER_COLOR, new CSSColor("black"));
        }
        return attributeSet;
    }

    @Override
    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        return super.addAttribute(attributeSet, object, object2);
    }

    @Override
    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return super.addAttributes(attributeSet, attributeSet2);
    }

    @Override
    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        return super.removeAttribute(attributeSet, object);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return super.removeAttributes(attributeSet, attributeSet2);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        return super.removeAttributes(attributeSet, enumeration);
    }

    @Override
    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return super.createSmallAttributeSet(attributeSet);
    }

    @Override
    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return super.createLargeAttributeSet(attributeSet);
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        FontStyle fontStyle;
        String string;
        int n = this.getFontSize(attributeSet);
        Object object = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        if (object != null && ((string = object.toString()).contains("sup") || string.contains("sub"))) {
            n -= 2;
        }
        string = "SansSerif";
        int n2 = 0;
        FontWeight fontWeight = (FontWeight)attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT);
        if (fontWeight != null) {
            n2 |= fontWeight.getValue();
        }
        if ((fontStyle = (FontStyle)attributeSet.getAttribute(CSS.Attribute.FONT_STYLE)) != null) {
            n2 |= fontStyle.getValue();
        }
        return new Font(string, n2, n);
    }

    float getEMBase(AttributeSet attributeSet) {
        Font font = this.getFont(attributeSet);
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = font.getStringBounds("M", fontRenderContext);
        return (float)rectangle2D.getWidth();
    }

    float getEXBase(AttributeSet attributeSet) {
        Font font = this.getFont(attributeSet);
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = font.getStringBounds("x", fontRenderContext);
        return (float)rectangle2D.getHeight();
    }

    private int getFontSize(AttributeSet attributeSet) {
        int n = 12;
        if (attributeSet.isDefined(CSS.Attribute.FONT_SIZE)) {
            FontSize fontSize = (FontSize)attributeSet.getAttribute(CSS.Attribute.FONT_SIZE);
            if (fontSize.isRelative()) {
                int n2 = 12;
                AttributeSet attributeSet2 = attributeSet.getResolveParent();
                if (attributeSet2 != null) {
                    n2 = this.getFontSize(attributeSet2);
                }
                n = fontSize.getValue(n2);
            } else {
                n = fontSize.getValue();
            }
        } else {
            AttributeSet attributeSet3 = attributeSet.getResolveParent();
            if (attributeSet3 != null) {
                n = this.getFontSize(attributeSet3);
            }
        }
        return n;
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        CSSColor cSSColor = (CSSColor)attributeSet.getAttribute(CSS.Attribute.COLOR);
        Color color = null;
        if (cSSColor != null) {
            color = cSSColor.getValue();
        }
        return color;
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        CSSColor cSSColor = (CSSColor)attributeSet.getAttribute(CSS.Attribute.BACKGROUND_COLOR);
        Color color = null;
        if (cSSColor != null) {
            color = cSSColor.getValue();
        }
        return color;
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return new BoxPainter(attributeSet, this);
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return new ListPainter(attributeSet, this);
    }

    public void setBaseFontSize(int n) {
        if (n <= 7 && n >= 1) {
            this.baseFontSize = n;
        }
    }

    public void setBaseFontSize(String string) {
        string = string.trim();
        int n = 0;
        try {
            if (string.length() == 2) {
                int n2 = new Integer(string.substring(1));
                if (string.startsWith("+")) {
                    n = this.baseFontSize + n2;
                } else if (string.startsWith("-")) {
                    n = this.baseFontSize - n2;
                }
            } else if (string.length() == 1) {
                n = new Integer(string.substring(0));
            }
            if (n <= 7 && n >= 1) {
                this.baseFontSize = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static int getIndexOfSize(float f) {
        return 0;
    }

    public float getPointSize(int n) {
        return 0.0f;
    }

    public float getPointSize(String string) {
        return 0.0f;
    }

    public Color stringToColor(String string) {
        return CSSColor.convertValue(string);
    }

    private Map<String, String> attributeSetToMap(AttributeSet attributeSet) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            hashMap.put(obj.toString(), object.toString());
        }
        return hashMap;
    }

    public static class ListPainter
    implements Serializable {
        private AttributeSet attributes;
        private StyleSheet styleSheet;
        private String type;
        private final Rectangle tmpRect = new Rectangle();

        ListPainter(AttributeSet attributeSet, StyleSheet styleSheet) {
            this.attributes = attributeSet;
            this.styleSheet = styleSheet;
            this.type = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view, int n) {
            View view2 = view.getView(n);
            AttributeSet attributeSet = view2.getAttributes();
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object != null && object == HTML.Tag.LI) {
                Shape shape;
                Rectangle rectangle;
                ParagraphView paragraphView;
                Shape shape2;
                View view3;
                graphics.setColor(Color.BLACK);
                int n2 = (int)(f - 12.0f);
                int n3 = -1;
                this.tmpRect.setBounds((int)f, (int)f2, (int)f3, (int)f4);
                if (view2.getViewCount() > 0 && (view3 = view2.getView(0)) instanceof ParagraphView && view3.getViewCount() > 0 && (shape2 = (paragraphView = (ParagraphView)view3).getChildAllocation(0, rectangle = (shape = view2.getChildAllocation(0, this.tmpRect)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds())) != null) {
                    Rectangle rectangle2 = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                    n3 = rectangle2.height / 2 + rectangle2.y;
                }
                if (n3 == -1) {
                    n3 = (int)(f4 / 2.0f + f2);
                }
                graphics.fillOval(n2 - 3, n3 - 3, 6, 6);
            }
        }
    }

    public static class BoxPainter
    implements Serializable {
        private float leftInset;
        private float rightInset;
        private float topInset;
        private float bottomInset;
        private Border border;
        private float leftPadding;
        private float rightPadding;
        private float topPadding;
        private float bottomPadding;
        private Color background;

        BoxPainter(AttributeSet attributeSet, StyleSheet styleSheet) {
            float f = styleSheet.getEMBase(attributeSet);
            float f2 = styleSheet.getEXBase(attributeSet);
            Length length = (Length)attributeSet.getAttribute(CSS.Attribute.MARGIN_LEFT);
            if (length != null) {
                length.setFontBases(f, f2);
                this.leftInset = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.MARGIN_RIGHT)) != null) {
                length.setFontBases(f, f2);
                this.rightInset = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.MARGIN_TOP)) != null) {
                length.setFontBases(f, f2);
                this.topInset = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.MARGIN_BOTTOM)) != null) {
                length.setFontBases(f, f2);
                this.bottomInset = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.PADDING_LEFT)) != null) {
                length.setFontBases(f, f2);
                this.leftPadding = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.PADDING_RIGHT)) != null) {
                length.setFontBases(f, f2);
                this.rightPadding = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.PADDING_TOP)) != null) {
                length.setFontBases(f, f2);
                this.topPadding = length.getValue();
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.PADDING_BOTTOM)) != null) {
                length.setFontBases(f, f2);
                this.bottomPadding = length.getValue();
            }
            this.border = new CSSBorder(attributeSet, styleSheet);
            this.background = styleSheet.getBackground(attributeSet);
        }

        public float getInset(int n, View view) {
            float f;
            switch (n) {
                case 1: {
                    f = this.topInset;
                    if (this.border != null) {
                        f += (float)this.border.getBorderInsets(null).top;
                    }
                    f += this.topPadding;
                    break;
                }
                case 3: {
                    f = this.bottomInset;
                    if (this.border != null) {
                        f += (float)this.border.getBorderInsets(null).bottom;
                    }
                    f += this.bottomPadding;
                    break;
                }
                case 2: {
                    f = this.leftInset;
                    if (this.border != null) {
                        f += (float)this.border.getBorderInsets(null).left;
                    }
                    f += this.leftPadding;
                    break;
                }
                case 4: {
                    f = this.rightInset;
                    if (this.border != null) {
                        f += (float)this.border.getBorderInsets(null).right;
                    }
                    f += this.rightPadding;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
            int n = (int)(f + this.leftInset);
            int n2 = (int)(f2 + this.topInset);
            int n3 = (int)(f3 - this.leftInset - this.rightInset);
            int n4 = (int)(f4 - this.topInset - this.bottomInset);
            if (this.background != null) {
                graphics.setColor(this.background);
                graphics.fillRect(n, n2, n3, n4);
            }
            if (this.border != null) {
                this.border.paintBorder(null, graphics, n, n2, n3, n4);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSSStyle
    extends SimpleAttributeSet
    implements Style,
    Comparable<CSSStyle> {
        static final int PREC_UA = 0;
        static final int PREC_NORM = 100000;
        static final int PREC_AUTHOR_NORMAL = 200000;
        static final int PREC_AUTHOR_IMPORTANT = 300000;
        static final int PREC_USER_IMPORTANT = 400000;
        private int precedence;
        Selector selector;

        CSSStyle(int n, Selector selector) {
            this.precedence = n;
            this.selector = selector;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public int compareTo(CSSStyle cSSStyle) {
            return cSSStyle.precedence + cSSStyle.selector.getSpecificity() - this.precedence - this.selector.getSpecificity();
        }
    }

    class CSSStyleSheetParserCallback
    implements CSSParserCallback {
        private CSSStyle[] styles;
        private int precedence;

        CSSStyleSheetParserCallback(int n) {
            this.precedence = n;
        }

        public void startStatement(Selector[] selectorArray) {
            this.styles = new CSSStyle[selectorArray.length];
            for (int i = 0; i < selectorArray.length; ++i) {
                this.styles[i] = new CSSStyle(this.precedence, selectorArray[i]);
            }
        }

        public void endStatement() {
            for (int i = 0; i < this.styles.length; ++i) {
                StyleSheet.this.css.add(this.styles[i]);
            }
            this.styles = null;
        }

        public void declaration(String string, String string2) {
            CSS.Attribute attribute = CSS.getAttribute(string);
            Object object = CSS.getValue(attribute, string2);
            for (int i = 0; i < this.styles.length; ++i) {
                CSSStyle cSSStyle = this.styles[i];
                CSS.addInternal(cSSStyle, attribute, string2);
                if (attribute == null) continue;
                cSSStyle.addAttribute(attribute, object);
            }
        }
    }
}

