/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiAttributeSet
implements AttributeSet {
    AttributeSet[] multi;

    MultiAttributeSet() {
    }

    MultiAttributeSet(AttributeSet[] attributeSetArray) {
        this.init(attributeSetArray);
    }

    void init(AttributeSet[] attributeSetArray) {
        this.multi = attributeSetArray;
    }

    @Override
    public boolean containsAttribute(Object object, Object object2) {
        boolean bl = false;
        for (int i = 0; i < this.multi.length && !bl; ++i) {
            if (!this.multi[i].containsAttribute(object, object2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean containsAttributes(AttributeSet attributeSet) {
        boolean bl = true;
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (bl && enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            bl = attributeSet.getAttribute(obj).equals(this.getAttribute(obj));
        }
        return bl;
    }

    @Override
    public AttributeSet copyAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        for (int i = 0; i < this.multi.length; ++i) {
            simpleAttributeSet.addAttributes(this.multi[i]);
        }
        return simpleAttributeSet;
    }

    @Override
    public Object getAttribute(Object object) {
        Object object2 = null;
        for (int i = 0; i < this.multi.length && object2 == null; ++i) {
            object2 = this.multi[i].getAttribute(object);
        }
        return object2;
    }

    @Override
    public int getAttributeCount() {
        int n = 0;
        for (int i = 0; i < this.multi.length; ++i) {
            n += this.multi[i].getAttributeCount();
        }
        return n;
    }

    @Override
    public Enumeration<?> getAttributeNames() {
        return new MultiNameEnumeration();
    }

    @Override
    public AttributeSet getResolveParent() {
        return null;
    }

    @Override
    public boolean isDefined(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.multi.length && !bl; ++i) {
            bl = this.multi[i].isDefined(object);
        }
        return bl;
    }

    @Override
    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiNameEnumeration
    implements Enumeration<Object> {
        private int index = 0;
        private Enumeration<?> current;

        MultiNameEnumeration() {
            this.current = MultiAttributeSet.this.multi[0].getAttributeNames();
        }

        @Override
        public boolean hasMoreElements() {
            return this.current.hasMoreElements() || this.index < MultiAttributeSet.this.multi.length - 1;
        }

        @Override
        public Object nextElement() {
            if (!this.current.hasMoreElements()) {
                if (this.index < MultiAttributeSet.this.multi.length - 1) {
                    ++this.index;
                    this.current = MultiAttributeSet.this.multi[this.index].getAttributeNames();
                } else {
                    throw new NoSuchElementException();
                }
            }
            return this.current.nextElement();
        }
    }
}

