/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MinimalHTMLWriter
extends AbstractWriter {
    private StyledDocument doc;
    private Deque<String> tagStack;
    private boolean inFontTag = false;

    public MinimalHTMLWriter(Writer writer, StyledDocument styledDocument) {
        super(writer, styledDocument);
        this.doc = styledDocument;
        this.tagStack = new ArrayDeque<String>();
    }

    public MinimalHTMLWriter(Writer writer, StyledDocument styledDocument, int n, int n2) {
        super(writer, styledDocument, n, n2);
        this.doc = styledDocument;
        this.tagStack = new ArrayDeque<String>();
    }

    protected void startFontTag(String string) throws IOException {
        if (this.inFontTag()) {
            this.endOpenTags();
        }
        this.writeStartTag("<span style=\"" + string + "\">");
        this.inFontTag = true;
    }

    protected boolean inFontTag() {
        return this.inFontTag;
    }

    protected void endFontTag() throws IOException {
        this.writeEndTag("</span>");
        this.inFontTag = false;
    }

    public synchronized void write() throws IOException, BadLocationException {
        this.writeStartTag("<html>");
        this.writeHeader();
        this.writeBody();
        this.writeEndTag("</html>");
    }

    protected void writeStartTag(String string) throws IOException {
        this.indent();
        this.write(string + '\n');
        this.incrIndent();
    }

    protected void writeEndTag(String string) throws IOException {
        this.decrIndent();
        this.indent();
        this.write(string + '\n');
    }

    protected void writeHeader() throws IOException {
        this.writeStartTag("<head>");
        this.writeStartTag("<style>");
        this.writeStartTag("<!--");
        this.writeStyles();
        this.writeEndTag("-->");
        this.writeEndTag("</style>");
        this.writeEndTag("</head>");
    }

    protected void writeStartParagraph(Element element) throws IOException {
        this.indent();
        this.write("<p class=default>\n");
        this.incrIndent();
    }

    protected void writeEndParagraph() throws IOException {
        this.endOpenTags();
        this.writeEndTag("</p>");
    }

    protected void writeBody() throws IOException, BadLocationException {
        this.writeStartTag("<body>");
        ElementIterator elementIterator = this.getElementIterator();
        Element element = elementIterator.first();
        boolean bl = false;
        do {
            boolean bl2;
            if (!element.isLeaf()) continue;
            boolean bl3 = bl2 = this.getText(element).indexOf(10) != -1;
            if (!bl && this.hasText(element)) {
                this.writeStartParagraph(element);
                bl = true;
            }
            if (this.hasText(element)) {
                this.writeContent(element, true);
            }
            if (bl2 && bl) {
                this.writeEndParagraph();
                bl = false;
                continue;
            }
            this.endOpenTags();
        } while ((element = elementIterator.next()) != null);
        this.writeEndTag("</body>");
    }

    protected void text(Element element) throws IOException, BadLocationException {
        this.write(this.getText(element).trim());
    }

    protected void writeHTMLTags(AttributeSet attributeSet) throws IOException {
        if (attributeSet.getAttribute(StyleConstants.Bold) != null && ((Boolean)attributeSet.getAttribute(StyleConstants.Bold)).booleanValue()) {
            this.write("<b>");
            this.tagStack.push("</b>");
        }
        if (attributeSet.getAttribute(StyleConstants.Italic) != null && ((Boolean)attributeSet.getAttribute(StyleConstants.Italic)).booleanValue()) {
            this.write("<i>");
            this.tagStack.push("</i>");
        }
        if (attributeSet.getAttribute(StyleConstants.Underline) != null && ((Boolean)attributeSet.getAttribute(StyleConstants.Underline)).booleanValue()) {
            this.write("<u>");
            this.tagStack.push("</u>");
        }
    }

    protected boolean isText(Element element) {
        return element.getEndOffset() != element.getStartOffset();
    }

    protected void writeContent(Element element, boolean bl) throws IOException, BadLocationException {
        this.writeNonHTMLAttributes(element.getAttributes());
        if (bl) {
            this.indent();
        }
        this.writeHTMLTags(element.getAttributes());
        if (this.isText(element)) {
            this.text(element);
        } else {
            this.writeLeaf(element);
        }
        this.endOpenTags();
    }

    protected void writeLeaf(Element element) throws IOException {
        if (element.getName().equals("icon")) {
            this.writeImage(element);
        } else {
            this.writeComponent(element);
        }
    }

    protected void writeNonHTMLAttributes(AttributeSet attributeSet) throws IOException {
        String string = "";
        if (StyleConstants.getForeground(attributeSet) != null) {
            string = string + "color: " + this.getColor(StyleConstants.getForeground(attributeSet)) + "; ";
        }
        string = string + "font-size: " + StyleConstants.getFontSize(attributeSet) + "pt; ";
        string = string + "font-family: " + StyleConstants.getFontFamily(attributeSet);
        this.startFontTag(string);
    }

    protected void writeStyles() throws IOException {
        if (this.doc instanceof DefaultStyledDocument) {
            Enumeration<?> enumeration = ((DefaultStyledDocument)this.doc).getStyleNames();
            while (enumeration.hasMoreElements()) {
                this.writeStyle(this.doc.getStyle((String)enumeration.nextElement()));
            }
        } else {
            Style style = this.doc.getStyle("default");
            if (style != null) {
                this.writeStyle(style);
            }
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            String string = obj.toString();
            String string2 = this.getAttribute(string, attributeSet.getAttribute(obj));
            if (string2 == null) continue;
            this.indent();
            this.write(string2 + '\n');
        }
    }

    protected void writeComponent(Element element) throws IOException {
    }

    protected void writeImage(Element element) throws IOException {
    }

    private String getAttribute(String string, Object object) throws IOException {
        if (string.equals("foreground")) {
            return "foreground:" + this.getColor((Color)object) + ";";
        }
        if (string.equals("background")) {
            return "background:" + this.getColor((Color)object) + ";";
        }
        if (string.equals("italic")) {
            return "italic:" + ((Boolean)object != false ? "italic;" : ";");
        }
        if (string.equals("bold")) {
            return "bold:" + ((Boolean)object != false ? "bold;" : "normal;");
        }
        if (string.equals("family")) {
            return "family:" + object + ";";
        }
        if (string.equals("size")) {
            int n = (Integer)object;
            int n2 = n > 24 ? 7 : (n > 18 ? 6 : (n > 14 ? 5 : (n > 12 ? 4 : (n > 10 ? 3 : (n > 8 ? 2 : 1)))));
            return "size:" + n2 + ";";
        }
        return null;
    }

    private String getColor(Color color) {
        String string = "00" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        return "#" + string + string2 + string3;
    }

    private void endOpenTags() throws IOException {
        while (this.tagStack.size() > 0) {
            this.write(this.tagStack.pop());
        }
        if (this.inFontTag()) {
            this.write("\n");
            this.endFontTag();
        }
    }

    private void writeStyle(Style style) throws IOException {
        if (style == null) {
            return;
        }
        this.writeStartTag("p." + style.getName() + " {");
        this.writeAttributes(style);
        this.writeEndTag("}");
    }

    private boolean hasText(Element element) throws BadLocationException {
        return this.getText(element).trim().length() > 0;
    }
}

