/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.ComboBoxModel;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Option;

public class HTMLWriter
extends AbstractWriter {
    private Writer outWriter = null;
    private HTMLDocument htmlDoc = null;
    private HashSet<HTML.Tag> openEmbeddedTagHashSet = null;
    private String new_line_str = "\n";
    private char[] html_entity_char_arr = new char[]{'<', '>', '&', '\"'};
    private String[] html_entity_escape_str_arr = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    private int doc_pos = -1;
    private int doc_len = -1;
    private int doc_offset_remaining = -1;
    private int doc_len_remaining = -1;
    private HashSet<Element> htmlFragmentParentHashSet = null;
    private Element startElem = null;
    private Element endElem = null;
    private boolean fg_pass_start_elem = false;
    private boolean fg_pass_end_elem = false;

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument) {
        super(writer, hTMLDocument);
        this.outWriter = writer;
        this.htmlDoc = hTMLDocument;
        this.openEmbeddedTagHashSet = new HashSet();
    }

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2) {
        super(writer, hTMLDocument, n, n2);
        this.outWriter = writer;
        this.htmlDoc = hTMLDocument;
        this.openEmbeddedTagHashSet = new HashSet();
        this.doc_pos = n;
        this.doc_offset_remaining = n;
        this.doc_len = n2;
        this.doc_len_remaining = n2;
        this.htmlFragmentParentHashSet = new HashSet();
    }

    public void write() throws IOException, BadLocationException {
        Element element = this.htmlDoc.getDefaultRootElement();
        if (this.doc_pos == -1 && this.doc_len == -1) {
            this.traverse(element);
        } else {
            if (this.doc_pos == -1 || this.doc_len == -1) {
                throw new BadLocationException("Bad Location(" + this.doc_pos + ", " + this.doc_len + ")", this.doc_pos);
            }
            this.startElem = this.htmlDoc.getCharacterElement(this.doc_pos);
            int n = this.startElem.getStartOffset();
            if (n > 0) {
                this.doc_offset_remaining -= n;
            }
            Element element2 = this.startElem;
            while ((element2 = element2.getParentElement()) != null) {
                if (this.htmlFragmentParentHashSet.contains(element2)) continue;
                this.htmlFragmentParentHashSet.add(element2);
            }
            element2 = this.endElem = this.htmlDoc.getCharacterElement(this.doc_pos + this.doc_len - 1);
            while ((element2 = element2.getParentElement()) != null) {
                if (this.htmlFragmentParentHashSet.contains(element2)) continue;
                this.htmlFragmentParentHashSet.add(element2);
            }
            this.traverseHtmlFragment(element);
        }
        HTML.Tag[] tagArray = this.openEmbeddedTagHashSet.toArray((HTML.Tag[])new HTML.Tag[this.openEmbeddedTagHashSet.size()]);
        for (int i = 0; i < tagArray.length; ++i) {
            this.writeRaw("</" + tagArray[i].toString() + ">");
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            if (obj instanceof HTML.Tag || obj instanceof StyleConstants || obj == HTML.Attribute.ENDTAG) continue;
            if (obj == HTML.Attribute.SELECTED) {
                this.writeRaw(" selected");
                continue;
            }
            if (obj == HTML.Attribute.CHECKED) {
                this.writeRaw(" checked");
                continue;
            }
            this.writeRaw(" " + obj + "=\"" + object + "\"");
        }
    }

    protected void emptyTag(Element element) throws IOException, BadLocationException {
        String string = element.getName();
        AttributeSet attributeSet = element.getAttributes();
        this.writeRaw("<" + string);
        this.writeAttributes(attributeSet);
        this.writeRaw(">");
        if (this.isBlockTag(attributeSet)) {
            this.writeRaw("</" + string + ">");
        }
    }

    protected boolean isBlockTag(AttributeSet attributeSet) {
        return ((HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute)).isBlock();
    }

    protected void startTag(Element element) throws IOException, BadLocationException {
        String string = element.getName();
        AttributeSet attributeSet = element.getAttributes();
        this.indent();
        this.writeRaw("<" + string);
        this.writeAttributes(attributeSet);
        this.writeRaw(">");
        this.writeLineSeparator();
        this.incrIndent();
    }

    protected void textAreaContent(AttributeSet attributeSet) throws IOException, BadLocationException {
        this.writeLineSeparator();
        this.indent();
        this.writeRaw("<textarea");
        this.writeAttributes(attributeSet);
        this.writeRaw(">");
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        this.writeRaw(document.getText(0, document.getLength()));
        this.indent();
        this.writeRaw("</textarea>");
    }

    protected void text(Element element) throws IOException, BadLocationException {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset() - element.getStartOffset();
        String string = this.htmlDoc.getText(n, n2);
        this.writeContent(string);
    }

    protected void selectContent(AttributeSet attributeSet) throws IOException {
        this.writeLineSeparator();
        this.indent();
        this.writeRaw("<select");
        this.writeAttributes(attributeSet);
        this.writeRaw(">");
        this.incrIndent();
        this.writeLineSeparator();
        ComboBoxModel comboBoxModel = (ComboBoxModel)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            this.writeOption((Option)comboBoxModel.getElementAt(i));
        }
        this.decrIndent();
        this.indent();
        this.writeRaw("</select>");
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.writeRaw("<option");
        this.writeAttributes(option.getAttributes());
        this.writeRaw(">");
        this.writeContent(option.getLabel());
        this.writeRaw("</option>");
        this.writeLineSeparator();
    }

    protected void endTag(Element element) throws IOException {
        String string = element.getName();
        this.decrIndent();
        this.indent();
        this.writeRaw("</" + string + ">");
        this.writeLineSeparator();
    }

    protected void comment(Element element) throws IOException, BadLocationException {
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COMMENT);
        this.writeRaw("<!--" + string + "-->");
    }

    protected boolean synthesizedElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object == HTML.Tag.CONTENT || object == HTML.Tag.COMMENT || object == HTML.Tag.IMPLIED;
    }

    protected boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object == tag;
    }

    protected void writeEmbeddedTags(AttributeSet attributeSet) throws IOException {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            if (!(obj instanceof HTML.Tag) || this.openEmbeddedTagHashSet.contains(obj)) continue;
            this.writeRaw("<" + obj);
            this.writeAttributes((AttributeSet)object);
            this.writeRaw(">");
            this.openEmbeddedTagHashSet.add((HTML.Tag)obj);
        }
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attributeSet) throws IOException {
        HTML.Tag[] tagArray = this.openEmbeddedTagHashSet.toArray((HTML.Tag[])new HTML.Tag[this.openEmbeddedTagHashSet.size()]);
        for (int i = 0; i < tagArray.length; ++i) {
            HTML.Tag tag = tagArray[i];
            if (attributeSet.isDefined(tag)) continue;
            this.writeRaw("</" + tag.toString() + ">");
            this.openEmbeddedTagHashSet.remove(tag);
        }
    }

    protected void writeLineSeparator() throws IOException {
        this.writeRaw(this.new_line_str);
    }

    protected void output(char[] cArray, int n, int n2) throws IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (this.isCharHtmlEntity(cArray[i])) {
                cPStringBuilder.append(this.escapeCharHtmlEntity(cArray[i]));
                continue;
            }
            cPStringBuilder.append(cArray[i]);
        }
        this.writeRaw(cPStringBuilder.toString());
    }

    private void traverse(Element element) throws IOException, BadLocationException {
        Element element2 = element;
        AttributeSet attributeSet = element2.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        if (this.synthesizedElement(element)) {
            int n;
            if (this.matchNameAttribute(attributeSet, HTML.Tag.CONTENT)) {
                this.writeEmbeddedTags(attributeSet);
                this.text(element2);
            } else if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
                this.comment(element2);
            } else if (this.matchNameAttribute(attributeSet, HTML.Tag.IMPLIED) && (n = element2.getElementCount()) > 0) {
                for (int i = 0; i < n; ++i) {
                    Element element3 = element.getElement(i);
                    this.traverse(element3);
                }
            }
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.TITLE)) {
            Object object;
            boolean bl = false;
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                Object object2 = attributeSet.getAttribute(object);
                if (object != HTML.Attribute.ENDTAG || !object2.equals("true")) continue;
                bl = true;
            }
            if (bl) {
                this.writeRaw("</title>");
            } else {
                this.indent();
                this.writeRaw("<title>");
                object = (String)this.htmlDoc.getProperty("title");
                if (object != null) {
                    this.writeContent((String)object);
                }
            }
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.PRE)) {
            attributeSet = element.getAttributes();
            this.indent();
            this.writeRaw("<pre");
            this.writeAttributes(attributeSet);
            this.writeRaw(">");
            int n = element2.getElementCount();
            for (int i = 0; i < n; ++i) {
                Element element4 = element.getElement(i);
                this.traverse(element4);
            }
            this.writeRaw("</pre>");
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.SELECT)) {
            this.selectContent(attributeSet);
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.TEXTAREA)) {
            this.textAreaContent(attributeSet);
        } else {
            int n = element2.getElementCount();
            if (n > 0) {
                this.startTag(element2);
                for (int i = 0; i < n; ++i) {
                    Element element5 = element.getElement(i);
                    this.traverse(element5);
                }
                this.endTag(element2);
            } else {
                this.emptyTag(element2);
            }
        }
    }

    private void traverseHtmlFragment(Element element) throws IOException, BadLocationException {
        Element element2 = element;
        boolean bl = false;
        boolean bl2 = false;
        if (this.htmlFragmentParentHashSet.contains(element)) {
            bl = true;
        }
        if (element == this.startElem) {
            this.fg_pass_start_elem = true;
        }
        if (element == this.startElem && element == this.endElem) {
            bl2 = true;
        }
        AttributeSet attributeSet = element2.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        if (bl || this.fg_pass_start_elem && !this.fg_pass_end_elem || bl2) {
            if (this.synthesizedElement(element)) {
                int n;
                if (this.matchNameAttribute(attributeSet, HTML.Tag.CONTENT)) {
                    this.writeEmbeddedTags(attributeSet);
                    int n2 = element.getStartOffset();
                    int n3 = element2.getEndOffset() - n2;
                    if (this.doc_offset_remaining > 0) {
                        if (n3 > this.doc_offset_remaining) {
                            int n4 = n3;
                            if ((n4 -= this.doc_offset_remaining) > this.doc_len_remaining) {
                                n4 = this.doc_len_remaining;
                            }
                            String string = this.htmlDoc.getText(n2 + this.doc_offset_remaining, n4);
                            this.writeContent(string);
                            this.doc_offset_remaining = 0;
                            this.doc_len_remaining -= n4;
                        } else {
                            this.doc_offset_remaining -= n3;
                        }
                    } else if (n3 <= this.doc_len_remaining) {
                        this.text(element2);
                        this.doc_len_remaining -= n3;
                    } else {
                        String string = this.htmlDoc.getText(n2, this.doc_len_remaining);
                        this.writeContent(string);
                        this.doc_len_remaining = 0;
                    }
                } else if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
                    this.comment(element2);
                } else if (this.matchNameAttribute(attributeSet, HTML.Tag.IMPLIED) && (n = element2.getElementCount()) > 0) {
                    for (int i = 0; i < n; ++i) {
                        Element element3 = element.getElement(i);
                        this.traverseHtmlFragment(element3);
                    }
                }
            } else {
                if (element.isLeaf()) {
                    if (this.doc_offset_remaining > 0) {
                        --this.doc_offset_remaining;
                    } else if (this.doc_len_remaining > 0) {
                        --this.doc_len_remaining;
                    }
                }
                if (this.matchNameAttribute(attributeSet, HTML.Tag.TITLE)) {
                    Object object;
                    boolean bl3 = false;
                    Enumeration<?> enumeration = attributeSet.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        Object object2 = attributeSet.getAttribute(object);
                        if (object != HTML.Attribute.ENDTAG || !object2.equals("true")) continue;
                        bl3 = true;
                    }
                    if (bl3) {
                        this.writeRaw("</title>");
                    } else {
                        this.indent();
                        this.writeRaw("<title>");
                        object = (String)this.htmlDoc.getProperty("title");
                        if (object != null) {
                            this.writeContent((String)object);
                        }
                    }
                } else if (this.matchNameAttribute(attributeSet, HTML.Tag.PRE)) {
                    attributeSet = element.getAttributes();
                    this.indent();
                    this.writeRaw("<pre");
                    this.writeAttributes(attributeSet);
                    this.writeRaw(">");
                    int n = element2.getElementCount();
                    for (int i = 0; i < n; ++i) {
                        Element element4 = element.getElement(i);
                        this.traverseHtmlFragment(element4);
                    }
                    this.writeRaw("</pre>");
                } else if (this.matchNameAttribute(attributeSet, HTML.Tag.SELECT)) {
                    this.selectContent(attributeSet);
                } else if (this.matchNameAttribute(attributeSet, HTML.Tag.TEXTAREA)) {
                    this.textAreaContent(attributeSet);
                } else {
                    int n = element2.getElementCount();
                    if (n > 0) {
                        this.startTag(element2);
                        for (int i = 0; i < n; ++i) {
                            Element element5 = element.getElement(i);
                            this.traverseHtmlFragment(element5);
                        }
                        this.endTag(element2);
                    } else {
                        this.emptyTag(element2);
                    }
                }
            }
        }
        if (element == this.endElem) {
            this.fg_pass_end_elem = true;
        }
    }

    private void writeRaw(String string) throws IOException {
        super.output(string.toCharArray(), 0, string.length());
    }

    private void writeContent(String string) throws IOException {
        char[] cArray = string.toCharArray();
        if (this.hasHtmlEntity(string)) {
            this.output(cArray, 0, cArray.length);
        } else {
            super.output(cArray, 0, cArray.length);
        }
    }

    private void writeAllAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            this.writeRaw(" " + obj + "=\"" + object + "\"");
            this.writeRaw(" " + obj.getClass().toString() + "=\"" + object.getClass().toString() + "\"");
        }
    }

    private boolean hasHtmlEntity(String string) {
        boolean bl = false;
        for (int i = 0; i < this.html_entity_char_arr.length; ++i) {
            if (string.indexOf(this.html_entity_char_arr[i]) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isCharHtmlEntity(char c) {
        boolean bl = false;
        for (int i = 0; i < this.html_entity_char_arr.length; ++i) {
            if (c != this.html_entity_char_arr[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String escapeCharHtmlEntity(char c) {
        String string = "" + c;
        for (int i = 0; i < this.html_entity_char_arr.length; ++i) {
            if (c != this.html_entity_char_arr[i]) continue;
            string = this.html_entity_escape_str_arr[i];
            break;
        }
        return string;
    }
}

