/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.parser.GnuParserDelegator;
import gnu.javax.swing.text.html.parser.HTML_401F;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BRView;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.FormView;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HRuleView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ListView;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.NullView;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TableView;

public class HTMLEditorKit
extends StyledEditorKit
implements Serializable,
Cloneable,
Accessible {
    private static final long serialVersionUID = 8751997116710384592L;
    public static final String DEFAULT_CSS = "default.css";
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_BORDER = "html-image-border";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableCell", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertPre", "<pre></pre>", HTML.Tag.BODY, HTML.Tag.PRE)};
    private StyleSheet styleSheet;
    HTMLFactory viewFactory;
    Cursor linkCursor;
    Cursor defaultCursor;
    Parser parser;
    private LinkController linkController = new LinkController();
    String contentType = "text/html";
    MutableAttributeSet inputAttributes;
    JEditorPane editorPane;
    private boolean autoFormSubmission = true;

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new HTMLFactory();
        }
        return this.viewFactory;
    }

    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        StyleSheet styleSheet2 = new StyleSheet();
        styleSheet2.addStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = new HTMLDocument(styleSheet2);
        hTMLDocument.setParser(this.getParser());
        hTMLDocument.setAsynchronousLoadPriority(4);
        hTMLDocument.setTokenThreshold(100);
        return hTMLDocument;
    }

    protected Parser getParser() {
        if (this.parser == null) {
            this.parser = new GnuParserDelegator(HTML_401F.getInstance());
        }
        return this.parser;
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) throws BadLocationException, IOException {
        Parser parser = this.getParser();
        if (n < 0 || n > hTMLDocument.getLength()) {
            throw new BadLocationException("Bad location", n);
        }
        if (parser == null) {
            throw new IOException("Parser is null.");
        }
        ParserCallback parserCallback = hTMLDocument.getReader(n, n2, n3, tag);
        parser.parse(new StringReader(string), parserCallback, false);
        parserCallback.flush();
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            Parser parser = this.getParser();
            if (n < 0 || n > document.getLength()) {
                throw new BadLocationException("Bad location", n);
            }
            if (parser == null) {
                throw new IOException("Parser is null.");
            }
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            if (this.editorPane != null) {
                hTMLDocument.setBase(this.editorPane.getPage());
            }
            ParserCallback parserCallback = hTMLDocument.getReader(n);
            parser.parse(reader, parserCallback, false);
            parserCallback.flush();
        } else {
            super.read(reader, document, n);
        }
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLWriter hTMLWriter = new HTMLWriter(writer, (HTMLDocument)document, n, n2);
            hTMLWriter.write();
        } else if (document instanceof StyledDocument) {
            MinimalHTMLWriter minimalHTMLWriter = new MinimalHTMLWriter(writer, (StyledDocument)document, n, n2);
            minimalHTMLWriter.write();
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object clone() {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)super.clone();
        hTMLEditorKit.linkController = new LinkController();
        return hTMLEditorKit;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        jEditorPane.addMouseListener(this.linkController);
        jEditorPane.addMouseMotionListener(this.linkController);
        this.editorPane = jEditorPane;
    }

    public void deinstall(JEditorPane jEditorPane) {
        super.deinstall(jEditorPane);
        jEditorPane.removeMouseListener(this.linkController);
        jEditorPane.removeMouseMotionListener(this.linkController);
        this.editorPane = null;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public Cursor getDefaultCursor() {
        if (this.defaultCursor == null) {
            this.defaultCursor = Cursor.getDefaultCursor();
        }
        return this.defaultCursor;
    }

    public Cursor getLinkCursor() {
        if (this.linkCursor == null) {
            this.linkCursor = Cursor.getPredefinedCursor(12);
        }
        return this.linkCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            try {
                this.styleSheet = new StyleSheet();
                Class<HTMLEditorKit> clazz = HTMLEditorKit.class;
                InputStream inputStream = clazz.getResourceAsStream(DEFAULT_CSS);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                this.styleSheet.loadRules(inputStreamReader, null);
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("No style available.", iOException);
            }
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public boolean isAutoFormSubmission() {
        return this.autoFormSubmission;
    }

    public void setAutoFormSubmission(boolean bl) {
        this.autoFormSubmission = bl;
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleEndOfLineString(String string) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleError(String string, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleText(char[] cArray, int n) {
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            View view = null;
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.IMPLIED || tag == HTML.Tag.P || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6 || tag == HTML.Tag.DT) {
                    view = new ParagraphView(element);
                } else if (tag == HTML.Tag.LI || tag == HTML.Tag.DL || tag == HTML.Tag.DD || tag == HTML.Tag.BODY || tag == HTML.Tag.HTML || tag == HTML.Tag.CENTER || tag == HTML.Tag.DIV || tag == HTML.Tag.BLOCKQUOTE || tag == HTML.Tag.PRE || tag == HTML.Tag.FORM || tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
                    view = new BlockView(element, 1);
                } else if (tag == HTML.Tag.TR) {
                    view = new BlockView(element, 0);
                } else if (tag == HTML.Tag.IMG) {
                    view = new ImageView(element);
                } else if (tag == HTML.Tag.CONTENT) {
                    view = new InlineView(element);
                } else if (tag == HTML.Tag.HEAD) {
                    view = new NullView(element);
                } else if (tag == HTML.Tag.TABLE) {
                    view = new TableView(element);
                } else if (tag == HTML.Tag.HR) {
                    view = new HRuleView(element);
                } else if (tag == HTML.Tag.BR) {
                    view = new BRView(element);
                } else if (tag == HTML.Tag.INPUT || tag == HTML.Tag.SELECT || tag == HTML.Tag.TEXTAREA) {
                    view = new FormView(element);
                } else if (tag == HTML.Tag.MENU || tag == HTML.Tag.DIR || tag == HTML.Tag.UL || tag == HTML.Tag.OL) {
                    view = new ListView(element);
                } else if (tag == HTML.Tag.FRAMESET) {
                    view = new FrameSetView(element);
                } else if (tag == HTML.Tag.FRAME) {
                    view = new FrameView(element);
                } else if (tag == HTML.Tag.OBJECT) {
                    view = new ObjectView(element);
                }
            }
            if (view == null) {
                view = new NullView(element);
            }
            return view;
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String string) {
            super(string);
        }

        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                return (HTMLDocument)document;
            }
            throw new IllegalArgumentException("Document is not a HTMLDocument.");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit is not a HTMLEditorKit.");
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n) {
            return this.getElementsAt(hTMLDocument.getDefaultRootElement(), n, 0);
        }

        private Element[] getElementsAt(Element element, int n, int n2) {
            Element[] elementArray = null;
            if (element != null) {
                if (element.isLeaf()) {
                    elementArray = new Element[n2 + 1];
                    elementArray[n2] = element;
                    return elementArray;
                }
                elementArray = this.getElementsAt(element.getElement(element.getElementIndex(n)), n, n2 + 1);
                elementArray[n2] = element;
            }
            return elementArray;
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = hTMLDocument.getDefaultRootElement();
            int n2 = -1;
            Element element2 = element.getElement(element.getElementIndex(n));
            while (!element2.isLeaf()) {
                ++n2;
                if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute).equals(tag)) {
                    return n2;
                }
                element2 = element2.getElement(element2.getElementIndex(n));
            }
            return n2;
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = null;
            for (Element element2 = hTMLDocument.getDefaultRootElement(); element2 != null; element2 = element2.getElement(element2.getElementIndex(n))) {
                Object object = element2.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (!(object instanceof HTML.Tag) || !object.equals(tag)) continue;
                element = element2;
            }
            return element;
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected HTML.Tag addTag;
        protected HTML.Tag alternateAddTag;
        protected HTML.Tag alternateParentTag;
        protected String html;
        protected HTML.Tag parentTag;

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
            this(string, string2, tag, tag2, null, null);
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
            super(string);
            this.html = string2;
            this.parentTag = tag;
            this.addTag = tag2;
            this.alternateParentTag = tag3;
            this.alternateAddTag = tag4;
        }

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) {
            try {
                super.getHTMLEditorKit(jEditorPane).insertHTML(hTMLDocument, n, string, n2, n3, tag);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException("Parser is null.").initCause(iOException);
            }
            catch (BadLocationException badLocationException) {
                throw (RuntimeException)new RuntimeException("BadLocationException: " + n).initCause(badLocationException);
            }
        }

        protected void insertAtBoundary(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            this.insertAtBoundry(jEditorPane, hTMLDocument, n, element, string, tag, tag2);
        }

        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            Element element2;
            Element element3 = element;
            if (n > 0 || element == null) {
                for (element2 = hTMLDocument.getDefaultRootElement(); element2 != null && element2.getStartOffset() != n && !element2.isLeaf(); element2 = element2.getElement(element2.getElementIndex(n))) {
                }
                Element element4 = element3 = element2 != null ? element2.getParentElement() : null;
            }
            if (element3 != null) {
                int n2 = 0;
                int n3 = 0;
                if (n == 0 && element != null) {
                    element2 = element3;
                    while (element2 != null && !element2.isLeaf()) {
                        element2 = element2.getElement(element2.getElementIndex(n));
                        ++n2;
                    }
                } else {
                    element2 = element3;
                    --n;
                    while (element2 != null && !element2.isLeaf()) {
                        element2 = element2.getElement(element2.getElementIndex(n));
                        ++n2;
                    }
                    element2 = element3;
                    ++n;
                    while (element2 != null && element2 != element) {
                        element2 = element2.getElement(element2.getElementIndex(n));
                        ++n3;
                    }
                }
                n2 = Math.max(0, n2 - 1);
                this.insertHTML(jEditorPane, hTMLDocument, n, string, n2, n3, tag2);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                HTMLDocument hTMLDocument = this.getHTMLDocument(jEditorPane);
                int n = jEditorPane.getSelectionStart();
                int n2 = hTMLDocument.getLength();
                boolean bl = true;
                if (!this.tryInsert(jEditorPane, hTMLDocument, n, this.parentTag, this.addTag)) {
                    bl = this.tryInsert(jEditorPane, hTMLDocument, n, this.alternateParentTag, this.alternateAddTag);
                }
                if (bl) {
                    this.adjustSelection(jEditorPane, hTMLDocument, n, n2);
                }
            }
        }

        private boolean tryInsert(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, HTML.Tag tag, HTML.Tag tag2) {
            int n2;
            boolean bl = false;
            Element element = this.findElementMatchingTag(hTMLDocument, n, tag);
            if (element != null && element.getStartOffset() == n) {
                this.insertAtBoundary(jEditorPane, hTMLDocument, n, element, this.html, tag, tag2);
                bl = true;
            } else if (n > 0 && (n2 = this.elementCountToTag(hTMLDocument, n - 1, tag)) != -1) {
                this.insertHTML(jEditorPane, hTMLDocument, n, this.html, n2, 0, tag2);
                bl = true;
            }
            return bl;
        }

        private void adjustSelection(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, int n2) {
            int n3 = hTMLDocument.getLength();
            if (n3 != n2 && n < n3) {
                if (n > 0) {
                    String string;
                    try {
                        string = hTMLDocument.getText(n - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        string = null;
                    }
                    if (string != null && string.length() > 0 && string.charAt(0) == '\n') {
                        jEditorPane.select(n, n);
                    } else {
                        jEditorPane.select(n + 1, n + 1);
                    }
                } else {
                    jEditorPane.select(1, 1);
                }
            }
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private Element lastAnchorElement;

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEditable() && SwingUtilities.isLeftMouseButton(mouseEvent) && (n = jEditorPane.viewToModel(point = mouseEvent.getPoint())) >= 0) {
                this.activateLink(n, jEditorPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Document document;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            if (!jEditorPane.isEditable() && (document = jEditorPane.getDocument()) instanceof HTMLDocument) {
                Element element;
                Cursor cursor = hTMLEditorKit.getDefaultCursor();
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Point point = mouseEvent.getPoint();
                int n = jEditorPane.viewToModel(point);
                if (n < (element = hTMLDocument.getCharacterElement(n)).getStartOffset() || n >= element.getEndOffset()) {
                    element = null;
                }
                if (element != null) {
                    AttributeSet attributeSet = (AttributeSet)element.getAttributes().getAttribute(HTML.Tag.A);
                    if (attributeSet != null) {
                        if (element != this.lastAnchorElement) {
                            if (this.lastAnchorElement != null) {
                                hTMLDocument.updateSpecialClass(this.lastAnchorElement, HTML.Attribute.DYNAMIC_CLASS, null);
                            }
                            this.lastAnchorElement = element;
                            hTMLDocument.updateSpecialClass(element, HTML.Attribute.DYNAMIC_CLASS, "hover");
                        }
                        cursor = hTMLEditorKit.getLinkCursor();
                    } else {
                        if (this.lastAnchorElement != null) {
                            hTMLDocument.updateSpecialClass(this.lastAnchorElement, HTML.Attribute.DYNAMIC_CLASS, null);
                        }
                        this.lastAnchorElement = null;
                    }
                } else {
                    if (this.lastAnchorElement != null) {
                        hTMLDocument.updateSpecialClass(this.lastAnchorElement, HTML.Attribute.DYNAMIC_CLASS, null);
                    }
                    this.lastAnchorElement = null;
                }
                if (jEditorPane.getCursor() != cursor) {
                    jEditorPane.setCursor(cursor);
                }
            }
        }

        protected void activateLink(int n, JEditorPane jEditorPane) {
            this.activateLink(n, jEditorPane);
        }

        private void activateLink(int n, JEditorPane jEditorPane, int n2, int n3) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getCharacterElement(n);
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                String string = null;
                if (attributeSet2 != null) {
                    string = (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
                    hTMLDocument.updateSpecialClass(element, HTML.Attribute.PSEUDO_CLASS, "visited");
                }
                HyperlinkEvent hyperlinkEvent = null;
                if (string != null) {
                    hyperlinkEvent = this.createHyperlinkEvent(jEditorPane, hTMLDocument, string, attributeSet2, element);
                }
                if (hyperlinkEvent != null) {
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                }
            }
        }

        private HyperlinkEvent createHyperlinkEvent(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string, AttributeSet attributeSet, Element element) {
            URL uRL;
            Serializable serializable;
            try {
                serializable = hTMLDocument.getBase();
                uRL = new URL((URL)serializable, string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            if (hTMLDocument.isFrameDocument()) {
                String string2 = null;
                if (attributeSet != null) {
                    string2 = (String)attributeSet.getAttribute(HTML.Attribute.TARGET);
                }
                if (string2 == null || string2.equals("")) {
                    string2 = hTMLDocument.getBaseTarget();
                }
                if (string2 == null || string2.equals("")) {
                    string2 = "_self";
                }
                serializable = new HTMLFrameHyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, element, string2);
            } else {
                serializable = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, element);
            }
            return serializable;
        }
    }
}

