/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class FrameView
extends ComponentView
implements HyperlinkListener {
    FrameView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.addHyperlinkListener(this);
        URL uRL = ((HTMLDocument)element.getDocument()).getBase();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
        if (string != null && !string.equals("")) {
            try {
                URL uRL2 = new URL(uRL, string);
                jEditorPane.setPage(uRL2);
                ((HTMLDocument)jEditorPane.getDocument()).setFrameDocument(true);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jEditorPane;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        JEditorPane jEditorPane = this.getTopEditorPane();
        if (jEditorPane != null) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                if (hTMLFrameHyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hTMLFrameHyperlinkEvent.getTarget();
                    if (hyperlinkEvent instanceof FormSubmitEvent) {
                        this.handleFormSubmitEvent(hTMLFrameHyperlinkEvent, jEditorPane, string);
                    } else {
                        this.handleHyperlinkEvent(hTMLFrameHyperlinkEvent, jEditorPane, string);
                    }
                }
            } else {
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
        }
    }

    private void handleHyperlinkEvent(HyperlinkEvent hyperlinkEvent, JEditorPane jEditorPane, String string) {
        if (string.equals("_top")) {
            try {
                jEditorPane.setPage(hyperlinkEvent.getURL());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!jEditorPane.isEditable()) {
            jEditorPane.fireHyperlinkUpdate(new HTMLFrameHyperlinkEvent(jEditorPane, hyperlinkEvent.getEventType(), hyperlinkEvent.getURL(), hyperlinkEvent.getDescription(), this.getElement(), string));
        }
    }

    private void handleFormSubmitEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent, JEditorPane jEditorPane, String string) {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
        if (hTMLEditorKit != null && hTMLEditorKit.isAutoFormSubmission()) {
            if (string.equals("_top")) {
                try {
                    jEditorPane.setPage(hTMLFrameHyperlinkEvent.getURL());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            }
        } else {
            jEditorPane.fireHyperlinkUpdate(hTMLFrameHyperlinkEvent);
        }
    }

    private JEditorPane getTopEditorPane() {
        View view = this.getParent();
        View view2 = null;
        while (view != null) {
            if (!(view instanceof FrameSetView)) continue;
            view2 = view;
        }
        JEditorPane jEditorPane = null;
        if (view2 != null) {
            jEditorPane = (JEditorPane)view2.getContainer();
        }
        return jEditorPane;
    }
}

