/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.Option;
import javax.swing.text.html.ResetableModel;
import javax.swing.text.html.ResetableToggleButtonModel;
import javax.swing.text.html.SelectComboBoxModel;
import javax.swing.text.html.SelectListModel;

public class FormView
extends ComponentView
implements ActionListener {
    public static final String SUBMIT = UIManager.getString("FormView.submitButtonText");
    public static final String RESET = UIManager.getString("FormView.resetButtonText");
    private boolean maxIsPreferred;

    public FormView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        JComponent jComponent = null;
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        Object object2 = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (object.equals(HTML.Tag.INPUT)) {
            String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
            if (string.equals("button")) {
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                JButton jButton = new JButton(string2);
                if (object2 != null) {
                    jButton.setModel((ButtonModel)object2);
                    jButton.addActionListener(this);
                }
                jComponent = jButton;
                this.maxIsPreferred = true;
            } else if (string.equals("checkbox")) {
                if (object2 instanceof ResetableToggleButtonModel) {
                    ResetableToggleButtonModel resetableToggleButtonModel = (ResetableToggleButtonModel)object2;
                    JCheckBox jCheckBox = new JCheckBox();
                    jCheckBox.setModel(resetableToggleButtonModel);
                    jComponent = jCheckBox;
                    this.maxIsPreferred = true;
                }
            } else if (string.equals("image")) {
                JButton jButton;
                String string3 = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
                try {
                    URL uRL = ((HTMLDocument)element.getDocument()).getBase();
                    URL uRL2 = new URL(uRL, string3);
                    ImageIcon imageIcon = new ImageIcon(uRL2);
                    jButton = new JButton(imageIcon);
                }
                catch (MalformedURLException malformedURLException) {
                    jButton = new JButton(string3);
                }
                if (object2 != null) {
                    jButton.setModel((ButtonModel)object2);
                    jButton.addActionListener(this);
                }
                jComponent = jButton;
                this.maxIsPreferred = true;
            } else if (string.equals("password")) {
                int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1);
                JPasswordField jPasswordField = new JPasswordField();
                if (n > 0) {
                    jPasswordField.setColumns(n);
                } else {
                    jPasswordField.setColumns(20);
                }
                if (object2 != null) {
                    jPasswordField.setDocument((Document)object2);
                }
                jPasswordField.addActionListener(this);
                jComponent = jPasswordField;
                this.maxIsPreferred = true;
            } else if (string.equals("radio")) {
                if (object2 instanceof ResetableToggleButtonModel) {
                    ResetableToggleButtonModel resetableToggleButtonModel = (ResetableToggleButtonModel)object2;
                    JRadioButton jRadioButton = new JRadioButton();
                    jRadioButton.setModel(resetableToggleButtonModel);
                    jComponent = jRadioButton;
                    this.maxIsPreferred = true;
                }
            } else if (string.equals("reset")) {
                String string4 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                if (string4 == null) {
                    string4 = UIManager.getString("FormView.resetButtonText");
                }
                JButton jButton = new JButton(string4);
                if (object2 != null) {
                    jButton.setModel((ButtonModel)object2);
                    jButton.addActionListener(this);
                }
                jComponent = jButton;
                this.maxIsPreferred = true;
            } else if (string.equals("submit")) {
                String string5 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
                if (string5 == null) {
                    string5 = UIManager.getString("FormView.submitButtonText");
                }
                JButton jButton = new JButton(string5);
                if (object2 != null) {
                    jButton.setModel((ButtonModel)object2);
                    jButton.addActionListener(this);
                }
                jComponent = jButton;
                this.maxIsPreferred = true;
            } else if (string.equals("text")) {
                int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1);
                JTextField jTextField = new JTextField();
                if (n > 0) {
                    jTextField.setColumns(n);
                } else {
                    jTextField.setColumns(20);
                }
                if (object2 != null) {
                    jTextField.setDocument((Document)object2);
                }
                jTextField.addActionListener(this);
                jComponent = jTextField;
                this.maxIsPreferred = true;
            }
        } else if (object == HTML.Tag.TEXTAREA) {
            JTextArea jTextArea = new JTextArea((Document)object2);
            int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.ROWS, 1);
            jTextArea.setRows(n);
            int n2 = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.COLS, 20);
            jTextArea.setColumns(n2);
            this.maxIsPreferred = true;
            jComponent = new JScrollPane(jTextArea, 22, 32);
        } else if (object == HTML.Tag.SELECT) {
            if (object2 instanceof SelectListModel) {
                SelectListModel selectListModel = (SelectListModel)object2;
                JList jList = new JList(selectListModel);
                int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, 1);
                jList.setVisibleRowCount(n);
                jList.setSelectionModel(selectListModel.getSelectionModel());
                jComponent = new JScrollPane(jList);
            } else if (object2 instanceof SelectComboBoxModel) {
                SelectComboBoxModel selectComboBoxModel = (SelectComboBoxModel)object2;
                jComponent = new JComboBox(selectComboBoxModel);
            }
            this.maxIsPreferred = true;
        }
        return jComponent;
    }

    public float getMaximumSpan(int n) {
        float f = this.maxIsPreferred ? this.getPreferredSpan(n) : super.getMaximumSpan(n);
        return f;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Element element = this.getElement();
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object.equals(HTML.Tag.INPUT)) {
            AttributeSet attributeSet = element.getAttributes();
            String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
            if (string.equals("submit")) {
                this.submitData(this.getFormData());
            } else if (string.equals("reset")) {
                this.resetForm();
            }
        }
    }

    protected void submitData(String string) {
        SubmitThread submitThread = new SubmitThread(string);
        submitThread.start();
    }

    protected void imageSubmit(String string) {
    }

    String getImageData(Point point) {
        String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
        String string2 = string == null || string.equals("") ? "x=" + point.x + "&y=" + point.y : string + ".x=" + point.x + "&" + string + ".y=" + point.y;
        return string2;
    }

    Element getFormElement() {
        Element element = null;
        Element element2 = this.getElement();
        while (element2 != null && element == null) {
            AttributeSet attributeSet = element2.getAttributes();
            if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.FORM) {
                element = element2;
                continue;
            }
            element2 = element2.getParentElement();
        }
        return element;
    }

    private String getFormData() {
        Element element = this.getFormElement();
        StringBuilder stringBuilder = new StringBuilder();
        if (element != null) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                AttributeSet attributeSet;
                String string;
                if (!element2.isLeaf() || (string = (String)(attributeSet = element2.getAttributes()).getAttribute(HTML.Attribute.TYPE)) != null && string.equals("submit") && element2 != this.getElement() || string != null && string.equals("image")) continue;
                this.getElementFormData(element2, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    private void getElementFormData(Element element, StringBuilder stringBuilder) {
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string != null) {
            String string2 = null;
            HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (tag == HTML.Tag.SELECT) {
                this.getSelectData(attributeSet, stringBuilder);
            } else {
                if (tag == HTML.Tag.INPUT) {
                    string2 = this.getInputFormData(attributeSet);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    string2 = this.getTextAreaData(attributeSet);
                }
                if (string != null && string2 != null) {
                    this.addData(stringBuilder, string, string2);
                }
            }
        }
    }

    private void getSelectData(AttributeSet attributeSet, StringBuilder stringBuilder) {
        String string = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
        if (string != null) {
            SelectComboBoxModel selectComboBoxModel;
            Option option;
            Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
            if (object instanceof SelectListModel) {
                SelectListModel selectListModel = (SelectListModel)object;
                ListSelectionModel listSelectionModel = selectListModel.getSelectionModel();
                for (int i = 0; i < selectListModel.getSize(); ++i) {
                    if (!listSelectionModel.isSelectedIndex(i)) continue;
                    Option option2 = (Option)selectListModel.getElementAt(i);
                    this.addData(stringBuilder, string, option2.getValue());
                }
            } else if (object instanceof SelectComboBoxModel && (option = (Option)(selectComboBoxModel = (SelectComboBoxModel)object).getSelectedItem()) != null) {
                this.addData(stringBuilder, string, option.getValue());
            }
        }
    }

    private String getTextAreaData(AttributeSet attributeSet) {
        String string;
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    private String getInputFormData(AttributeSet attributeSet) {
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        String string2 = null;
        if (string.equals("text") || string.equals("password")) {
            Document document = (Document)object;
            try {
                string2 = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                assert (false);
            }
        } else if ((string.equals("hidden") || string.equals("submit")) && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) == null) {
            string2 = "";
        }
        return string2;
    }

    private void addData(StringBuilder stringBuilder, String string, String string2) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append('&');
        }
        String string3 = URLEncoder.encode(string);
        stringBuilder.append(string3);
        stringBuilder.append('=');
        String string4 = URLEncoder.encode(string2);
        stringBuilder.append(string4);
    }

    private void resetForm() {
        Element element = this.getFormElement();
        if (element != null) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                AttributeSet attributeSet;
                Object object;
                if (!element2.isLeaf() || !((object = (attributeSet = element2.getAttributes()).getAttribute(StyleConstants.ModelAttribute)) instanceof ResetableModel)) continue;
                ((ResetableModel)object).reset();
            }
        }
    }

    private class SubmitThread
    extends Thread {
        private String data;

        SubmitThread(String string) {
            this.data = string;
        }

        public void run() {
            if (this.data.length() > 0) {
                final String string = this.getMethod();
                final URL uRL = this.getActionURL();
                final String string2 = this.getTarget();
                final JEditorPane jEditorPane = (JEditorPane)FormView.this.getContainer();
                final HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
                if (hTMLEditorKit.isAutoFormSubmission()) {
                    try {
                        URL uRL2;
                        if (string != null && string.equals("post")) {
                            uRL2 = uRL;
                            URLConnection uRLConnection = uRL2.openConnection();
                            this.postData(uRLConnection, this.data);
                        } else {
                            uRL2 = new URL(uRL + "?" + this.data);
                        }
                        Runnable runnable = new Runnable(){

                            public void run() {
                                if (hTMLDocument.isFrameDocument()) {
                                    jEditorPane.fireHyperlinkUpdate(SubmitThread.this.createSubmitEvent(string, uRL, string2));
                                } else {
                                    try {
                                        jEditorPane.setPage(uRL2);
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    jEditorPane.fireHyperlinkUpdate(this.createSubmitEvent(string, uRL, string2));
                }
            }
        }

        private String getMethod() {
            AttributeSet attributeSet = this.getFormAttributes();
            String string = null;
            if (attributeSet != null) {
                string = (String)attributeSet.getAttribute(HTML.Attribute.METHOD);
            }
            return string;
        }

        private URL getActionURL() {
            String string;
            AttributeSet attributeSet = this.getFormAttributes();
            HTMLDocument hTMLDocument = (HTMLDocument)FormView.this.getElement().getDocument();
            URL uRL = hTMLDocument.getBase();
            if (attributeSet != null && (string = (String)attributeSet.getAttribute(HTML.Attribute.ACTION)) != null) {
                try {
                    uRL = new URL(uRL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            return uRL;
        }

        private String getTarget() {
            AttributeSet attributeSet = this.getFormAttributes();
            String string = null;
            if (attributeSet != null && (string = (String)attributeSet.getAttribute(HTML.Attribute.TARGET)) != null) {
                string = string.toLowerCase();
            }
            if (string == null) {
                string = "_self";
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postData(URLConnection uRLConnection, String string) {
            uRLConnection.setDoOutput(true);
            PrintWriter printWriter = null;
            try {
                try {
                    printWriter = new PrintWriter(new OutputStreamWriter(uRLConnection.getOutputStream()));
                    printWriter.print(string);
                    printWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var6_5 = null;
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                Object var6_4 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }

        private AttributeSet getFormAttributes() {
            AttributeSet attributeSet = null;
            Element element = FormView.this.getFormElement();
            if (element != null) {
                attributeSet = element.getAttributes();
            }
            return attributeSet;
        }

        FormSubmitEvent createSubmitEvent(String string, URL uRL, String string2) {
            FormSubmitEvent.MethodType methodType = "post".equals(string) ? FormSubmitEvent.MethodType.POST : FormSubmitEvent.MethodType.GET;
            return new FormSubmitEvent(FormView.this, HyperlinkEvent.EventType.ACTIVATED, uRL, FormView.this.getElement(), string2, methodType, this.data);
        }
    }

    protected class MouseEventListener
    extends MouseAdapter {
        protected MouseEventListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            String string = FormView.this.getImageData(mouseEvent.getPoint());
            FormView.this.imageSubmit(string);
        }
    }
}

