/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.BorderWidth;
import gnu.javax.swing.text.html.css.CSSColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;

class CSSBorder
implements Border {
    private static final int STYLE_NOT_SET = -1;
    private static final int STYLE_NONE = 0;
    private static final int STYLE_HIDDEN = 1;
    private static final int STYLE_DOTTED = 2;
    private static final int STYLE_DASHED = 3;
    private static final int STYLE_SOLID = 4;
    private static final int STYLE_DOUBLE = 5;
    private static final int STYLE_GROOVE = 6;
    private static final int STYLE_RIDGE = 7;
    private static final int STYLE_INSET = 8;
    private static final int STYLE_OUTSET = 9;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int leftStyle;
    private int rightStyle;
    private int topStyle;
    private Color topColor;
    private Color bottomColor;
    private Color leftColor;
    private Color rightColor;
    private int bottomStyle;

    CSSBorder(AttributeSet attributeSet, StyleSheet styleSheet) {
        int n;
        Color color;
        int n2 = this.getBorderStyle(attributeSet, CSS.Attribute.BORDER_STYLE);
        if (n2 == -1) {
            n2 = 0;
        }
        this.leftStyle = this.rightStyle = n2;
        this.bottomStyle = this.rightStyle;
        this.topStyle = this.rightStyle;
        n2 = this.getBorderStyle(attributeSet, CSS.Attribute.BORDER_TOP_STYLE);
        if (n2 != -1) {
            this.topStyle = n2;
        }
        if ((n2 = this.getBorderStyle(attributeSet, CSS.Attribute.BORDER_BOTTOM_STYLE)) != -1) {
            this.bottomStyle = n2;
        }
        if ((n2 = this.getBorderStyle(attributeSet, CSS.Attribute.BORDER_LEFT_STYLE)) != -1) {
            this.leftStyle = n2;
        }
        if ((n2 = this.getBorderStyle(attributeSet, CSS.Attribute.BORDER_RIGHT_STYLE)) != -1) {
            this.rightStyle = n2;
        }
        if ((color = this.getBorderColor(attributeSet, CSS.Attribute.BORDER_COLOR)) == null) {
            color = Color.BLACK;
        }
        this.leftColor = this.rightColor = color;
        this.bottomColor = this.rightColor;
        this.topColor = this.rightColor;
        color = this.getBorderColor(attributeSet, CSS.Attribute.BORDER_TOP_COLOR);
        if (color != null) {
            this.topColor = color;
        }
        if ((color = this.getBorderColor(attributeSet, CSS.Attribute.BORDER_BOTTOM_COLOR)) != null) {
            this.bottomColor = color;
        }
        if ((color = this.getBorderColor(attributeSet, CSS.Attribute.BORDER_LEFT_COLOR)) != null) {
            this.leftColor = color;
        }
        if ((color = this.getBorderColor(attributeSet, CSS.Attribute.BORDER_RIGHT_COLOR)) != null) {
            this.rightColor = color;
        }
        if ((n = this.getBorderWidth(attributeSet, CSS.Attribute.BORDER_WIDTH, styleSheet)) == -1) {
            n = 0;
        }
        this.left = this.right = n;
        this.bottom = this.right;
        this.top = this.right;
        n = this.getBorderWidth(attributeSet, CSS.Attribute.BORDER_TOP_WIDTH, styleSheet);
        if (n >= 0) {
            this.top = n;
        }
        if ((n = this.getBorderWidth(attributeSet, CSS.Attribute.BORDER_BOTTOM_WIDTH, styleSheet)) >= 0) {
            this.bottom = n;
        }
        if ((n = this.getBorderWidth(attributeSet, CSS.Attribute.BORDER_LEFT_WIDTH, styleSheet)) >= 0) {
            this.left = n;
        }
        if ((n = this.getBorderWidth(attributeSet, CSS.Attribute.BORDER_RIGHT_WIDTH, styleSheet)) >= 0) {
            this.right = n;
        }
    }

    private int getBorderStyle(AttributeSet attributeSet, CSS.Attribute attribute) {
        int n = -1;
        Object object = attributeSet.getAttribute(attribute);
        if (object != null) {
            String string = object.toString();
            if (string.equals("none")) {
                n = 0;
            } else if (string.equals("hidden")) {
                n = 1;
            } else if (string.equals("dotted")) {
                n = 2;
            } else if (string.equals("dashed")) {
                n = 3;
            } else if (string.equals("solid")) {
                n = 4;
            } else if (string.equals("double")) {
                n = 5;
            } else if (string.equals("groove")) {
                n = 6;
            } else if (string.equals("ridge")) {
                n = 7;
            } else if (string.equals("inset")) {
                n = 8;
            } else if (string.equals("outset")) {
                n = 9;
            }
        }
        return n;
    }

    private Color getBorderColor(AttributeSet attributeSet, CSS.Attribute attribute) {
        Object object = attributeSet.getAttribute(attribute);
        Color color = null;
        if (object instanceof CSSColor) {
            CSSColor cSSColor = (CSSColor)object;
            color = cSSColor.getValue();
        }
        return color;
    }

    private int getBorderWidth(AttributeSet attributeSet, CSS.Attribute attribute, StyleSheet styleSheet) {
        int n = -1;
        Object object = attributeSet.getAttribute(attribute);
        if (object instanceof BorderWidth) {
            BorderWidth borderWidth = (BorderWidth)object;
            borderWidth.setFontBases(styleSheet.getEMBase(attributeSet), styleSheet.getEXBase(attributeSet));
            n = (int)((BorderWidth)object).getValue();
        }
        return n;
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorderLine(graphics, n, n2 + this.top / 2, n + n3, n2 + this.top / 2, this.topStyle, this.top, this.topColor, false);
        this.paintBorderLine(graphics, n + this.left / 2, n2, n + this.left / 2, n2 + n4, this.leftStyle, this.left, this.leftColor, true);
        this.paintBorderLine(graphics, n, n2 + n4 - this.bottom / 2, n + n3, n2 + n4 - this.bottom / 2, this.topStyle, this.bottom, this.bottomColor, false);
        this.paintBorderLine(graphics, n + n3 - this.right / 2, n2, n + n3 - this.right / 2, n2 + n4, this.topStyle, this.right, this.rightColor, true);
    }

    private void paintBorderLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, boolean bl) {
        switch (n5) {
            case 2: {
                this.paintDottedLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 3: {
                this.paintDashedLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 4: {
                this.paintSolidLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 5: {
                this.paintDoubleLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 6: {
                this.paintGrooveLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 7: {
                this.paintRidgeLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 9: {
                this.paintOutsetLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
            case 8: {
                this.paintInsetLine(graphics, n, n2, n3, n4, n6, color, bl);
                break;
            }
        }
    }

    private void paintDottedLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }

    private void paintDashedLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }

    private void paintSolidLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        int n6 = Math.min(n, n3);
        int n7 = Math.min(n2, n2);
        int n8 = Math.abs(n3 - n);
        int n9 = Math.abs(n4 - n2);
        if (bl) {
            n8 = n5;
            n6 -= n5 / 2;
        } else {
            n9 = n5;
            n7 -= n5 / 2;
        }
        graphics.setColor(color);
        graphics.fillRect(n6, n7, n8, n9);
    }

    private void paintDoubleLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }

    private void paintGrooveLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }

    private void paintRidgeLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }

    private void paintOutsetLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }

    private void paintInsetLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.paintSolidLine(graphics, n, n2, n3, n4, n5, color, bl);
    }
}

