/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.BorderStyle;
import gnu.javax.swing.text.html.css.BorderWidth;
import gnu.javax.swing.text.html.css.CSSColor;
import gnu.javax.swing.text.html.css.FontSize;
import gnu.javax.swing.text.html.css.FontStyle;
import gnu.javax.swing.text.html.css.FontWeight;
import gnu.javax.swing.text.html.css.Length;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;

public class CSS
implements Serializable {
    public static Attribute[] getAllAttributeKeys() {
        Object[] objectArray = Attribute.attributeMap.values().toArray();
        Attribute[] attributeArray = new Attribute[objectArray.length];
        System.arraycopy(objectArray, 0, attributeArray, 0, objectArray.length);
        return attributeArray;
    }

    public static Attribute getAttribute(String string) {
        return (Attribute)Attribute.attributeMap.get(string);
    }

    static Object getValue(Attribute attribute, String string) {
        Object object = attribute == Attribute.FONT_SIZE ? new FontSize(string) : (attribute == Attribute.FONT_WEIGHT ? new FontWeight(string) : (attribute == Attribute.FONT_STYLE ? new FontStyle(string) : (attribute == Attribute.COLOR || attribute == Attribute.BACKGROUND_COLOR || attribute == Attribute.BORDER_COLOR || attribute == Attribute.BORDER_TOP_COLOR || attribute == Attribute.BORDER_BOTTOM_COLOR || attribute == Attribute.BORDER_LEFT_COLOR || attribute == Attribute.BORDER_RIGHT_COLOR ? new CSSColor(string) : (attribute == Attribute.MARGIN || attribute == Attribute.MARGIN_BOTTOM || attribute == Attribute.MARGIN_LEFT || attribute == Attribute.MARGIN_RIGHT || attribute == Attribute.MARGIN_TOP || attribute == Attribute.WIDTH || attribute == Attribute.HEIGHT || attribute == Attribute.PADDING || attribute == Attribute.PADDING_BOTTOM || attribute == Attribute.PADDING_LEFT || attribute == Attribute.PADDING_RIGHT || attribute == Attribute.PADDING_TOP || attribute == Attribute.LEFT || attribute == Attribute.RIGHT || attribute == Attribute.TOP || attribute == Attribute.BOTTOM ? new Length(string) : (attribute == Attribute.BORDER_WIDTH || attribute == Attribute.BORDER_TOP_WIDTH || attribute == Attribute.BORDER_LEFT_WIDTH || attribute == Attribute.BORDER_RIGHT_WIDTH || attribute == Attribute.BORDER_BOTTOM_WIDTH ? new BorderWidth(string) : string)))));
        return object;
    }

    static void addInternal(MutableAttributeSet mutableAttributeSet, Attribute attribute, String string) {
        if (attribute == Attribute.BACKGROUND) {
            CSS.parseBackgroundShorthand(mutableAttributeSet, string);
        } else if (attribute == Attribute.PADDING) {
            CSS.parsePaddingShorthand(mutableAttributeSet, string);
        } else if (attribute == Attribute.MARGIN) {
            CSS.parseMarginShorthand(mutableAttributeSet, string);
        } else if (attribute == Attribute.BORDER || attribute == Attribute.BORDER_LEFT || attribute == Attribute.BORDER_RIGHT || attribute == Attribute.BORDER_TOP || attribute == Attribute.BORDER_BOTTOM) {
            CSS.parseBorderShorthand(mutableAttributeSet, string, attribute);
        }
    }

    private static void parseBackgroundShorthand(MutableAttributeSet mutableAttributeSet, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (!CSSColor.isValidColor(string2)) continue;
            mutableAttributeSet.addAttribute(Attribute.BACKGROUND_COLOR, new CSSColor(string2));
        }
    }

    private static void parsePaddingShorthand(MutableAttributeSet mutableAttributeSet, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            Length length = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_LEFT, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_RIGHT, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_TOP, length);
        } else if (n == 2) {
            Length length = new Length(stringTokenizer.nextToken());
            Length length2 = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_TOP, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_LEFT, length2);
            mutableAttributeSet.addAttribute(Attribute.PADDING_RIGHT, length2);
        } else if (n == 3) {
            Length length = new Length(stringTokenizer.nextToken());
            Length length3 = new Length(stringTokenizer.nextToken());
            Length length4 = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.PADDING_TOP, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_LEFT, length3);
            mutableAttributeSet.addAttribute(Attribute.PADDING_RIGHT, length3);
            mutableAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, length4);
        } else {
            Length length = new Length(stringTokenizer.nextToken());
            Length length5 = new Length(stringTokenizer.nextToken());
            Length length6 = new Length(stringTokenizer.nextToken());
            Length length7 = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.PADDING_TOP, length);
            mutableAttributeSet.addAttribute(Attribute.PADDING_RIGHT, length5);
            mutableAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, length6);
            mutableAttributeSet.addAttribute(Attribute.PADDING_LEFT, length7);
        }
    }

    private static void parseMarginShorthand(MutableAttributeSet mutableAttributeSet, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            Length length = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.MARGIN_BOTTOM, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_LEFT, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_RIGHT, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_TOP, length);
        } else if (n == 2) {
            Length length = new Length(stringTokenizer.nextToken());
            Length length2 = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.MARGIN_BOTTOM, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_TOP, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_LEFT, length2);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_RIGHT, length2);
        } else if (n == 3) {
            Length length = new Length(stringTokenizer.nextToken());
            Length length3 = new Length(stringTokenizer.nextToken());
            Length length4 = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.MARGIN_TOP, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_LEFT, length3);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_RIGHT, length3);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_BOTTOM, length4);
        } else {
            Length length = new Length(stringTokenizer.nextToken());
            Length length5 = new Length(stringTokenizer.nextToken());
            Length length6 = new Length(stringTokenizer.nextToken());
            Length length7 = new Length(stringTokenizer.nextToken());
            mutableAttributeSet.addAttribute(Attribute.MARGIN_TOP, length);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_RIGHT, length5);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_BOTTOM, length6);
            mutableAttributeSet.addAttribute(Attribute.MARGIN_LEFT, length7);
        }
    }

    private static void parseBorderShorthand(MutableAttributeSet mutableAttributeSet, String string, Attribute attribute) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (BorderStyle.isValidStyle(string2)) {
                if (attribute == Attribute.BORDER_LEFT || attribute == Attribute.BORDER) {
                    mutableAttributeSet.addAttribute(Attribute.BORDER_LEFT_STYLE, string2);
                }
                if (attribute == Attribute.BORDER_RIGHT || attribute == Attribute.BORDER) {
                    mutableAttributeSet.addAttribute(Attribute.BORDER_RIGHT_STYLE, string2);
                }
                if (attribute == Attribute.BORDER_BOTTOM || attribute == Attribute.BORDER) {
                    mutableAttributeSet.addAttribute(Attribute.BORDER_BOTTOM_STYLE, string2);
                }
                if (attribute != Attribute.BORDER_TOP && attribute != Attribute.BORDER) continue;
                mutableAttributeSet.addAttribute(Attribute.BORDER_TOP_STYLE, string2);
                continue;
            }
            if (BorderWidth.isValid(string2)) {
                object = new BorderWidth(string2);
                if (attribute == Attribute.BORDER_LEFT || attribute == Attribute.BORDER) {
                    mutableAttributeSet.addAttribute(Attribute.BORDER_LEFT_WIDTH, object);
                }
                if (attribute == Attribute.BORDER_RIGHT || attribute == Attribute.BORDER) {
                    mutableAttributeSet.addAttribute(Attribute.BORDER_RIGHT_WIDTH, object);
                }
                if (attribute == Attribute.BORDER_BOTTOM || attribute == Attribute.BORDER) {
                    mutableAttributeSet.addAttribute(Attribute.BORDER_BOTTOM_WIDTH, object);
                }
                if (attribute != Attribute.BORDER_TOP && attribute != Attribute.BORDER) continue;
                mutableAttributeSet.addAttribute(Attribute.BORDER_TOP_WIDTH, object);
                continue;
            }
            if (!CSSColor.isValidColor(string2)) continue;
            object = new CSSColor(string2);
            if (attribute == Attribute.BORDER_LEFT || attribute == Attribute.BORDER) {
                mutableAttributeSet.addAttribute(Attribute.BORDER_LEFT_COLOR, object);
            }
            if (attribute == Attribute.BORDER_RIGHT || attribute == Attribute.BORDER) {
                mutableAttributeSet.addAttribute(Attribute.BORDER_RIGHT_COLOR, object);
            }
            if (attribute == Attribute.BORDER_BOTTOM || attribute == Attribute.BORDER) {
                mutableAttributeSet.addAttribute(Attribute.BORDER_BOTTOM_COLOR, object);
            }
            if (attribute != Attribute.BORDER_TOP && attribute != Attribute.BORDER) continue;
            mutableAttributeSet.addAttribute(Attribute.BORDER_TOP_COLOR, object);
        }
    }

    public static final class Attribute {
        public static final Attribute BACKGROUND = new Attribute("background", false, null);
        public static final Attribute BACKGROUND_ATTACHMENT = new Attribute("background-attachment", false, "scroll");
        public static final Attribute BACKGROUND_COLOR = new Attribute("background-color", false, "transparent");
        public static final Attribute BACKGROUND_IMAGE = new Attribute("background-image", false, "none");
        public static final Attribute BACKGROUND_POSITION = new Attribute("background-position", false, null);
        public static final Attribute BACKGROUND_REPEAT = new Attribute("background-repeat", false, "repeat");
        public static final Attribute BORDER = new Attribute("border", false, null);
        public static final Attribute BORDER_BOTTOM = new Attribute("border-bottom", false, null);
        public static final Attribute BORDER_BOTTOM_WIDTH = new Attribute("border-bottom-width", false, "medium");
        public static final Attribute BORDER_COLOR = new Attribute("border-color", false, "black");
        public static final Attribute BORDER_LEFT = new Attribute("border-left", false, null);
        public static final Attribute BORDER_LEFT_WIDTH = new Attribute("border-left-width", false, "medium");
        public static final Attribute BORDER_RIGHT = new Attribute("border-right", false, null);
        public static final Attribute BORDER_RIGHT_WIDTH = new Attribute("border-right-width", false, "medium");
        public static final Attribute BORDER_STYLE = new Attribute("border-style", false, "none");
        public static final Attribute BORDER_TOP = new Attribute("border-top", false, null);
        public static final Attribute BORDER_TOP_WIDTH = new Attribute("border-top-width", false, "medium");
        public static final Attribute BORDER_WIDTH = new Attribute("border-width", false, "medium");
        public static final Attribute CLEAR = new Attribute("clear", false, "none");
        public static final Attribute COLOR = new Attribute("color", true, "black");
        public static final Attribute DISPLAY = new Attribute("display", false, "block");
        public static final Attribute FLOAT = new Attribute("float", false, "none");
        public static final Attribute FONT = new Attribute("font", true, null);
        public static final Attribute FONT_FAMILY = new Attribute("font-family", true, null);
        public static final Attribute FONT_SIZE = new Attribute("font-size", true, "medium");
        public static final Attribute FONT_STYLE = new Attribute("font-style", true, "normal");
        public static final Attribute FONT_VARIANT = new Attribute("font-variant", true, "normal");
        public static final Attribute FONT_WEIGHT = new Attribute("font-weight", true, "normal");
        public static final Attribute HEIGHT = new Attribute("height", false, "auto");
        public static final Attribute LETTER_SPACING = new Attribute("letter-spacing", true, "normal");
        public static final Attribute LINE_HEIGHT = new Attribute("line-height", true, "normal");
        public static final Attribute LIST_STYLE = new Attribute("list-style", true, null);
        public static final Attribute LIST_STYLE_IMAGE = new Attribute("list-style-image", true, "none");
        public static final Attribute LIST_STYLE_POSITION = new Attribute("list-style-position", true, "outside");
        public static final Attribute LIST_STYLE_TYPE = new Attribute("list-style-type", true, "disc");
        public static final Attribute MARGIN = new Attribute("margin", false, null);
        public static final Attribute MARGIN_BOTTOM = new Attribute("margin-bottom", false, "0");
        public static final Attribute MARGIN_LEFT = new Attribute("margin-left", false, "0");
        public static final Attribute MARGIN_RIGHT = new Attribute("margin-right", false, "0");
        public static final Attribute MARGIN_TOP = new Attribute("margin-top", false, "0");
        public static final Attribute PADDING = new Attribute("padding", false, null);
        public static final Attribute PADDING_BOTTOM = new Attribute("padding-bottom", false, "0");
        public static final Attribute PADDING_LEFT = new Attribute("padding-left", false, "0");
        public static final Attribute PADDING_RIGHT = new Attribute("padding-right", false, "0");
        public static final Attribute PADDING_TOP = new Attribute("padding-top", false, "0");
        public static final Attribute TEXT_ALIGN = new Attribute("text-align", true, null);
        public static final Attribute TEXT_DECORATION = new Attribute("text-decoration", true, "none");
        public static final Attribute TEXT_INDENT = new Attribute("text-indent", true, "0");
        public static final Attribute TEXT_TRANSFORM = new Attribute("text-transform", true, "none");
        public static final Attribute VERTICAL_ALIGN = new Attribute("vertical-align", false, "baseline");
        public static final Attribute WHITE_SPACE = new Attribute("white-space", true, "normal");
        public static final Attribute WIDTH = new Attribute("width", false, "auto");
        public static final Attribute WORD_SPACING = new Attribute("word-spacing", true, "normal");
        static final Attribute BORDER_TOP_STYLE = new Attribute("border-top-style", false, null);
        static final Attribute BORDER_BOTTOM_STYLE = new Attribute("border-bottom-style", false, null);
        static final Attribute BORDER_LEFT_STYLE = new Attribute("border-left-style", false, null);
        static final Attribute BORDER_RIGHT_STYLE = new Attribute("border-right-style", false, null);
        static final Attribute BORDER_TOP_COLOR = new Attribute("border-top-color", false, null);
        static final Attribute BORDER_BOTTOM_COLOR = new Attribute("border-bottom-color", false, null);
        static final Attribute BORDER_LEFT_COLOR = new Attribute("border-left-color", false, null);
        static final Attribute BORDER_RIGHT_COLOR = new Attribute("border-right-color", false, null);
        static final Attribute BORDER_SPACING = new Attribute("border-spacing", false, null);
        static final Attribute POSITION = new Attribute("position", false, null);
        static final Attribute LEFT = new Attribute("left", false, null);
        static final Attribute RIGHT = new Attribute("right", false, null);
        static final Attribute TOP = new Attribute("top", false, null);
        static final Attribute BOTTOM = new Attribute("bottom", false, null);
        String attStr;
        boolean isInherited;
        String defaultValue;
        static HashMap attributeMap;

        Attribute(String string, boolean bl, String string2) {
            this.attStr = string;
            this.isInherited = bl;
            this.defaultValue = string2;
            if (attributeMap == null) {
                attributeMap = new HashMap();
            }
            attributeMap.put(string, this);
        }

        public String toString() {
            return this.attStr;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

