/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AsyncBoxView;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    private int maximumZoneSize = 8192;
    private int maxZonesLoaded = 3;
    private LinkedList loadedZones = new LinkedList();

    public ZoneView(Element element, int n) {
        super(element, n);
    }

    public void setMaximumZoneSize(int n) {
        this.maximumZoneSize = n;
    }

    public int getMaximumZoneSize() {
        return this.maximumZoneSize;
    }

    public void setMaxZonesLoaded(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Illegal number of zones");
        }
        this.maxZonesLoaded = n;
        this.unloadOldestZones();
    }

    public int getMaxZonesLoaded() {
        return this.maxZonesLoaded;
    }

    protected void zoneWasLoaded(View view) {
        this.loadedZones.addLast(view);
        this.unloadOldestZones();
    }

    protected void unloadZone(View view) {
        view.removeAll();
    }

    protected boolean isZoneLoaded(View view) {
        return view.getViewCount() > 0;
    }

    protected View createZone(int n, int n2) {
        Position position;
        Position position2;
        block2: {
            Document document = this.getDocument();
            position2 = null;
            position = null;
            try {
                position2 = document.createPosition(n);
                position = document.createPosition(n2);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Must not happen");
            }
        }
        Zone zone = new Zone(this.getElement(), position2, position, this.getAxis());
        return zone;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        this.append(this.createZone(n, n2));
        this.checkZoneAt(n);
    }

    protected int getViewIndexAtPosition(int n) {
        int n2 = -1;
        boolean bl = false;
        if (n >= this.getStartOffset() && n <= this.getEndOffset()) {
            int n3 = this.getViewCount() - 1;
            int n4 = 0;
            n2 = (n3 - n4) / 2 + n4;
            int n5 = 0;
            do {
                View view = this.getView(n2);
                int n6 = view.getStartOffset();
                int n7 = view.getEndOffset();
                if (n >= n6 && n < n7) {
                    bl = true;
                } else if (n < n6) {
                    n3 = n2;
                    n5 = -1;
                } else if (n >= n7) {
                    n4 = n2;
                    n5 = 1;
                }
                if (bl) continue;
                int n8 = (n3 - n4) / 2 + n4;
                n2 = n8 == n2 ? n8 + n5 : n8;
            } while (n3 != n4 && !bl);
        }
        if (!bl) {
            n2 = -1;
        }
        return n2;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        return false;
    }

    private void unloadOldestZones() {
        int n = this.getMaxZonesLoaded();
        while (this.loadedZones.size() > n) {
            View view = (View)this.loadedZones.removeFirst();
            this.unloadZone(view);
        }
    }

    private void checkZoneAt(int n) {
        int n2 = this.getViewIndexAtPosition(n);
        View view = this.getView(n2);
        int n3 = view.getStartOffset();
        int n4 = view.getEndOffset();
        if (n4 - n3 > this.maximumZoneSize) {
            this.splitZone(n2, n3, n4);
        }
    }

    private void splitZone(int n, int n2, int n3) {
        ArrayList<View> arrayList = new ArrayList<View>();
        int n4 = n2;
        do {
            n2 = n4;
            n4 = Math.min(this.getPreferredZoneEnd(n2), n3);
            arrayList.add(this.createZone(n2, n4));
        } while (n4 < n3);
        View[] viewArray = new View[arrayList.size()];
        viewArray = arrayList.toArray(viewArray);
        this.replace(n, 1, viewArray);
    }

    private int getPreferredZoneEnd(int n) {
        int n2;
        Element element = this.getElement();
        int n3 = element.getElementIndex(n + this.maximumZoneSize / 2);
        Element element2 = element.getElement(n3);
        int n4 = element2.getStartOffset();
        int n5 = n2 = element2.getEndOffset();
        if (n4 - n > this.maximumZoneSize && n4 > n) {
            n5 = n4;
        }
        return n5;
    }

    static class Zone
    extends AsyncBoxView {
        private Position p0;
        private Position p1;

        Zone(Element element, Position position, Position position2, int n) {
            super(element, n);
            this.p0 = position;
            this.p1 = position2;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }
    }
}

