/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    FontMetrics metrics;
    boolean wordWrap;
    ViewFactory viewFactory = new WrappedLineCreator();
    int selectionStart;
    int selectionEnd;
    int lineHeight;
    private int tabBase;
    private int tabSize;
    private transient Segment lineBuffer;

    public WrappedPlainView(Element element) {
        this(element, false);
    }

    public WrappedPlainView(Element element, boolean bl) {
        super(element, 1);
        this.wordWrap = bl;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    public float nextTabStop(float f, int n) {
        int n2 = (int)f;
        if (this.tabSize != 0) {
            int n3 = ((int)f - this.tabBase) / this.tabSize;
            n2 = this.tabBase + (n3 + 1) * this.tabSize;
        }
        return n2;
    }

    protected int getTabSize() {
        Object object = this.getDocument().getProperty("tabSize");
        if (object == null) {
            return 8;
        }
        return (Integer)object;
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        try {
            if (this.selectionStart == this.selectionEnd || n > this.selectionEnd || n2 < this.selectionStart) {
                this.drawUnselectedText(graphics, n3, n4, n, n2);
            } else if (n >= this.selectionStart && n2 <= this.selectionEnd) {
                this.drawSelectedText(graphics, n3, n4, n, n2);
            } else if (n >= this.selectionStart) {
                n3 = this.drawSelectedText(graphics, n3, n4, n, this.selectionEnd);
                this.drawUnselectedText(graphics, n3, n4, this.selectionEnd, n2);
            } else if (this.selectionStart > n && this.selectionEnd > n2) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.selectionStart);
                this.drawSelectedText(graphics, n3, n4, this.selectionStart, n2);
            } else if (this.selectionStart > n) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.selectionStart);
                n3 = this.drawSelectedText(graphics, n3, n4, this.selectionStart, this.selectionEnd);
                this.drawUnselectedText(graphics, n3, n4, this.selectionEnd, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, n3);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (jTextComponent.isEnabled()) {
            graphics.setColor(this.unselectedColor);
        } else {
            graphics.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, n3);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n == 0) {
            return;
        }
        View[] viewArray = new View[n];
        for (int i = 0; i < n; ++i) {
            viewArray[i] = new WrappedLine(element.getElement(i));
        }
        this.replace(0, 0, viewArray);
    }

    protected int calculateBreakPosition(int n, int n2) {
        Segment segment;
        block2: {
            segment = new Segment();
            try {
                this.getDocument().getText(n, n2 - n, segment);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Couldn't load text");
            }
        }
        int n3 = this.getWidth();
        int n4 = this.wordWrap ? n + Utilities.getBreakLocation(segment, this.metrics, this.tabBase, this.tabBase + n3, this, n) : n + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, this.tabBase + n3, this, n, false);
        return n4;
    }

    void updateMetrics() {
        Container container = this.getContainer();
        this.metrics = container.getFontMetrics(container.getFont());
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        return super.getPreferredSpan(n);
    }

    public float getMinimumSpan(int n) {
        this.updateMetrics();
        return super.getMinimumSpan(n);
    }

    public float getMaximumSpan(int n) {
        this.updateMetrics();
        return super.getMaximumSpan(n);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        View view = this.getViewAtPosition(documentEvent.getOffset(), rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        View view = this.getViewAtPosition(documentEvent.getOffset(), rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    private void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                viewArray[i] = new WrappedLine(elementArray2[i]);
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.updateMetrics();
        this.selectionStart = jTextComponent.getSelectionStart();
        this.selectionEnd = jTextComponent.getSelectionEnd();
        this.selectedColor = jTextComponent.getSelectedTextColor();
        this.unselectedColor = jTextComponent.getForeground();
        this.disabledColor = jTextComponent.getDisabledTextColor();
        this.selectedColor = jTextComponent.getSelectedTextColor();
        this.lineHeight = this.metrics.getHeight();
        graphics.setFont(jTextComponent.getFont());
        super.paint(graphics, shape);
    }

    public void setSize(float f, float f2) {
        this.updateMetrics();
        if (f != (float)this.getWidth()) {
            this.preferenceChanged(null, true, true);
        }
        super.setSize(f, f2);
    }

    class WrappedLine
    extends View {
        int numLines;

        public WrappedLine(Element element) {
            super(element);
            this.numLines = 1;
        }

        public void paint(Graphics graphics, Shape shape) {
            Highlighter highlighter;
            Rectangle rectangle = shape.getBounds();
            int n = this.getEndOffset();
            int n2 = this.getStartOffset();
            int n3 = 0;
            Container container = this.getContainer();
            LayeredHighlighter layeredHighlighter = null;
            JTextComponent jTextComponent = null;
            if (container instanceof JTextComponent && (highlighter = (jTextComponent = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
                layeredHighlighter = (LayeredHighlighter)highlighter;
            }
            while (n2 < n) {
                int n4 = WrappedPlainView.this.calculateBreakPosition(n2, n);
                if (layeredHighlighter != null) {
                    if (n4 == n) {
                        layeredHighlighter.paintLayeredHighlights(graphics, n2, n4 - 1, shape, jTextComponent, this);
                    } else {
                        layeredHighlighter.paintLayeredHighlights(graphics, n2, n4, shape, jTextComponent, this);
                    }
                }
                WrappedPlainView.this.drawLine(n2, n4, graphics, rectangle.x, rectangle.y + WrappedPlainView.this.metrics.getAscent());
                rectangle.y += WrappedPlainView.this.lineHeight;
                n2 = n4 == n2 ? ++n2 : n4;
                ++n3;
            }
            if (n3 != this.numLines) {
                this.numLines = n3;
                this.preferenceChanged(this, false, true);
            }
        }

        private int determineNumLines() {
            int n = 0;
            int n2 = this.getEndOffset();
            int n3 = this.getStartOffset();
            while (n3 < n2) {
                ++n;
                int n4 = WrappedPlainView.this.calculateBreakPosition(n3, n2);
                if (n4 == n3) {
                    n3 = n4 + 1;
                    continue;
                }
                n3 = n4;
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            if (n == 0) {
                return WrappedPlainView.this.getWidth();
            }
            if (n == 1) {
                if (WrappedPlainView.this.metrics == null) {
                    WrappedPlainView.this.updateMetrics();
                }
                return this.numLines * WrappedPlainView.this.metrics.getHeight();
            }
            throw new IllegalArgumentException("Invalid axis for getPreferredSpan: " + n);
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            int n2;
            Rectangle rectangle = shape.getBounds();
            if (rectangle.isEmpty()) {
                throw new BadLocationException("Unable to calculate view coordinates when allocation area is empty.", n);
            }
            Segment segment = WrappedPlainView.this.getLineBuffer();
            rectangle.height = n2 = WrappedPlainView.this.metrics.getHeight();
            rectangle.width = 1;
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            if (n < n3 || n >= n4) {
                throw new BadLocationException("invalid offset", n);
            }
            while (true) {
                int n5 = WrappedPlainView.this.calculateBreakPosition(n3, n4);
                if (n >= n3 && n < n5) {
                    try {
                        this.getDocument().getText(n3, n - n3, segment);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    rectangle.x += Utilities.getTabbedTextWidth(segment, WrappedPlainView.this.metrics, rectangle.x, WrappedPlainView.this, n3);
                    return rectangle;
                }
                rectangle.y += n2;
                if (n5 == n3) {
                    n3 = n4;
                    continue;
                }
                n3 = n5;
            }
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Segment segment = WrappedPlainView.this.getLineBuffer();
            Rectangle rectangle = shape.getBounds();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            int n3 = WrappedPlainView.this.metrics.getHeight();
            if (f2 < (float)rectangle.y) {
                return n;
            }
            if (f2 > (float)(rectangle.y + rectangle.height)) {
                return n2 - 1;
            }
            while (n != n2) {
                int n4 = WrappedPlainView.this.calculateBreakPosition(n, n2);
                if (f2 >= (float)rectangle.y && f2 < (float)(rectangle.y + n3)) {
                    try {
                        this.getDocument().getText(n, n4 - n, segment);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    int n5 = Utilities.getTabbedTextOffset(segment, WrappedPlainView.this.metrics, rectangle.x, (int)f, WrappedPlainView.this, n);
                    return n5 == n4 ? n5 - 1 : n5;
                }
                rectangle.y += n3;
                n = n4;
            }
            return n2;
        }

        void updateDamage(Rectangle rectangle) {
            int n = this.determineNumLines();
            if (this.numLines != n) {
                this.numLines = n;
                this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (rectangle != null) {
                this.getContainer().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.updateDamage(rectangle);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.updateDamage(rectangle);
        }
    }

    class WrappedLineCreator
    implements ViewFactory {
        WrappedLineCreator() {
        }

        public View create(Element element) {
            return new WrappedLine(element);
        }
    }
}

