/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int GoodBreakWeight = 1000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private Element elt;
    private View parent;

    public View(Element element) {
        this.elt = element;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View view) {
        if (view == null) {
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View view2 = this.getView(i);
                if (view2.getParent() != this) continue;
                view2.setParent(null);
            }
        }
        this.parent = view;
    }

    public View getParent() {
        return this.parent;
    }

    public Container getContainer() {
        View view = this.getParent();
        if (view == null) {
            return null;
        }
        return view.getContainer();
    }

    public Document getDocument() {
        return this.getElement().getDocument();
    }

    public Element getElement() {
        return this.elt;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int n) {
        return 0;
    }

    public float getMaximumSpan(int n) {
        float f = 2.1474836E9f;
        if (this.getResizeWeight(n) <= 0) {
            f = this.getPreferredSpan(n);
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        float f = 0.0f;
        if (this.getResizeWeight(n) <= 0) {
            f = this.getPreferredSpan(n);
        }
        return f;
    }

    public void setSize(float f, float f2) {
    }

    public float getAlignment(int n) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.getElement().getAttributes();
    }

    public boolean isVisible() {
        return true;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int n) {
        return null;
    }

    public ViewFactory getViewFactory() {
        View view = this.getParent();
        return view != null ? view.getViewFactory() : null;
    }

    public void replace(int n, int n2, View[] viewArray) {
    }

    public void insert(int n, View view) {
        View[] viewArray = new View[]{view};
        this.replace(n, 1, viewArray);
    }

    public void append(View view) {
        View[] viewArray = new View[]{view};
        int n = this.getViewCount();
        this.replace(n, 0, viewArray);
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), null);
    }

    public void remove(int n) {
        this.replace(n, 1, null);
    }

    public View createFragment(int n, int n2) {
        return this;
    }

    public int getStartOffset() {
        return this.getElement().getStartOffset();
    }

    public int getEndOffset() {
        return this.getElement().getEndOffset();
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return null;
    }

    public int getViewIndex(float f, float f2, Shape shape) {
        return -1;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        int n = this.getViewIndex(f, f2, shape);
        String string = null;
        if (n >= 0) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = (shape = this.getChildAllocation(n, shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (rectangle.contains(f, f2)) {
                string = this.getView(n).getToolTipText(f, f2, shape);
            }
        }
        return string;
    }

    public Graphics getGraphics() {
        return this.getContainer().getGraphics();
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        View view2 = this.getParent();
        if (view2 != null) {
            view2.preferenceChanged(this, bl, bl2);
        }
    }

    public int getBreakWeight(int n, float f, float f2) {
        int n2 = 0;
        if (f2 > this.getPreferredSpan(n)) {
            n2 = 1000;
        }
        return n2;
    }

    public View breakView(int n, int n2, float f, float f2) {
        return this;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return -1;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
            elementChange = null;
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        int n;
        Element[] elementArray = elementChange.getChildrenAdded();
        Element[] elementArray2 = elementChange.getChildrenRemoved();
        int n2 = elementChange.getIndex();
        View[] viewArray = null;
        if (elementArray != null) {
            viewArray = new View[elementArray.length];
            for (n = 0; n < elementArray.length; ++n) {
                viewArray[n] = viewFactory.create(elementArray[n]);
            }
        }
        n = elementArray2 != null ? elementArray2.length : 0;
        this.replace(n2, n, viewArray);
        return true;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n = this.getViewCount();
        if (n > 0) {
            Element[] elementArray;
            int n2;
            View view;
            int n3 = documentEvent.getOffset();
            int n4 = this.getViewIndex(n3, Position.Bias.Backward);
            if (n4 == -1 && documentEvent.getType() == DocumentEvent.EventType.REMOVE && n3 >= this.getEndOffset()) {
                n4 = this.getViewCount() - 1;
            }
            if (n4 >= 0 && (view = this.getView(n4)) != null && view.getStartOffset() == n3 && n3 > 0) {
                n4 = Math.max(0, n4 - 1);
            }
            int n5 = n4 = Math.max(0, n4);
            if (documentEvent.getType() != DocumentEvent.EventType.REMOVE && (n5 = this.getViewIndex(n3 + documentEvent.getLength(), Position.Bias.Forward)) < 0) {
                n5 = this.getViewCount() - 1;
            }
            int n6 = n2 = n5 + 1;
            Element[] elementArray2 = elementArray = elementChange != null ? elementChange.getChildrenAdded() : null;
            if (elementArray != null && elementArray.length > 0) {
                n2 = elementChange.getIndex();
                n6 = n2 + elementArray.length - 1;
            }
            for (int i = n4; i <= n5; ++i) {
                View view2;
                if (i >= n2 && i <= n6 || (view2 = this.getView(i)) == null) continue;
                Shape shape2 = this.getChildAllocation(i, shape);
                this.forwardUpdateToView(view2, documentEvent, shape2, viewFactory);
            }
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        DocumentEvent.EventType eventType = documentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.CHANGE) {
            view.changedUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null && shape != null) {
            this.preferenceChanged(null, true, true);
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Shape shape2;
        if (bias != Position.Bias.Forward && bias != Position.Bias.Backward) {
            throw new IllegalArgumentException("b1 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        if (bias2 != Position.Bias.Forward && bias2 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b2 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 != this.getEndOffset()) {
            shape2 = this.modelToView(n2, shape, bias2);
        } else {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle.x + rectangle.width - 1, rectangle.y, 1, rectangle.height);
            }
        }
        Rectangle rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        return SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return this.modelToView(n, shape, Position.Bias.Forward);
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public int viewToModel(float f, float f2, Shape shape) {
        Position.Bias[] biasArray = new Position.Bias[]{Position.Bias.Forward};
        return this.viewToModel(f, f2, shape, biasArray);
    }

    protected void dump() {
        View view = this.getParent();
        if (view != null) {
            view.dump();
        } else {
            this.dump(0);
        }
    }

    void dump(int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print('.');
        }
        System.out.println(this + "(" + this.getStartOffset() + "," + this.getEndOffset() + ": " + this.getElement());
        n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            this.getView(i).dump(n + 1);
        }
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = n;
        switch (n2) {
            case 3: {
                n3 = Math.min(n + 1, this.getEndOffset());
                break;
            }
            case 7: {
                n3 = Math.max(n - 1, this.getStartOffset());
                break;
            }
            case 1: {
                View view = this.getParent();
                Rectangle rectangle = view.modelToView(n, shape, bias).getBounds();
                n3 = view.viewToModel(rectangle.x, rectangle.y - 1, shape, biasArray);
                break;
            }
            case 5: {
                View view = this.getParent();
                Rectangle rectangle = view.modelToView(n, shape, bias).getBounds();
                n3 = view.viewToModel(rectangle.x + rectangle.width, rectangle.y + rectangle.height, shape, biasArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for d");
            }
        }
        return n3;
    }
}

