/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private static final long serialVersionUID = 2367703481999080593L;
    TabStop[] tabs;

    public TabSet(TabStop[] tabStopArray) {
        this.tabs = tabStopArray != null ? (TabStop[])tabStopArray.clone() : new TabStop[0];
    }

    public TabStop getTab(int n) {
        if (n < 0 || n >= this.tabs.length) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        return this.tabs[n];
    }

    public TabStop getTabAfter(float f) {
        int n = this.getTabIndexAfter(f);
        if (n == -1) {
            return null;
        }
        return this.tabs[n];
    }

    public int getTabCount() {
        return this.tabs.length;
    }

    public int getTabIndex(TabStop tabStop) {
        for (int i = 0; i < this.tabs.length; ++i) {
            if (this.tabs[i] != tabStop) continue;
            return i;
        }
        return -1;
    }

    public int getTabIndexAfter(float f) {
        for (int i = 0; i < this.tabs.length; ++i) {
            if (!(f <= this.tabs[i].getPosition())) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TabSet)) {
            return false;
        }
        TabSet tabSet = (TabSet)object;
        int n = this.getTabCount();
        if (n != tabSet.getTabCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getTab(i).equals(tabSet.getTab(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 193;
        int n2 = this.getTabCount();
        for (int i = 0; i < n2; ++i) {
            TabStop tabStop = this.getTab(i);
            if (tabStop == null) continue;
            n = 37 * n + tabStop.hashCode();
        }
        return n;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append("[ ");
        for (int i = 0; i < this.tabs.length; ++i) {
            if (i != 0) {
                cPStringBuilder.append(" - ");
            }
            cPStringBuilder.append(this.tabs[i].toString());
        }
        cPStringBuilder.append(" ]");
        return cPStringBuilder.toString();
    }
}

