/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static final long serialVersionUID = 8042858831190784241L;
    public static final String DEFAULT_STYLE = "default";
    static Hashtable sharedAttributeSets;
    static Hashtable sharedFonts;
    static StyleContext defaultStyleContext;
    static final int compressionThreshold = 9;
    private static Hashtable writeAttributeKeys;
    private static Hashtable readAttributeKeys;
    private NamedStyle styles;
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private transient Map attributeSetPool = Collections.synchronizedMap(new WeakHashMap());

    public StyleContext() {
        this.styles = new NamedStyle(null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(attributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.styles.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.styles.removeChangeListener(changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.styles.getChangeListeners();
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(string, style);
        if (string != null) {
            this.styles.addAttribute(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styles.removeAttribute(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styles.getAttribute(string);
    }

    public Enumeration<?> getStyleNames() {
        return this.styles.getAttributeNames();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.search = new SimpleAttributeSet();
        this.attributeSetPool = Collections.synchronizedMap(new WeakHashMap());
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.cleanupPool();
        objectOutputStream.defaultWriteObject();
    }

    public Font getFont(AttributeSet attributeSet) {
        String string = StyleConstants.getFontFamily(attributeSet);
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            ++n;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n += 2;
        }
        int n2 = StyleConstants.getFontSize(attributeSet);
        return this.getFont(string, n, n2);
    }

    public Font getFont(String string, int n, int n2) {
        SimpleFontSpec simpleFontSpec = new SimpleFontSpec(string, n, n2);
        if (sharedFonts.containsKey(simpleFontSpec)) {
            return (Font)sharedFonts.get(simpleFontSpec);
        }
        Font font = new Font(string, n, n2);
        sharedFonts.put(simpleFontSpec, font);
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    public static StyleContext getDefaultStyleContext() {
        if (defaultStyleContext == null) {
            defaultStyleContext = new StyleContext();
        }
        return defaultStyleContext;
    }

    @Override
    public synchronized AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        AttributeSet attributeSet2;
        if (attributeSet.getAttributeCount() + 1 < this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttribute(object, object2);
            this.reclaim(attributeSet);
            attributeSet2 = this.searchImmutableSet();
        } else {
            MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
            mutableAttributeSet.addAttribute(object, object2);
            attributeSet2 = mutableAttributeSet;
        }
        return attributeSet2;
    }

    @Override
    public synchronized AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        AttributeSet attributeSet3;
        if (attributeSet.getAttributeCount() + attributeSet2.getAttributeCount() < this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttributes(attributeSet2);
            this.reclaim(attributeSet);
            attributeSet3 = this.searchImmutableSet();
        } else {
            MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
            mutableAttributeSet.addAttributes(attributeSet2);
            attributeSet3 = mutableAttributeSet;
        }
        return attributeSet3;
    }

    @Override
    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    @Override
    public void reclaim(AttributeSet attributeSet) {
        this.cleanupPool();
    }

    @Override
    public synchronized AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        AttributeSet attributeSet2;
        if (attributeSet.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttribute(object);
            this.reclaim(attributeSet);
            attributeSet2 = this.searchImmutableSet();
        } else {
            MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
            mutableAttributeSet.removeAttribute(object);
            attributeSet2 = mutableAttributeSet;
        }
        return attributeSet2;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        AttributeSet attributeSet3;
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(attributeSet2);
            this.reclaim(attributeSet);
            attributeSet3 = this.searchImmutableSet();
        } else {
            MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
            mutableAttributeSet.removeAttributes(attributeSet2);
            attributeSet3 = mutableAttributeSet;
        }
        return attributeSet3;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        AttributeSet attributeSet2;
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(enumeration);
            this.reclaim(attributeSet);
            attributeSet2 = this.searchImmutableSet();
        } else {
            MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
            mutableAttributeSet.removeAttributes(enumeration);
            attributeSet2 = mutableAttributeSet;
        }
        return attributeSet2;
    }

    public static Object getStaticAttribute(Object object) {
        if (object == null) {
            return null;
        }
        return readAttributeKeys.get(object);
    }

    public static Object getStaticAttributeKey(Object object) {
        return object.getClass().getName() + "." + object.toString();
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (readAttributeKeys != null) {
                Object v;
                Object v2 = readAttributeKeys.get(object);
                if (v2 != null) {
                    object = v2;
                }
                if ((v = readAttributeKeys.get(object2)) != null) {
                    object2 = v;
                }
            }
            mutableAttributeSet.addAttribute(object, object2);
        }
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        int n = attributeSet.getAttributeCount();
        objectOutputStream.writeInt(n);
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object obj = enumeration.nextElement();
            if (obj instanceof Serializable) {
                objectOutputStream.writeObject(obj);
            } else {
                object = writeAttributeKeys.get(obj);
                if (object == null) {
                    throw new NotSerializableException(obj.getClass().getName() + ", key: " + obj);
                }
                objectOutputStream.writeObject(object);
            }
            object = attributeSet.getAttribute(obj);
            Object v = writeAttributeKeys.get(object);
            if (object instanceof Serializable) {
                objectOutputStream.writeObject(v != null ? v : object);
                continue;
            }
            if (v == null) {
                throw new NotSerializableException(object.getClass().getName());
            }
            objectOutputStream.writeObject(v);
        }
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(objectInputStream, mutableAttributeSet);
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        StyleContext.writeAttributeSet(objectOutputStream, attributeSet);
    }

    public static void registerStaticAttributeKey(Object object) {
        String string = object.getClass().getName() + "." + object.toString();
        if (writeAttributeKeys == null) {
            writeAttributeKeys = new Hashtable();
        }
        if (readAttributeKeys == null) {
            readAttributeKeys = new Hashtable();
        }
        writeAttributeKeys.put(object, string);
        readAttributeKeys.put(string, object);
    }

    public String toString() {
        this.cleanupPool();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object k : this.attributeSetPool.keySet()) {
            stringBuilder.append(k);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private AttributeSet searchImmutableSet() {
        SmallAttributeSet smallAttributeSet;
        SmallAttributeSet smallAttributeSet2 = this.createSmallAttributeSet(this.search);
        WeakReference weakReference = (WeakReference)this.attributeSetPool.get(smallAttributeSet2);
        if (weakReference == null || (smallAttributeSet = (SmallAttributeSet)weakReference.get()) == null) {
            smallAttributeSet = smallAttributeSet2;
            this.attributeSetPool.put(smallAttributeSet, new WeakReference<SmallAttributeSet>(smallAttributeSet));
        }
        return smallAttributeSet;
    }

    private void cleanupPool() {
        this.attributeSetPool.size();
    }

    private MutableAttributeSet getMutableAttributeSet(AttributeSet attributeSet) {
        MutableAttributeSet mutableAttributeSet = attributeSet instanceof MutableAttributeSet ? (MutableAttributeSet)attributeSet : this.createLargeAttributeSet(attributeSet);
        return mutableAttributeSet;
    }

    static {
        try {
            Iterator iterator = StyleConstants.keys.iterator();
            while (iterator.hasNext()) {
                StyleContext.registerStaticAttributeKey(iterator.next());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        sharedAttributeSets = new Hashtable();
        sharedFonts = new Hashtable();
    }

    private static class SimpleFontSpec {
        String family;
        int style;
        int size;

        public SimpleFontSpec(String string, int n, int n2) {
            this.family = string;
            this.style = n;
            this.size = n2;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof SimpleFontSpec && ((SimpleFontSpec)object).family.equals(this.family) && ((SimpleFontSpec)object).style == this.style && ((SimpleFontSpec)object).size == this.size;
        }

        public int hashCode() {
            return this.family.hashCode() + this.style + this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SmallAttributeSet
    implements AttributeSet {
        final Object[] attrs;
        private AttributeSet resolveParent;

        public SmallAttributeSet(AttributeSet attributeSet) {
            int n = attributeSet.getAttributeCount();
            int n2 = 0;
            this.attrs = new Object[n * 2];
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                if (obj == ResolveAttribute) {
                    this.resolveParent = (AttributeSet)object;
                }
                this.attrs[n2++] = obj;
                this.attrs[n2++] = object;
            }
        }

        public SmallAttributeSet(Object[] objectArray) {
            this.attrs = objectArray;
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (this.attrs[i] != ResolveAttribute) continue;
                this.resolveParent = (AttributeSet)this.attrs[i + 1];
            }
        }

        public Object clone() {
            return this;
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl = true;
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements() && bl) {
                Object obj = enumeration.nextElement();
                bl = attributeSet.getAttribute(obj).equals(this.getAttribute(obj));
            }
            return bl;
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof AttributeSet) {
                AttributeSet attributeSet = (AttributeSet)object;
                bl = this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            }
            return bl;
        }

        @Override
        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = null;
            if (object == StyleConstants.ResolveAttribute) {
                object2 = this.resolveParent;
            }
            for (int i = 0; i < this.attrs.length && object2 == null; i += 2) {
                if (!this.attrs[i].equals(object)) continue;
                object2 = this.attrs[i + 1];
            }
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        @Override
        public int getAttributeCount() {
            return this.attrs.length / 2;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return new Enumeration(){
                int i = 0;

                public boolean hasMoreElements() {
                    return this.i < SmallAttributeSet.this.attrs.length;
                }

                public Object nextElement() {
                    this.i += 2;
                    return SmallAttributeSet.this.attrs[this.i - 2];
                }
            };
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.resolveParent;
        }

        public int hashCode() {
            return Arrays.asList(this.attrs).hashCode();
        }

        @Override
        public boolean isDefined(Object object) {
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            boolean bl = attributeSet instanceof SmallAttributeSet ? attributeSet == this : this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (this.attrs[i + 1] instanceof AttributeSet) {
                    stringBuilder.append(this.attrs[i]);
                    stringBuilder.append("=AttributeSet,");
                    continue;
                }
                stringBuilder.append(this.attrs[i]);
                stringBuilder.append('=');
                stringBuilder.append(this.attrs[i + 1]);
                stringBuilder.append(',');
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NamedStyle
    implements Serializable,
    Style {
        private static final long serialVersionUID = -6690628971806226374L;
        protected transient ChangeEvent changeEvent;
        protected EventListenerList listenerList;
        private transient AttributeSet attributes;

        public NamedStyle() {
            this(null, null);
        }

        public NamedStyle(Style style) {
            this(null, style);
        }

        public NamedStyle(String string, Style style) {
            this.attributes = StyleContext.this.getEmptySet();
            this.listenerList = new EventListenerList();
            if (string != null) {
                this.setName(string);
            }
            if (style != null) {
                this.setResolveParent(style);
            }
        }

        @Override
        public String getName() {
            String string = null;
            if (this.isDefined(StyleConstants.NameAttribute)) {
                string = this.getAttribute(StyleConstants.NameAttribute).toString();
            }
            return string;
        }

        public void setName(String string) {
            if (string != null) {
                this.addAttribute(StyleConstants.NameAttribute, string);
            }
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }

        public <T extends EventListener> T[] getListeners(Class<T> clazz) {
            return this.listenerList.getListeners(clazz);
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.getListeners(ChangeListener.class);
        }

        protected void fireStateChanged() {
            ChangeListener[] changeListenerArray = this.getChangeListeners();
            for (int i = 0; i < changeListenerArray.length; ++i) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                changeListenerArray[i].stateChanged(this.changeEvent);
            }
        }

        @Override
        public void addAttribute(Object object, Object object2) {
            this.attributes = StyleContext.this.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
            this.attributes = StyleContext.this.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            NamedStyle namedStyle = new NamedStyle();
            namedStyle.attributes = this.attributes.copyAttributes();
            return namedStyle;
        }

        @Override
        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        @Override
        public void removeAttribute(Object object) {
            this.attributes = StyleContext.this.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
            } else {
                this.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(objectInputStream, this);
        }
    }
}

