/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = 4755994433709540381L;
    char[] content;
    private int count;
    Vector marks;
    private static final char[] EMPTY = new char[0];
    ReferenceQueue queueOfDeath = new ReferenceQueue();

    public StringContent() {
        this(10);
    }

    public StringContent(int n) {
        if (n < 1) {
            n = 1;
        }
        this.content = new char[n];
        this.content[0] = 10;
        this.count = 1;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        Vector vector2 = vector == null ? new Vector() : vector;
        for (Mark mark : this.marks) {
            if (n > mark.mark || mark.mark > n + n2) continue;
            vector2.add(new UndoPosRef(mark));
        }
        return vector2;
    }

    public Position createPosition(int n) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        StickyPosition stickyPosition = new StickyPosition(n);
        return stickyPosition;
    }

    public int length() {
        return this.count;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        Object object;
        this.checkLocation(n, 0);
        if (n == this.count) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        char[] cArray = string.toCharArray();
        this.replace(n, 0, cArray);
        if (this.marks != null) {
            object = this.marks.iterator();
            int n2 = n;
            if (n2 == 0) {
                n2 = 1;
            }
            while (object.hasNext()) {
                Mark mark = (Mark)object.next();
                if (mark.mark < n2) continue;
                mark.mark += string.length();
            }
        }
        object = new InsertUndo(n, cArray.length);
        return object;
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        this.checkLocation(n, n2 + 1);
        RemoveUndo removeUndo = new RemoveUndo(n, new String(this.content, n, n2));
        this.replace(n, n2, EMPTY);
        if (this.marks != null) {
            for (Mark mark : this.marks) {
                if (mark.mark >= n + n2) {
                    mark.mark -= n2;
                    continue;
                }
                if (mark.mark < n) continue;
                mark.mark = n;
            }
        }
        return removeUndo;
    }

    private void replace(int n, int n2, char[] cArray) {
        int n3 = cArray.length;
        int n4 = n3 - n2;
        int n5 = n + n2;
        int n6 = this.count - n5;
        int n7 = n5 + n4;
        if (this.count + n4 >= this.content.length) {
            int n8 = Math.max(2 * this.content.length, this.count + n4);
            char[] cArray2 = new char[n8];
            System.arraycopy(this.content, 0, cArray2, 0, n);
            System.arraycopy(cArray, 0, cArray2, n, n3);
            System.arraycopy(this.content, n5, cArray2, n7, n6);
            this.content = cArray2;
        } else {
            System.arraycopy(this.content, n5, this.content, n7, n6);
            System.arraycopy(cArray, 0, this.content, n, n3);
        }
        this.count += n4;
    }

    public String getString(int n, int n2) throws BadLocationException {
        this.checkLocation(n, n2);
        return new String(this.content, n, n2);
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        if (n + n2 > this.count) {
            throw new BadLocationException("Invalid location", n + n2);
        }
        segment.array = this.content;
        segment.offset = n;
        segment.count = n2;
    }

    protected void updateUndoPositions(Vector vector) {
        for (UndoPosRef undoPosRef : vector) {
            undoPosRef.reset();
        }
    }

    void checkLocation(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (n > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        if (n + n2 > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
    }

    void garbageCollect() {
        Reference reference = this.queueOfDeath.poll();
        while (reference != null) {
            if (reference != null) {
                StickyPosition stickyPosition = (StickyPosition)reference.get();
                Mark mark = stickyPosition.mark;
                --mark.refCount;
                if (mark.refCount == 0) {
                    this.marks.remove(mark);
                }
            }
            reference = this.queueOfDeath.poll();
        }
    }

    private class StickyPosition
    implements Position {
        Mark mark;

        public StickyPosition(int n) {
            StringContent.this.garbageCollect();
            this.mark = new Mark(n);
            ++this.mark.refCount;
            StringContent.this.marks.add(this.mark);
            new WeakReference<StickyPosition>(this, StringContent.this.queueOfDeath);
        }

        public int getOffset() {
            return this.mark.mark;
        }
    }

    private class RemoveUndo
    extends AbstractUndoableEdit {
        private int start;
        private int len;
        private String undoString;
        Vector positions;

        public RemoveUndo(int n, String string) {
            this.start = n;
            this.len = string.length();
            this.undoString = string;
            if (StringContent.this.marks != null) {
                this.positions = StringContent.this.getPositionsInRange(null, n, string.length());
            }
        }

        public void undo() {
            super.undo();
            try {
                StringContent.this.insertString(this.start, this.undoString);
                if (this.positions != null) {
                    StringContent.this.updateUndoPositions(this.positions);
                    this.positions = null;
                }
                this.undoString = null;
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                this.undoString = StringContent.this.getString(this.start, this.len);
                if (StringContent.this.marks != null) {
                    this.positions = StringContent.this.getPositionsInRange(null, this.start, this.len);
                }
                StringContent.this.remove(this.start, this.len);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class InsertUndo
    extends AbstractUndoableEdit {
        private int start;
        private int length;
        private String redoContent;
        private Vector positions;

        public InsertUndo(int n, int n2) {
            this.start = n;
            this.length = n2;
        }

        public void undo() {
            super.undo();
            try {
                if (StringContent.this.marks != null) {
                    this.positions = StringContent.this.getPositionsInRange(null, this.start, this.length);
                }
                this.redoContent = StringContent.this.getString(this.start, this.length);
                StringContent.this.remove(this.start, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                StringContent.this.insertString(this.start, this.redoContent);
                this.redoContent = null;
                if (this.positions != null) {
                    StringContent.this.updateUndoPositions(this.positions);
                    this.positions = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class Mark {
        int mark;
        int refCount;

        Mark(int n) {
            this.mark = n;
        }
    }

    private class UndoPosRef {
        private Mark mark;
        private int undoOffset;

        UndoPosRef(Mark mark) {
            this.mark = mark;
            this.undoOffset = this.mark.mark;
        }

        void reset() {
            this.mark.mark = this.undoOffset;
        }
    }
}

